/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.ui.configuration.IHistoryEntry;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.labelproviders.AbstractPlannedForFunction;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;

public class PlannedForFunction
extends AbstractPlannedForFunction<IHistoryEntry> {
    Map<ItemId<IChangeSet>, IHistoryEntry> changeSetIdToHistoryEntryMap = new HashMap<ItemId<IChangeSet>, IHistoryEntry>();

    public PlannedForFunction(ISetWithListeners<IHistoryEntry> domain, IOperationRunner runner, Display display, boolean isLazy) {
        super(domain, runner, display, isLazy);
    }

    @Override
    protected IHistoryEntry getViewObjectForChangeSet(IChangeSetHandle changeSetHandle) {
        return this.changeSetIdToHistoryEntryMap.get(ItemId.create((IItemHandle)changeSetHandle));
    }

    @Override
    protected ITeamRepository getRepository(IHistoryEntry historyEntry) {
        return historyEntry.getRepository();
    }

    @Override
    protected Collection<ChangeSetWrapper> getChangeSetsForViewObjects(Collection<IHistoryEntry> toFetch) {
        ArrayList<ChangeSetWrapper> changeSetWrappers = new ArrayList<ChangeSetWrapper>(toFetch.size());
        for (IHistoryEntry historyEntry : toFetch) {
            ChangeSetWrapper changeSetWrapper = historyEntry.getChangeSet();
            if (changeSetWrapper == null) continue;
            ItemId changeSetItemId = ItemId.forItem((IItem)changeSetWrapper.getChangeSet());
            this.changeSetIdToHistoryEntryMap.put((ItemId<IChangeSet>)changeSetItemId, historyEntry);
            changeSetWrappers.add(historyEntry.getChangeSet());
        }
        return changeSetWrappers;
    }
}

