/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.CoreShareablesUtil;
import com.ibm.team.filesystem.rcp.core.patches.PatchFile;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.views.PatchedDirectory;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.SlowFunction;
import com.ibm.team.repository.rcp.ui.labelproviders.ListeningLabelProvider;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class PatchLabelProvider
extends ListeningLabelProvider {
    private Image patchDirectoryImage = (Image)this.getResources().get((DeviceResourceDescriptor)UiPlugin.getFileSystemImageDescriptor(null));
    private ConvertingLabelProvider directoryLabelProvider;
    private ILabelProviderListener listener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            PatchLabelProvider.this.fireChangeEvent(event.getElements());
        }
    };

    public PatchLabelProvider() {
        JobRunner jobRunner = new JobRunner(false);
        this.directoryLabelProvider = new ConvertingLabelProvider((IViewerLabelProvider)new BaseLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                label.setText((String)element);
                label.setImage(PatchLabelProvider.this.patchDirectoryImage);
            }
        }, (IDynamicFunction)new SlowFunction<PatchedDirectory, String>(this.getKnownElements(), (IOperationRunner)jobRunner, Display.getCurrent(), true){

            protected Map<PatchedDirectory, String> doFetch(Collection<PatchedDirectory> toFetch, IProgressMonitor reporter) throws OperationFailedException {
                HashMap<PatchedDirectory, String> result = new HashMap<PatchedDirectory, String>();
                for (PatchedDirectory next : toFetch) {
                    IShareable shareable = null;
                    try {
                        shareable = CoreShareablesUtil.getShareableFor((VersionablePath)next.getPath(), null);
                    }
                    catch (TeamRepositoryException teamRepositoryException) {
                        // empty catch block
                    }
                    IResource resource = null;
                    if (shareable != null) {
                        resource = (IResource)shareable.getAdapter(IResource.class);
                    }
                    if (resource != null) {
                        result.put(next, resource.getFullPath().makeRelative().toString());
                        continue;
                    }
                    if (shareable != null) {
                        result.put(next, shareable.getLocalPath().toString());
                        continue;
                    }
                    result.put(next, next.getPath().toPath().makeRelative().toString());
                }
                return result;
            }

            protected String getDefaultValue() {
                return "";
            }

            protected String getOperationName() {
                return Messages.PatchLabelProvider_0;
            }
        });
        this.directoryLabelProvider.addListener(this.listener);
    }

    public void dispose() {
        this.directoryLabelProvider.removeListener(this.listener);
        super.dispose();
    }

    public void doUpdateLabel(ViewerLabel label, Object element) {
        if (element instanceof PatchedDirectory) {
            this.directoryLabelProvider.updateLabel(label, element);
            return;
        }
        if (element instanceof PatchFile) {
            PatchFile pf = (PatchFile)element;
            String filename = pf.getVersionablePath().getFileName();
            label.setText(filename);
            label.setImage((Image)this.getResources().get((DeviceResourceDescriptor)UiPlugin.getFileSystemImageDescriptor(filename)));
            return;
        }
    }
}

