/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.ui.wrapper.MissingWorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.HashSet;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class MissingWorkspaceComponentLabelProvider
extends BaseLabelProvider {
    public void updateLabel(ViewerLabel label, Object element) {
        if (element instanceof MissingWorkspaceComponentWrapper) {
            MissingWorkspaceComponentWrapper wrapper = (MissingWorkspaceComponentWrapper)element;
            if (wrapper.getComponent() != null) {
                IComponent component = wrapper.getComponent();
                String notInWorkspace = wrapper.getWorkspace().isStream() ? Messages.MissingWorkspaceComponentLabelProvider_NOT_IN_STREAM_DECORATOR : Messages.MissingWorkspaceComponentLabelProvider_NOT_IN_WORKSPACE_DECORATOR;
                label.setText(NLS.bind((String)Messages.MissingWorkspaceComponentLabelProvider_LABEL_DECORATOR_SUBSTITUTION, (Object)component.getName(), (Object)notInWorkspace));
            } else {
                String labelText = NLS.bind((String)Messages.MissingWorkspaceComponentLabelProvider_INACCESSIBLE_COMPONENT_LABEL, (Object)wrapper.getComponentHandle().getItemId().getUuidValue());
                IComponentHandle componentHandle = wrapper.getComponentHandle();
                HashSet<UUID> allInaccessibleComponentsInWorkspace = new HashSet<UUID>();
                try {
                    for (IComponentHandle c : wrapper.getWorkspaceConnection().getUnreadableComponents()) {
                        allInaccessibleComponentsInWorkspace.add(c.getItemId());
                    }
                }
                catch (TeamRepositoryException c) {
                    // empty catch block
                }
                if (!allInaccessibleComponentsInWorkspace.contains(componentHandle.getItemId())) {
                    String notInWorkspace = wrapper.getWorkspace().isStream() ? Messages.MissingWorkspaceComponentLabelProvider_NOT_IN_STREAM_DECORATOR : Messages.MissingWorkspaceComponentLabelProvider_NOT_IN_WORKSPACE_DECORATOR;
                    labelText = NLS.bind((String)Messages.MissingWorkspaceComponentLabelProvider_LABEL_DECORATOR_SUBSTITUTION, (Object)labelText, (Object)notInWorkspace);
                }
                label.setText(labelText);
            }
            label.setImage((Image)this.getResources().get((DeviceResourceDescriptor)ImagePool.COMPONENT_UNLOADED));
        }
    }
}

