/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.item.ItemListenerUtil;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewer;
import com.ibm.team.internal.filesystem.ui.labelproviders.ChangeSetDateFunction;
import com.ibm.team.internal.filesystem.ui.labelproviders.ChangeSetToChangeDescriptionFunction;
import com.ibm.team.internal.filesystem.ui.labelproviders.ChangeSetToWorkItemSummaryLabelProvider;
import com.ibm.team.internal.filesystem.ui.labelproviders.ComponentShortLabelProvider;
import com.ibm.team.internal.filesystem.ui.labelproviders.DateLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.ChangeSetAuthorFunction;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.ChangeSetComponentFunction;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import com.ibm.team.repository.rcp.ui.labelproviders.ListeningLabelProvider;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class MaskableChangeSetLabelProvider
extends ListeningLabelProvider {
    private static final String WORK_ITEM_DESCRIPTION = "{0}";
    private static final String COMPONENT_NAME = "{1}";
    private static final String AUTHOR = "{2}";
    private static final String DATE = "{3}";
    private static final String CHANGE_SET_COMMENT = "{4}";
    private ConvertingLabelProvider workItemLabel;
    private ConvertingLabelProvider usernameLabel;
    private ConvertingLabelProvider dateLabel;
    private ConvertingLabelProvider componentLabel;
    private String verboseLabel;
    private boolean includeComment = false;
    private Set<ChangeSetWrapper> enqueuedEvents = new HashSet<ChangeSetWrapper>();
    private boolean allItemsEnqueued = false;
    private int enqueueCounter = 0;
    private boolean customMarkup = false;
    private ILabelProviderListener labelListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] elements = event.getElements();
            if (elements == null) {
                MaskableChangeSetLabelProvider.this.allItemsEnqueued = true;
                MaskableChangeSetLabelProvider.this.enqueuedEvents.clear();
            } else if (!MaskableChangeSetLabelProvider.this.allItemsEnqueued) {
                int i = 0;
                while (i < elements.length) {
                    ChangeSetWrapper next = (ChangeSetWrapper)((Object)elements[i]);
                    MaskableChangeSetLabelProvider.this.enqueuedEvents.add(next);
                    ++i;
                }
            }
            MaskableChangeSetLabelProvider.this.enqueueChange();
        }
    };
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (UiPlugin.isChangeProperty(event.getProperty())) {
                MaskableChangeSetLabelProvider.this.allItemsEnqueued = true;
                MaskableChangeSetLabelProvider.this.enqueueChange();
            }
        }
    };
    private ISharedItemChangeListener changeSetListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            final HashSet changed = NewCollection.hashSet();
            for (ISharedItemChangeEvent event : events) {
                IItem item = event.getSharedItem();
                if (!(item instanceof IChangeSet)) continue;
                IChangeSet changeSet = (IChangeSet)item;
                ChangeSetWrapper csw = new ChangeSetWrapper(event.getItemManager().teamRepository(), changeSet);
                changed.add(csw);
            }
            SWTUtil.greedyExec((Display)MaskableChangeSetLabelProvider.this.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!MaskableChangeSetLabelProvider.this.allItemsEnqueued) {
                        for (ChangeSetWrapper next : changed) {
                            MaskableChangeSetLabelProvider.this.enqueuedEvents.add(next);
                        }
                    }
                    MaskableChangeSetLabelProvider.this.enqueueChange();
                }
            });
        }
    };

    public MaskableChangeSetLabelProvider(String verboseLabel, boolean customMarkup, ISetWithListeners<ChangeSetWrapper> changeSets, IOperationRunner operationRunner) {
        super(changeSets);
        this.verboseLabel = verboseLabel;
        this.workItemLabel = new ConvertingLabelProvider((IViewerLabelProvider)new ChangeSetToWorkItemSummaryLabelProvider(), (IDynamicFunction)new ChangeSetToChangeDescriptionFunction(changeSets, operationRunner, true));
        this.workItemLabel.addListener(this.labelListener);
        if (verboseLabel.contains(COMPONENT_NAME)) {
            ChangeSetComponentFunction changeSetComponents = new ChangeSetComponentFunction(changeSets, operationRunner, Display.getCurrent(), true);
            this.componentLabel = new ConvertingLabelProvider((IViewerLabelProvider)new ComponentShortLabelProvider(changeSetComponents.getRange(), operationRunner), (IDynamicFunction)changeSetComponents);
            this.componentLabel.addListener(this.labelListener);
        }
        if (verboseLabel.contains(AUTHOR)) {
            ChangeSetAuthorFunction changeSetAuthor = new ChangeSetAuthorFunction((ISetWithListeners<? extends ChangeSetWrapper>)changeSets, operationRunner);
            this.usernameLabel = new ConvertingLabelProvider(LabelProviders.create((ISetWithListeners)changeSetAuthor.getRange()), (IDynamicFunction)changeSetAuthor);
            this.usernameLabel.addListener(this.labelListener);
        }
        if (verboseLabel.contains(DATE)) {
            ChangeSetDateFunction changeSetDates = new ChangeSetDateFunction(changeSets, true);
            this.dateLabel = new ConvertingLabelProvider((IViewerLabelProvider)new DateLabelProvider(), (IDynamicFunction)changeSetDates);
            this.dateLabel.addListener(this.labelListener);
        }
        if (verboseLabel.contains(CHANGE_SET_COMMENT)) {
            this.includeComment = true;
        }
        UiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void elementAdded(Object element) {
        ChangeSetWrapper csw = (ChangeSetWrapper)((Object)element);
        if (this.includeComment) {
            ItemListenerUtil.addListener((IItem)csw.getChangeSet(), this.changeSetListener);
        }
        super.elementAdded(element);
    }

    protected void elementRemoved(Object element) {
        ChangeSetWrapper csw = (ChangeSetWrapper)((Object)element);
        if (this.includeComment) {
            ItemListenerUtil.removeListener((IItem)csw.getChangeSet(), this.changeSetListener);
        }
        super.elementRemoved(element);
    }

    public void doUpdateLabel(ViewerLabel label, Object element) {
        ChangeSetWrapper csw = (ChangeSetWrapper)((Object)element);
        this.workItemLabel.updateLabel(label, element);
        String commentString = csw.getChangeSet().getComment();
        String workItemString = label.getText();
        String componentString = MaskableChangeSetLabelProvider.getText((IViewerLabelProvider)this.componentLabel, (Object)csw);
        String authorString = CustomTreeViewer.markupName(MaskableChangeSetLabelProvider.getText((IViewerLabelProvider)this.usernameLabel, (Object)csw), this.customMarkup);
        String dateString = MaskableChangeSetLabelProvider.getText((IViewerLabelProvider)this.dateLabel, (Object)csw);
        String formatter = this.applyHints(this.verboseLabel, csw);
        if (commentString.isEmpty()) {
            if (formatter.contains(WORK_ITEM_DESCRIPTION) && !workItemString.isEmpty()) {
                formatter = this.removeField(formatter, CHANGE_SET_COMMENT);
            } else {
                commentString = Messages.MaskableChangeSetLabelProvider_noComment;
            }
        }
        if (workItemString.isEmpty()) {
            formatter = this.removeField(formatter, WORK_ITEM_DESCRIPTION);
        }
        label.setText(NLS.bind((String)formatter, (Object[])new String[]{workItemString, componentString, authorString, dateString, commentString}));
    }

    protected void enqueueChange() {
        ++this.enqueueCounter;
        SWTUtil.greedyExec((Display)this.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                MaskableChangeSetLabelProvider maskableChangeSetLabelProvider = MaskableChangeSetLabelProvider.this;
                maskableChangeSetLabelProvider.enqueueCounter = maskableChangeSetLabelProvider.enqueueCounter - 1;
                if (MaskableChangeSetLabelProvider.this.enqueueCounter > 0) {
                    return;
                }
                boolean allItems = MaskableChangeSetLabelProvider.this.allItemsEnqueued;
                ArrayList changedItems = new ArrayList();
                changedItems.addAll(MaskableChangeSetLabelProvider.this.enqueuedEvents);
                MaskableChangeSetLabelProvider.this.enqueuedEvents.clear();
                MaskableChangeSetLabelProvider.this.allItemsEnqueued = false;
                if (allItems) {
                    MaskableChangeSetLabelProvider.this.fireAllElementsChangedEvent();
                } else {
                    MaskableChangeSetLabelProvider.this.fireChangeEvent(changedItems);
                }
            }
        });
    }

    private String applyHints(String formatter, ChangeSetWrapper changeSetWrapper) {
        String result = formatter;
        if (changeSetWrapper.shouldHideWorkItemDescription()) {
            result = this.removeField(result, WORK_ITEM_DESCRIPTION);
        }
        if (changeSetWrapper.shouldHideComponent()) {
            result = this.removeField(result, COMPONENT_NAME);
        }
        if (changeSetWrapper.shouldHideAuthor()) {
            result = this.removeField(result, AUTHOR);
        }
        if (changeSetWrapper.shouldHideDate()) {
            result = this.removeField(result, DATE);
        }
        if (changeSetWrapper.shouldHideComment()) {
            result = this.removeField(result, CHANGE_SET_COMMENT);
        }
        return result;
    }

    private String removeField(String format, String field) {
        return this.removeDash(format.replace(field, ""));
    }

    private String removeDash(String format) {
        if (format.startsWith(" - ")) {
            return format.substring(3, format.length());
        }
        if (format.endsWith(" - ")) {
            return format.substring(0, format.length() - 3);
        }
        return format.replace(" -  - ", " - ");
    }

    private static String getText(IViewerLabelProvider labelProvider, Object element) {
        if (labelProvider == null) {
            return "";
        }
        ViewerLabel vl = new ViewerLabel("", null);
        labelProvider.updateLabel(vl, element);
        return vl.getText();
    }

    public void dispose() {
        if (this.workItemLabel != null) {
            this.workItemLabel.removeListener(this.labelListener);
            this.workItemLabel.dispose();
        }
        if (this.usernameLabel != null) {
            this.usernameLabel.removeListener(this.labelListener);
            this.usernameLabel.dispose();
        }
        if (this.componentLabel != null) {
            this.componentLabel.removeListener(this.labelListener);
            this.componentLabel.dispose();
        }
        if (this.dateLabel != null) {
            this.dateLabel.removeListener(this.labelListener);
            this.dateLabel.dispose();
        }
        if (this.propertyChangeListener != null) {
            UiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        super.dispose();
    }
}

