/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.rcp.core.internal.patches.AbstractStateChangeOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.ApplyHunkOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.ClearFileContentsOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.CreateEmptyFileOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.CreateFolderOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.DeleteFolderOp;
import com.ibm.team.filesystem.rcp.core.internal.patches.MoveFileOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchOp;
import com.ibm.team.filesystem.rcp.core.patches.PatchOpHandle;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.labelproviders.ListeningLabelProvider;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class LocalFileOpLabelProvider
extends ListeningLabelProvider {
    private WeakHashMap<MoveFileOp, IPath> resolvedMovePaths = new WeakHashMap();
    private IOperationRunner runner;
    private Set<PatchOpHandle> toResolve = new HashSet<PatchOpHandle>();
    private boolean synchEnqueued;
    private Operation synchronizeRunnable = new RepositoryOperation(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
            final ArrayList resolveCopy = new ArrayList();
            Set set = LocalFileOpLabelProvider.this.toResolve;
            synchronized (set) {
                resolveCopy.addAll(LocalFileOpLabelProvider.this.toResolve);
                LocalFileOpLabelProvider.this.toResolve.clear();
                LocalFileOpLabelProvider.this.synchEnqueued = false;
            }
            final HashMap<MoveFileOp, IPath> resolvedPaths = new HashMap<MoveFileOp, IPath>();
            SubMonitor loopProgress = SubMonitor.convert((IProgressMonitor)monitor, (int)resolveCopy.size());
            for (PatchOpHandle nextOp : resolveCopy) {
                PatchOp next = nextOp.getOp();
                SubMonitor iterationProgress = loopProgress.newChild(1);
                if (!(next instanceof MoveFileOp)) continue;
                MoveFileOp move = (MoveFileOp)next;
                resolvedPaths.put(move, move.getTargetPath().getResource((IProgressMonitor)iterationProgress).getFullPath());
            }
            SWTUtil.greedyExec((Display)LocalFileOpLabelProvider.this.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    LocalFileOpLabelProvider.this.resolvedMovePaths.putAll(resolvedPaths);
                    LocalFileOpLabelProvider.this.fireChangeEvent(resolveCopy);
                }
            });
        }
    };

    public LocalFileOpLabelProvider() {
        this.runner = new JobRunner(false);
    }

    public LocalFileOpLabelProvider(IOperationRunner runner, ISetWithListeners knownElements) {
        super(knownElements);
        this.runner = runner;
    }

    protected void doUpdateLabel(ViewerLabel label, Object element) {
        IItemType itemType;
        PatchOpHandle hunk = (PatchOpHandle)element;
        String changeDescription = Messages.LocalFileOpLabelProvider_0;
        PatchOp op = hunk.getOp();
        ImageDescriptor imageDescriptor = null;
        if (op instanceof ApplyHunkOp) {
            ApplyHunkOp applyHunk = (ApplyHunkOp)op;
            changeDescription = "";
            if (!applyHunk.isCreate() && !applyHunk.isDelete()) {
                changeDescription = NLS.bind((String)Messages.LocalFileOpLabelProvider_3, (Object)applyHunk.getPatchedLineCount());
            }
        } else if (op instanceof CreateEmptyFileOp) {
            changeDescription = Messages.LocalFileOpLabelProvider_4;
        } else if (op instanceof ClearFileContentsOp) {
            changeDescription = Messages.LocalFileOpLabelProvider_5;
        } else if (op instanceof MoveFileOp) {
            MoveFileOp move = (MoveFileOp)op;
            IPath targetPath = this.resolvedMovePaths.get(move);
            if (targetPath != null) {
                changeDescription = NLS.bind((String)Messages.LocalFileOpLabelProvider_6, (Object)targetPath.toString());
            } else {
                changeDescription = Messages.LocalFileOpLabelProvider_7;
                this.enqueueFetch(hunk);
            }
        } else if (op instanceof AbstractStateChangeOp) {
            changeDescription = "";
        } else if (op instanceof CreateFolderOp) {
            changeDescription = Messages.LocalFileOpLabelProvider_9;
        } else if (op instanceof DeleteFolderOp) {
            changeDescription = Messages.LocalFileOpLabelProvider_10;
        }
        if ((itemType = op.getItemType()) != null && itemType.equals(ISymbolicLink.ITEM_TYPE)) {
            imageDescriptor = ImagePool.SYMBOLIC_LINK;
        }
        String statusMessage = "";
        IStatus status = hunk.getModel().getResult(hunk);
        if (status != null && !status.isOK()) {
            statusMessage = NLS.bind((String)Messages.LocalFileOpLabelProvider_12, (Object)status.getMessage());
        }
        String lastSegment = hunk.getFilePath().getFileName();
        String fullLabel = changeDescription.equals("") ? NLS.bind((String)Messages.LocalFileOpLabelProvider_14, (Object[])new String[]{lastSegment, statusMessage}) : NLS.bind((String)Messages.LocalFileOpLabelProvider_15, (Object[])new String[]{lastSegment, changeDescription, statusMessage});
        if (imageDescriptor == null) {
            imageDescriptor = UiPlugin.getFileSystemImageDescriptor(lastSegment);
        }
        label.setText(fullLabel);
        label.setImage((Image)this.getResources().get((DeviceResourceDescriptor)imageDescriptor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueFetch(PatchOpHandle move) {
        Set<PatchOpHandle> set = this.toResolve;
        synchronized (set) {
            this.toResolve.add(move);
            if (!this.synchEnqueued) {
                this.runner.enqueue(Messages.LocalFileOpLabelProvider_16, this.synchronizeRunnable);
            }
        }
    }
}

