/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.common.internal.util.StringUtils;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.SymbolicLinkItemWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.labelproviders.ListeningLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.ui.PlatformUI;

public class FileSearchLabelProvider
extends ListeningLabelProvider {
    public static final String FILE_NAME_FORMAT_STR = "{0}";
    public static final String FILE_NAME_PATH_FORMAT_STR = "{1}";
    public static final String FILE_NAME_COMPONENT_FORMAT_STR = "{2}";
    public static final String FILE_NAME_VERSION_ID_FORMAT_STR = "{3}";
    private boolean fShouldShowIcon = true;
    private String fFormatString;

    public FileSearchLabelProvider(String formatString, ISetWithListeners<AbstractFileSystemItemWrapper> files) {
        super(files);
        if (formatString == null && StringUtils.isEmpty((String)formatString)) {
            throw new IllegalArgumentException("formatString cannot be null");
        }
        this.init(formatString);
    }

    private void init(String formatString) {
        this.fFormatString = formatString;
        if (formatString.equals(FILE_NAME_FORMAT_STR)) {
            this.setShouldShowIcon(true);
        } else {
            this.setShouldShowIcon(false);
        }
    }

    protected void doUpdateLabel(ViewerLabel label, Object element) {
        AbstractFileSystemItemWrapper wrapper;
        AbstractFileSystemItemWrapper abstractFileSystemItemWrapper = wrapper = element instanceof AbstractFileSystemItemWrapper ? (AbstractFileSystemItemWrapper)((Object)element) : null;
        if (this.isShouldShowIcon()) {
            if (wrapper instanceof FileItemWrapper) {
                label.setImage(this.getImage(PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(wrapper.getName())));
            } else if (wrapper instanceof SymbolicLinkItemWrapper) {
                label.setImage(this.getImage(ImagePool.SYMBOLIC_LINK));
            }
        }
        if (this.fFormatString.equals(FILE_NAME_FORMAT_STR)) {
            this.setWrapperNameAsLabelText(wrapper, label);
        } else if (this.fFormatString.equals(FILE_NAME_PATH_FORMAT_STR)) {
            this.setWrapperPathAsLabelText(wrapper, label);
        } else if (this.fFormatString.equals(FILE_NAME_COMPONENT_FORMAT_STR)) {
            this.setWrapperComponentAsLabelText(wrapper, label);
        } else if (this.fFormatString.equals(FILE_NAME_VERSION_ID_FORMAT_STR)) {
            this.setWrapperVersionIdAsLabelText(wrapper, label);
        }
    }

    private void setWrapperNameAsLabelText(AbstractFileSystemItemWrapper wrapper, ViewerLabel label) {
        label.setText(wrapper.getName());
    }

    private void setWrapperPathAsLabelText(AbstractFileSystemItemWrapper wrapper, ViewerLabel label) {
        label.setText(wrapper.getPath());
    }

    private void setWrapperComponentAsLabelText(AbstractFileSystemItemWrapper wrapper, ViewerLabel label) {
        String text = wrapper.getComponent() != null ? wrapper.getComponent().getName() : Messages.ChangeSummaryView_unknownFileLabel;
        label.setText(text);
    }

    private void setWrapperVersionIdAsLabelText(AbstractFileSystemItemWrapper wrapper, ViewerLabel label) {
        label.setText(!StringUtils.isEmpty((String)wrapper.getVersionNumber()) ? wrapper.getVersionNumber() : "");
    }

    public void dispose() {
        super.dispose();
    }

    public boolean isShouldShowIcon() {
        return this.fShouldShowIcon;
    }

    public void setShouldShowIcon(boolean shouldShowIcon) {
        this.fShouldShowIcon = shouldShowIcon;
    }
}

