/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewer;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;

public class FileItemLabelProvider
extends BaseLabelProvider {
    private final boolean customMarkup;

    public FileItemLabelProvider() {
        this(false);
    }

    public FileItemLabelProvider(boolean customMarkup) {
        this.customMarkup = customMarkup;
    }

    public void updateLabel(ViewerLabel label, Object element) {
        FileItemWrapper file = (FileItemWrapper)((Object)element);
        label.setImage(this.getImage(UiPlugin.getFileSystemImageDescriptor(file.getName())));
        String versionStr = null;
        switch (file.getDisplayOption()) {
            case SHOW_VERSION_NUMBER: {
                versionStr = file.getVersionNumber();
                break;
            }
            case SHOW_VERSION_ID: {
                versionStr = file.getVersionId();
            }
        }
        if (versionStr == null) {
            label.setText(file.getName());
        } else {
            versionStr = CustomTreeViewer.markupDecorations(versionStr, this.customMarkup);
            label.setText(NLS.bind((String)Messages.RepositoryFilesView_VersionIdLabel, (Object)file.getName(), (Object)versionStr));
        }
    }
}

