/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.ui.item.ItemListenerUtil;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewer;
import com.ibm.team.internal.filesystem.ui.labelproviders.ChangeSetDateFunction;
import com.ibm.team.internal.filesystem.ui.labelproviders.ChangeSetToChangeDescriptionFunction;
import com.ibm.team.internal.filesystem.ui.labelproviders.ChangeSetToWorkItemSummaryLabelProvider;
import com.ibm.team.internal.filesystem.ui.labelproviders.ComponentShortLabelProvider;
import com.ibm.team.internal.filesystem.ui.labelproviders.DateLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.ChangeSetAuthorFunction;
import com.ibm.team.internal.filesystem.ui.views.search.changeset.ChangeSetComponentFunction;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import com.ibm.team.repository.rcp.ui.labelproviders.ListeningLabelProvider;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.links.ChangeSetLocationFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class DecoratedChangeSetLabelProvider
extends ListeningLabelProvider {
    private boolean customMarkup = false;
    private Set<ChangeSetWrapper> enqueuedEvents = new HashSet<ChangeSetWrapper>();
    private boolean allItemsEnqueued = false;
    private int enqueueCounter = 0;
    private ILabelProviderListener labelListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] elements = event.getElements();
            if (elements == null) {
                DecoratedChangeSetLabelProvider.this.allItemsEnqueued = true;
                DecoratedChangeSetLabelProvider.this.enqueuedEvents.clear();
            } else if (!DecoratedChangeSetLabelProvider.this.allItemsEnqueued) {
                int i = 0;
                while (i < elements.length) {
                    ChangeSetWrapper next = (ChangeSetWrapper)((Object)elements[i]);
                    DecoratedChangeSetLabelProvider.this.enqueuedEvents.add(next);
                    ++i;
                }
            }
            DecoratedChangeSetLabelProvider.this.enqueueChange();
        }
    };
    private ConvertingLabelProvider workItemLabel;
    private ConvertingLabelProvider usernameLabel;
    private ConvertingLabelProvider dateLabel;
    private ConvertingLabelProvider componentLabel;
    private String formatWorkItemComment;
    private String formatWorkItem;
    private String formatComment;
    private String formatNone;
    private boolean includeComment = false;
    private ISharedItemChangeListener changeSetListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            final HashSet changed = NewCollection.hashSet();
            for (ISharedItemChangeEvent event : events) {
                IItem item = event.getSharedItem();
                if (!(item instanceof IChangeSet)) continue;
                IChangeSet changeSet = (IChangeSet)item;
                ChangeSetWrapper csw = new ChangeSetWrapper(event.getItemManager().teamRepository(), changeSet);
                changed.add(csw);
            }
            SWTUtil.greedyExec((Display)DecoratedChangeSetLabelProvider.this.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!DecoratedChangeSetLabelProvider.this.allItemsEnqueued) {
                        for (ChangeSetWrapper next : changed) {
                            DecoratedChangeSetLabelProvider.this.enqueuedEvents.add(next);
                        }
                    }
                    DecoratedChangeSetLabelProvider.this.enqueueChange();
                }
            });
        }
    };

    protected void enqueueChange() {
        ++this.enqueueCounter;
        SWTUtil.greedyExec((Display)this.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                DecoratedChangeSetLabelProvider decoratedChangeSetLabelProvider = DecoratedChangeSetLabelProvider.this;
                decoratedChangeSetLabelProvider.enqueueCounter = decoratedChangeSetLabelProvider.enqueueCounter - 1;
                if (DecoratedChangeSetLabelProvider.this.enqueueCounter > 0) {
                    return;
                }
                boolean allItems = DecoratedChangeSetLabelProvider.this.allItemsEnqueued;
                ArrayList changedItems = new ArrayList();
                changedItems.addAll(DecoratedChangeSetLabelProvider.this.enqueuedEvents);
                DecoratedChangeSetLabelProvider.this.enqueuedEvents.clear();
                DecoratedChangeSetLabelProvider.this.allItemsEnqueued = false;
                if (allItems) {
                    DecoratedChangeSetLabelProvider.this.fireAllElementsChangedEvent();
                } else {
                    DecoratedChangeSetLabelProvider.this.fireChangeEvent(changedItems);
                }
            }
        });
    }

    public DecoratedChangeSetLabelProvider(String formatWorkItemComment, String formatWorkItem, String formatComment, String formatNone, boolean customMarkup, ISetWithListeners<ChangeSetWrapper> changeSets, IOperationRunner operationRunner) {
        super(changeSets);
        this.formatWorkItemComment = formatWorkItemComment;
        this.formatWorkItem = formatWorkItem;
        this.formatComment = formatComment;
        this.formatNone = formatNone;
        this.customMarkup = customMarkup;
        this.workItemLabel = new ConvertingLabelProvider((IViewerLabelProvider)new ChangeSetToWorkItemSummaryLabelProvider(), (IDynamicFunction)new ChangeSetToChangeDescriptionFunction(changeSets, operationRunner, true));
        this.workItemLabel.addListener(this.labelListener);
        if (formatWorkItemComment.contains("{1}")) {
            ChangeSetComponentFunction changeSetComponents = new ChangeSetComponentFunction(changeSets, operationRunner, Display.getCurrent(), true);
            this.componentLabel = new ConvertingLabelProvider((IViewerLabelProvider)new ComponentShortLabelProvider(changeSetComponents.getRange(), operationRunner), (IDynamicFunction)changeSetComponents);
            this.componentLabel.addListener(this.labelListener);
        }
        if (formatWorkItemComment.contains("{2}")) {
            ChangeSetAuthorFunction changeSetAuthor = new ChangeSetAuthorFunction((ISetWithListeners<? extends ChangeSetWrapper>)changeSets, operationRunner);
            this.usernameLabel = new ConvertingLabelProvider(LabelProviders.create((ISetWithListeners)changeSetAuthor.getRange()), (IDynamicFunction)changeSetAuthor);
            this.usernameLabel.addListener(this.labelListener);
        }
        if (formatWorkItemComment.contains("{3}")) {
            ChangeSetDateFunction changeSetDates = new ChangeSetDateFunction(changeSets, true);
            this.dateLabel = new ConvertingLabelProvider((IViewerLabelProvider)new DateLabelProvider(), (IDynamicFunction)changeSetDates);
            this.dateLabel.addListener(this.labelListener);
        }
        if (formatWorkItemComment.contains("{4}")) {
            this.includeComment = true;
        }
    }

    protected void elementAdded(Object element) {
        ChangeSetWrapper csw = (ChangeSetWrapper)((Object)element);
        if (this.includeComment) {
            ItemListenerUtil.addListener((IItem)csw.getChangeSet(), this.changeSetListener);
        }
        super.elementAdded(element);
    }

    protected void elementRemoved(Object element) {
        ChangeSetWrapper csw = (ChangeSetWrapper)((Object)element);
        if (this.includeComment) {
            ItemListenerUtil.removeListener((IItem)csw.getChangeSet(), this.changeSetListener);
        }
        super.elementRemoved(element);
    }

    public void doUpdateLabel(ViewerLabel label, Object element) {
        ChangeSetWrapper csw = (ChangeSetWrapper)((Object)element);
        this.workItemLabel.updateLabel(label, element);
        String commentString = csw.getChangeSet().getComment();
        String workItemString = label.hasNewText() ? label.getText() : "";
        String componentString = DecoratedChangeSetLabelProvider.getText((IViewerLabelProvider)this.componentLabel, (Object)csw);
        String authorString = CustomTreeViewer.markupName(DecoratedChangeSetLabelProvider.getText((IViewerLabelProvider)this.usernameLabel, (Object)csw), this.customMarkup);
        String dateString = DecoratedChangeSetLabelProvider.getText((IViewerLabelProvider)this.dateLabel, (Object)csw);
        String formatter = null;
        if (commentString.length() == 0) {
            commentString = ChangeSetLocationFactory.getFullContextLabel((IChangeSet)csw.getChangeSet(), (String)" ");
            formatter = workItemString.length() == 0 ? this.formatNone : this.formatWorkItem;
        } else {
            commentString = ChangeSetLocationFactory.replaceLineEnding((String)commentString.trim(), (String)" ");
            formatter = workItemString.length() == 0 ? this.formatComment : this.formatWorkItemComment;
        }
        label.setText(NLS.bind((String)formatter, (Object[])new String[]{workItemString, componentString, authorString, dateString, commentString}));
    }

    private static String getText(IViewerLabelProvider labelProvider, Object element) {
        if (labelProvider == null) {
            return "";
        }
        ViewerLabel vl = new ViewerLabel("", null);
        labelProvider.updateLabel(vl, element);
        return vl.getText();
    }

    public void dispose() {
        if (this.workItemLabel != null) {
            this.workItemLabel.removeListener(this.labelListener);
            this.workItemLabel.dispose();
        }
        if (this.usernameLabel != null) {
            this.usernameLabel.removeListener(this.labelListener);
            this.usernameLabel.dispose();
        }
        if (this.componentLabel != null) {
            this.componentLabel.removeListener(this.labelListener);
            this.componentLabel.dispose();
        }
        if (this.dateLabel != null) {
            this.dateLabel.removeListener(this.labelListener);
            this.dateLabel.dispose();
        }
        super.dispose();
    }
}

