/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.BinaryHeap;
import com.ibm.team.jface.labelProviders.IElementRemovedListener;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;

public class DateLabelProvider
extends BaseLabelProvider
implements IElementRemovedListener {
    private static final boolean USE_RELATIVE_DATES_DEFAULT = true;
    protected boolean relativeDates = true;
    protected DateFormat format = DateFormat.getDateTimeInstance(2, 3);
    protected DateFormat timeFormat = DateFormat.getTimeInstance();
    protected Display theDisplay = Display.getCurrent();
    protected boolean isDisposed = false;
    protected boolean scheduled = false;
    private static ArrayList intervals;
    private static TimeInterval endTime;
    private static TimeInterval startTime;
    protected long nextUpdate;
    private BinaryHeap datesToUpdate;
    private HashMap mapDateToPendingUpdate = new HashMap();
    protected Runnable updateRunnable = new Runnable(){

        @Override
        public void run() {
            if (!DateLabelProvider.this.isDisposed) {
                ArrayList<Date> changed = new ArrayList<Date>();
                long now = System.currentTimeMillis();
                PendingUpdate next = (PendingUpdate)DateLabelProvider.this.datesToUpdate.peek();
                while (next != null && next.whenToUpdate < now) {
                    changed.add(next.dateToUpdate);
                    DateLabelProvider.this.datesToUpdate.removeFirst();
                    DateLabelProvider.this.mapDateToPendingUpdate.remove(next.dateToUpdate);
                    next = (PendingUpdate)DateLabelProvider.this.datesToUpdate.peek();
                }
                DateLabelProvider.this.nextUpdate = 0L;
                DateLabelProvider.this.fireChangeEvent(changed);
                if (next != null) {
                    DateLabelProvider.this.scheduleUpdate(next.whenToUpdate, now);
                }
            }
        }
    };
    protected Job updateJob = new Job(Messages.DateLabelProvider_jobName){

        protected IStatus run(IProgressMonitor monitor) {
            if (!DateLabelProvider.this.theDisplay.isDisposed()) {
                DateLabelProvider.this.theDisplay.asyncExec(DateLabelProvider.this.updateRunnable);
            }
            return Status.OK_STATUS;
        }
    };

    public DateLabelProvider() {
        this.updateJob.setSystem(true);
        this.datesToUpdate = new BinaryHeap(new Comparator(){

            public int compare(Object o1, Object o2) {
                PendingUpdate pu1 = (PendingUpdate)o1;
                PendingUpdate pu2 = (PendingUpdate)o2;
                return (int)(pu1.whenToUpdate - pu2.whenToUpdate);
            }
        });
    }

    private static ArrayList getIntervals() {
        if (intervals == null) {
            long endTime;
            int interval;
            ArrayList<TimeInterval> newIntervals = new ArrayList<TimeInterval>();
            long second = 1000L;
            long minute = second * 60L;
            long hour = minute * 60L;
            int[] minuteIntervals = new int[]{1, 2, 3, 5, 10, 15, 20, 30, 45};
            int[] hourIntervals = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24};
            newIntervals.add(new TimeInterval(0L, Messages.DateLabelProvider_1));
            newIntervals.add(new TimeInterval(minute, Messages.DateLabelProvider_2));
            newIntervals.add(new TimeInterval(-minute, Messages.DateLabelProvider_3));
            int i = 1;
            while (i < minuteIntervals.length) {
                interval = minuteIntervals[i];
                endTime = (long)interval * minute;
                newIntervals.add(new TimeInterval(endTime, NLS.bind((String)Messages.DateLabelProvider_4, (Object)interval)));
                newIntervals.add(new TimeInterval(-endTime, NLS.bind((String)Messages.DateLabelProvider_5, (Object)interval)));
                ++i;
            }
            newIntervals.add(new TimeInterval(hour, Messages.DateLabelProvider_6));
            newIntervals.add(new TimeInterval(-hour, Messages.DateLabelProvider_7));
            i = 1;
            while (i < hourIntervals.length) {
                interval = hourIntervals[i];
                endTime = (long)interval * hour;
                newIntervals.add(new TimeInterval(endTime, NLS.bind((String)Messages.DateLabelProvider_8, (Object)interval)));
                newIntervals.add(new TimeInterval(-endTime, NLS.bind((String)Messages.DateLabelProvider_9, (Object)interval)));
                ++i;
            }
            DateLabelProvider.endTime = new TimeInterval(24L * hour, Messages.DateLabelProvider_10);
            startTime = new TimeInterval(-24L * hour, Messages.DateLabelProvider_11);
            newIntervals.add(startTime);
            newIntervals.add(DateLabelProvider.endTime);
            Collections.sort(newIntervals);
            TimeInterval previous = null;
            for (TimeInterval next : newIntervals) {
                if (next.endTime > 0L) {
                    previous.endTime = next.endTime;
                }
                previous = next;
            }
            previous.endTime = Long.MAX_VALUE;
            intervals = newIntervals;
        }
        return intervals;
    }

    public void useRelativeDates(boolean shouldUse) {
        if (this.relativeDates != shouldUse) {
            this.relativeDates = shouldUse;
            this.fireAllElementsChangedEvent();
        }
    }

    public void updateLabel(ViewerLabel label, Object element) {
        Date date = (Date)element;
        if (this.usingRelativeDates()) {
            long now = System.currentTimeMillis();
            long then = date.getTime();
            long dif = now - then;
            Date nowDate = new Date(now);
            boolean sameDay = nowDate.getDate() == date.getDate() && nowDate.getYear() == date.getYear() && nowDate.getMonth() == date.getMonth();
            TimeInterval interval = this.getTimeInterval(dif);
            if (!sameDay || interval == startTime || interval == endTime) {
                label.setText(this.format.format(date));
            } else {
                long second = 1000L;
                long minute = second * 60L;
                long hour = minute * 60L;
                String absoluteTime = this.format.format(date);
                if (dif < hour * 24L) {
                    absoluteTime = this.timeFormat.format(date);
                }
                String formatted = NLS.bind((String)"{0} ({1})", (Object)absoluteTime, (Object)interval.getIntervalName());
                label.setText(formatted);
                PendingUpdate pu = (PendingUpdate)this.mapDateToPendingUpdate.get(date);
                if (pu == null) {
                    long endTime = interval.getEndTime();
                    long changeTime = endTime - dif + now;
                    pu = new PendingUpdate(changeTime, date);
                    this.datesToUpdate.add(pu);
                    this.mapDateToPendingUpdate.put(date, pu);
                    this.scheduleUpdate(changeTime, now);
                }
            }
        } else {
            label.setText(this.format.format(date));
        }
    }

    private void scheduleUpdate(long changeTime, long now) {
        if (this.nextUpdate == 0L || changeTime < this.nextUpdate) {
            this.nextUpdate = changeTime;
            long delay = changeTime - now;
            if (delay < 0L) {
                delay = 0L;
            }
            this.updateJob.cancel();
            this.updateJob.schedule(delay);
        }
    }

    private boolean usingRelativeDates() {
        return this.relativeDates;
    }

    private TimeInterval getTimeInterval(long timestamp) {
        ArrayList intervals = DateLabelProvider.getIntervals();
        for (TimeInterval interval : intervals) {
            if (interval.getEndTime() <= timestamp) continue;
            return interval;
        }
        return endTime;
    }

    public void dispose() {
        this.isDisposed = true;
        this.updateJob.cancel();
        super.dispose();
    }

    public void handleElementRemoved(Object element) {
        PendingUpdate update = (PendingUpdate)this.mapDateToPendingUpdate.remove(element);
        if (update != null) {
            this.datesToUpdate.remove(update);
        }
    }

    private static final class PendingUpdate
    implements Comparable {
        private long whenToUpdate;
        private Date dateToUpdate;

        public PendingUpdate(long whenToUpdate, Date dateToUpdate) {
            this.whenToUpdate = whenToUpdate;
            this.dateToUpdate = dateToUpdate;
        }

        public int compareTo(Object o) {
            if (o instanceof PendingUpdate) {
                PendingUpdate update = (PendingUpdate)o;
                this.whenToUpdate = update.whenToUpdate;
                return (int)this.whenToUpdate;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PendingUpdate) {
                PendingUpdate pu = (PendingUpdate)obj;
                return pu.dateToUpdate.equals(this.dateToUpdate);
            }
            return super.equals(obj);
        }
    }

    private static final class TimeInterval
    implements Comparable {
        long endTime;
        String name;

        public TimeInterval(long endTime, String name) {
            this.endTime = endTime;
            this.name = name;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public String getIntervalName() {
            return this.name;
        }

        public int compareTo(Object o) {
            if (o instanceof TimeInterval) {
                TimeInterval ti = (TimeInterval)o;
                return (int)(this.endTime - ti.endTime);
            }
            return 0;
        }
    }
}

