/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.IActiveWorkspaceManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.IComponentSyncManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ILocalSynchronizationManager;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.SharedItemLabelProvider;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ContributorPlaceLabelProvider
extends SharedItemLabelProvider {
    private Image workspaceImage;
    private IListener loadListener = new IListener(){

        public void handleEvents(List events) {
            ArrayList affected = new ArrayList();
            for (IPropertyChangeEvent event : events) {
                IWorkspaceConnection wc = (IWorkspaceConnection)(event.getEventType() == "com.ibm.team.repository.PropertyAdd" ? event.getNewValue() : event.getOldValue());
                affected.addAll(ContributorPlaceLabelProvider.this.getElements((IItemHandle)wc.getResolvedWorkspace()));
            }
            ContributorPlaceLabelProvider.this.fireChangeEvent(affected);
        }
    };
    private IListener sharedComponentsListener = new IListener(){

        public void handleEvents(List events) {
            SWTUtil.greedyExec((Display)ContributorPlaceLabelProvider.this.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ContributorPlaceLabelProvider.this.fireChangeEvent(ContributorPlaceLabelProvider.this.getKnownElements().toCollection());
                }
            });
        }
    };

    public ContributorPlaceLabelProvider() {
        this.workspaceImage = this.getImage(ImagePool.WORKSPACE);
        IComponentSyncManager syncMgr = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncManager();
        syncMgr.addGenericListener((Object)"loadingWorkspaces", this.loadListener);
        syncMgr.addGenericListener((Object)"loadedWorkspaces", this.loadListener);
        ILocalSynchronizationManager mgr = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager();
        mgr.addGenericListener((Object)"loadedComponents", this.sharedComponentsListener);
    }

    public void dispose() {
        IComponentSyncManager syncMgr = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncManager();
        syncMgr.removeGenericListener((Object)"loadingWorkspaces", this.loadListener);
        syncMgr.removeGenericListener((Object)"loadedWorkspaces", this.loadListener);
        ILocalSynchronizationManager mgr = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager();
        mgr.removeGenericListener((Object)"loadedComponents", this.sharedComponentsListener);
        super.dispose();
    }

    protected void doUpdateLabel(ViewerLabel label, Object element) {
        ContributorPlaceWrapper obj = (ContributorPlaceWrapper)((Object)element);
        String labelText = ContributorPlaceLabelProvider.getElementText(obj);
        label.setText(labelText);
        label.setImage(this.workspaceImage);
    }

    public static String getElementText(ContributorPlaceWrapper wrapper) {
        IComponentSyncManager syncMgr = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncManager();
        IActiveWorkspaceManager manager = FileSystemResourcesPlugin.getActiveWorkspaceManager();
        IWorkspace workspace = wrapper.getWorkspace();
        String name = workspace.getName();
        if (syncMgr.isLoading((IWorkspaceHandle)workspace)) {
            name = NLS.bind((String)Messages.ContributorPlaceLabelProvider_0, (Object)name);
        } else if (manager.isActive((IWorkspaceHandle)workspace)) {
            try {
                boolean allShared = false;
                boolean someShared = false;
                ILocalSynchronizationManager localSyncMgr = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager();
                Collection<IComponentHandle> components = ContributorPlaceLabelProvider.getComponents(workspace);
                if (components != null && !components.isEmpty()) {
                    allShared = true;
                    for (IComponentHandle handle : components) {
                        if (!localSyncMgr.isShared((IWorkspaceHandle)workspace, handle)) {
                            allShared = false;
                            if (!someShared) continue;
                            break;
                        }
                        someShared = true;
                        if (!allShared) break;
                    }
                }
                if (allShared) {
                    name = NLS.bind((String)Messages.ContributorPlaceLabelProvider_1, (Object)name);
                } else if (someShared) {
                    name = NLS.bind((String)Messages.ContributorPlaceLabelProvider_2, (Object)name);
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
        }
        return name;
    }

    private static Collection<IComponentHandle> getComponents(IWorkspace workspace) throws TeamRepositoryException {
        IComponentSyncManager syncMgr = FileSystemResourcesPlugin.getComponentSyncModel().getComponentSyncManager();
        IWorkspaceConnection wc = syncMgr.getLoadedWorkspace((IWorkspaceHandle)workspace);
        if (wc != null) {
            return wc.getComponents();
        }
        return null;
    }

    public static ImageDescriptor getElementImage(ContributorPlaceWrapper obj) {
        return ImagePool.WORKSPACE;
    }

    @Override
    protected IItem getSharedItemFor(Object element) {
        ContributorPlaceWrapper obj = (ContributorPlaceWrapper)((Object)element);
        return obj.getWorkspace();
    }
}

