/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.ui.changes.views.DecorationImageDescriptor;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.filesystem.ui.wrapper.ContributorPlaceChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.MaskableChangeSetLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.labelproviders.ListeningLabelProvider;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.widgets.Display;

public class ContributorPlaceChangeSetLabelProvider
extends ListeningLabelProvider {
    private Set<ITeamRepository> hookedRepositories = new HashSet<ITeamRepository>();
    private IViewerLabelProvider nestedLabelProvider;
    private IOperationRunner operationRunner;
    private ILabelProviderListener labelProviderListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            ContributorPlaceChangeSetLabelProvider.this.fireChangeEvent(event.getElements());
        }
    };
    private IListener itemSuspendListener = new IListener(){

        public void handleEvents(List events) {
            for (Object object : events) {
                PropertyChangeEvent event;
                if (!(object instanceof PropertyChangeEvent) || !(event = (PropertyChangeEvent)object).getProperty().equals("suspended")) continue;
                final HashMap<UUID, IChangeSet> added = new HashMap<UUID, IChangeSet>();
                Collection newValues = (Collection)event.getNewValue();
                for (Object obj : newValues) {
                    if (!(obj instanceof IChangeSet)) continue;
                    IChangeSet changeSet = (IChangeSet)obj;
                    added.put(changeSet.getItemId(), changeSet);
                }
                final HashMap<UUID, IChangeSet> removed = new HashMap<UUID, IChangeSet>();
                Collection oldValues = (Collection)event.getOldValue();
                for (Object obj : oldValues) {
                    if (!(obj instanceof IChangeSet)) continue;
                    IChangeSet changeSet = (IChangeSet)obj;
                    removed.put(changeSet.getItemId(), changeSet);
                }
                Iterator iterator = removed.keySet().iterator();
                while (iterator.hasNext()) {
                    UUID uuid = (UUID)iterator.next();
                    IChangeSet removedChangeSet = (IChangeSet)added.remove(uuid);
                    if (removedChangeSet == null) continue;
                    iterator.remove();
                }
                if (added.isEmpty() && removed.isEmpty()) continue;
                SWTUtil.greedyExec((Display)ContributorPlaceChangeSetLabelProvider.this.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<ContributorPlaceChangeSetWrapper> changed = new ArrayList<ContributorPlaceChangeSetWrapper>();
                        for (Object elment : ContributorPlaceChangeSetLabelProvider.this.getKnownElements()) {
                            ContributorPlaceChangeSetWrapper wrapper = (ContributorPlaceChangeSetWrapper)((Object)elment);
                            if (added.containsKey(wrapper.getChangeSet().getItemId())) {
                                wrapper.setSuspended(true);
                                changed.add(wrapper);
                                continue;
                            }
                            if (!removed.containsKey(wrapper.getChangeSet().getItemId())) continue;
                            wrapper.setSuspended(false);
                            changed.add(wrapper);
                        }
                        ContributorPlaceChangeSetLabelProvider.this.fireChangeEvent(changed);
                    }
                });
            }
        }
    };

    public ContributorPlaceChangeSetLabelProvider() {
        this.operationRunner = new JobRunner(false);
        this.init();
    }

    public ContributorPlaceChangeSetLabelProvider(ISetWithListeners knownElements, IOperationRunner operationRunner) {
        super(knownElements);
        this.operationRunner = operationRunner;
        this.init();
    }

    private void init() {
        ConvertingSet conversion = new ConvertingSet(this.getKnownElements(), (IConversion)new IConversion<ContributorPlaceChangeSetWrapper, ChangeSetWrapper>(){

            public ChangeSetWrapper createAdapter(ContributorPlaceChangeSetWrapper source) {
                return source;
            }
        }, true);
        MaskableChangeSetLabelProvider decoratedLabelProvider = new MaskableChangeSetLabelProvider(Messages.ContributorPlaceChangeSetLabelProvider_verboseFormat, false, (ISetWithListeners<ChangeSetWrapper>)conversion.getRange(), this.operationRunner);
        this.nestedLabelProvider = new ConvertingLabelProvider((IViewerLabelProvider)decoratedLabelProvider, (IDynamicFunction)conversion);
        this.nestedLabelProvider.addListener(this.labelProviderListener);
    }

    public void doUpdateLabel(ViewerLabel label, Object element) {
        ContributorPlaceChangeSetWrapper wrapper;
        this.nestedLabelProvider.updateLabel(label, element);
        if (element instanceof ContributorPlaceChangeSetWrapper && (wrapper = (ContributorPlaceChangeSetWrapper)((Object)element)).isSuspended()) {
            Object imageDescriptor = ImagePool.CHANGE_COMPLETED;
            imageDescriptor = new DecorationImageDescriptor((ImageDescriptor)imageDescriptor, 36, 0);
            label.setImage(this.getImage((ImageDescriptor)imageDescriptor));
        }
    }

    public void dispose() {
        this.nestedLabelProvider.removeListener(this.labelProviderListener);
        this.nestedLabelProvider.dispose();
        for (ITeamRepository repo : this.hookedRepositories) {
            IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            if (workspaceManager == null) continue;
            workspaceManager.removeGenericListener((Object)"suspended", this.itemSuspendListener);
        }
        this.hookedRepositories.clear();
    }

    protected void elementAdded(Object element) {
        super.elementAdded(element);
        ContributorPlaceChangeSetWrapper wrapper = (ContributorPlaceChangeSetWrapper)((Object)element);
        if (!this.hookedRepositories.contains(wrapper.getRepository())) {
            this.hookedRepositories.add(wrapper.getRepository());
            IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)wrapper.getRepository());
            if (workspaceManager != null) {
                workspaceManager.addGenericListener((Object)"suspended", this.itemSuspendListener);
            }
        }
    }
}

