/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.rcp.core.internal.FileSystemResourcesPlugin;
import com.ibm.team.filesystem.rcp.core.internal.changes.ILocalSynchronizationManager;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.SharedItemLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentDetails;
import com.ibm.team.internal.filesystem.ui.views.search.component.ComponentDetailsFunction;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.labelproviders.LabelProviders;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.scm.client.IReadScopeDescriber;
import com.ibm.team.scm.common.dto.IPublicScope;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.internal.dto.AccessGroupScope;
import com.ibm.team.scm.common.internal.dto.TeamAreaPrivateScope;
import java.util.List;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ComponentWrapperLabelProvider
extends SharedItemLabelProvider {
    private ConvertingLabelProvider ownerLabelProvider;
    private IListener sharedComponentsListener = new IListener(){

        public void handleEvents(List events) {
            SWTUtil.greedyExec((Display)ComponentWrapperLabelProvider.this.getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ComponentWrapperLabelProvider.this.fireChangeEvent(ComponentWrapperLabelProvider.this.getKnownElements().toCollection());
                }
            });
        }
    };
    private ILabelProviderListener ownerListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            ComponentWrapperLabelProvider.this.fireChangeEvent(event.getElements());
        }
    };
    private ComponentDetailsFunction componentsToOwnersFunction;
    private boolean showOwnerHint;

    public ComponentWrapperLabelProvider() {
        this(null, (IOperationRunner)new JobRunner(false));
    }

    public ComponentWrapperLabelProvider(ISetWithListeners knownElements, IOperationRunner runner) {
        super(knownElements, runner);
        this.componentsToOwnersFunction = new ComponentDetailsFunction(this.getKnownElements(), runner);
        this.ownerLabelProvider = new ConvertingLabelProvider(LabelProviders.create((ISetWithListeners)this.componentsToOwnersFunction.getRange()), (IDynamicFunction)this.componentsToOwnersFunction);
        ILocalSynchronizationManager mgr = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager();
        mgr.addGenericListener((Object)"loadedComponents", this.sharedComponentsListener);
        this.ownerLabelProvider.addListener(this.ownerListener);
    }

    public void setShowOwnerHint(boolean showOwnerHint) {
        this.showOwnerHint = showOwnerHint;
    }

    public void dispose() {
        ILocalSynchronizationManager mgr = FileSystemResourcesPlugin.getComponentSyncModel().getLocalSynchronizationManager();
        mgr.removeGenericListener((Object)"loadedComponents", this.sharedComponentsListener);
        this.ownerLabelProvider.removeListener(this.ownerListener);
        this.ownerLabelProvider.dispose();
        super.dispose();
    }

    protected void doUpdateLabel(ViewerLabel label, Object element) {
        String ownerText = null;
        String vizText = null;
        ImageDescriptor image = null;
        String componentLabel = null;
        if (element instanceof ComponentWrapper) {
            ComponentWrapper wrapper = (ComponentWrapper)((Object)element);
            componentLabel = ComponentWrapperLabelProvider.computeShortLabel(wrapper);
            ownerText = this.getOwnerText(wrapper);
            image = this.computeDynImage(wrapper);
            vizText = this.getVisibility(wrapper);
        }
        if (componentLabel != null) {
            String text = componentLabel;
            if (ownerText != null || vizText != null) {
                text = NLS.bind((String)Messages.ComponentWrapperLabelProvider_0, (Object)text, (Object)(ownerText == null ? vizText : ownerText));
            }
            label.setText(text);
            if (image != null) {
                label.setImage((Image)this.getResources().get((DeviceResourceDescriptor)image));
            }
        }
    }

    public static String computeShortLabel(ComponentWrapper element) {
        return element.getComponent().getName();
    }

    public static ImageDescriptor computeImage(ComponentWrapper element) {
        return ImagePool.COMPONENT;
    }

    public ImageDescriptor computeDynImage(ComponentWrapper element) {
        IItem owner = this.getOwner(element);
        if (owner instanceof IContributorHandle) {
            IContributor loggedInContributor = element.getRepository().loggedInContributor();
            if (owner.sameItemId((IItemHandle)loggedInContributor)) {
                return ImagePool.SELF_COMPONENT;
            }
            return ImagePool.PRIVATE_COMPONENT;
        }
        if (owner instanceof ITeamAreaHandle) {
            return ImagePool.TEAM_COMPONENT;
        }
        if (owner instanceof IProjectAreaHandle) {
            return ImagePool.PROJECT_COMPONENT;
        }
        return ImagePool.COMPONENT;
    }

    private String getVisibility(ComponentWrapper wrapper) {
        ComponentDetails details = (ComponentDetails)this.componentsToOwnersFunction.computeResult((Object)wrapper);
        if (details != null) {
            boolean personalPublic;
            if (wrapper.shouldAllowSuspendedChangeSetChildren()) {
                return details.getOwnerText();
            }
            IReadScope viz = details.getVisibility();
            boolean bl = personalPublic = this.isPersonal(wrapper) && viz instanceof IPublicScope;
            if (!personalPublic || this.isTeamPrivate(wrapper) || this.isAccessGroupScoped(wrapper)) {
                return IReadScopeDescriber.FACTORY.shortDescription(viz);
            }
        }
        return null;
    }

    private boolean isPersonal(ComponentWrapper wrapper) {
        ComponentDetails details = (ComponentDetails)this.componentsToOwnersFunction.computeResult((Object)wrapper);
        if (details != null) {
            AbstractWrapper owner = details.getOwner();
            return owner != null && owner.getItem() instanceof IContributorHandle;
        }
        return false;
    }

    private boolean isTeamPrivate(ComponentWrapper wrapper) {
        ComponentDetails details = (ComponentDetails)this.componentsToOwnersFunction.computeResult((Object)wrapper);
        if (details != null) {
            AbstractWrapper owner = details.getOwner();
            IReadScope viz = details.getVisibility();
            boolean restrictToTeam = viz instanceof TeamAreaPrivateScope;
            return owner != null && owner.getItem() instanceof ITeamArea && restrictToTeam;
        }
        return false;
    }

    private boolean isAccessGroupScoped(ComponentWrapper wrapper) {
        ComponentDetails details = (ComponentDetails)this.componentsToOwnersFunction.computeResult((Object)wrapper);
        if (details != null) {
            return details.getVisibility() instanceof AccessGroupScope;
        }
        return false;
    }

    private IItem getOwner(ComponentWrapper wrapper) {
        AbstractWrapper owner;
        ComponentDetails details = (ComponentDetails)this.componentsToOwnersFunction.computeResult((Object)wrapper);
        if (details != null && (owner = details.getOwner()) != null) {
            return owner.getItem();
        }
        return null;
    }

    private String getOwnerText(ComponentWrapper wrapper) {
        ComponentDetails details = (ComponentDetails)this.componentsToOwnersFunction.computeResult((Object)wrapper);
        if (details != null) {
            IItem owner;
            IItem iItem = owner = details.getOwner() == null ? null : details.getOwner().getItem();
            if (owner instanceof IProcessArea && this.showOwnerHint) {
                return ((IProcessArea)owner).getName();
            }
        }
        return null;
    }

    @Override
    public IItem getSharedItemFor(Object element) {
        return ((AbstractWrapper)((Object)element)).getItem();
    }
}

