/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.labelproviders.ComponentWrapperLabelProvider;
import com.ibm.team.internal.filesystem.ui.labelproviders.SharedItemLabelProvider;
import com.ibm.team.internal.filesystem.ui.labelproviders.WorkspaceComponentLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.repositoryfiles.RepositoryFilesComponentNode;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IComponent;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;

public class ComponentShortLabelProvider
extends SharedItemLabelProvider {
    public ComponentShortLabelProvider() {
    }

    public ComponentShortLabelProvider(ISetWithListeners knownElements, IOperationRunner operationRunner) {
        super(knownElements, operationRunner);
    }

    @Override
    protected IItem getSharedItemFor(Object element) {
        AbstractWrapper componentWrapper;
        if (element instanceof RepositoryFilesComponentNode) {
            RepositoryFilesComponentNode node = (RepositoryFilesComponentNode)element;
            element = node.getWrapper();
        }
        if (element instanceof ComponentWrapper) {
            componentWrapper = (ComponentWrapper)((Object)element);
            return ((ComponentWrapper)componentWrapper).getComponent();
        }
        if (element instanceof WorkspaceComponentWrapper) {
            componentWrapper = (WorkspaceComponentWrapper)element;
            return ((WorkspaceComponentWrapper)componentWrapper).getComponent();
        }
        if (element instanceof IComponent) {
            return (IComponent)element;
        }
        if (element instanceof BaselineWrapper) {
            BaselineWrapper wrapper = (BaselineWrapper)element;
            return wrapper.getBaseline();
        }
        return null;
    }

    protected void doUpdateLabel(ViewerLabel label, Object element) {
        AbstractWrapper componentWrapper;
        if (element instanceof RepositoryFilesComponentNode) {
            RepositoryFilesComponentNode node = (RepositoryFilesComponentNode)element;
            element = node.getWrapper();
        }
        if (element instanceof ComponentWrapper) {
            componentWrapper = (ComponentWrapper)((Object)element);
            label.setText(ComponentWrapperLabelProvider.computeShortLabel(componentWrapper));
            label.setImage((Image)this.getResources().get((DeviceResourceDescriptor)ComponentWrapperLabelProvider.computeImage(componentWrapper)));
        } else if (element instanceof WorkspaceComponentWrapper) {
            componentWrapper = (WorkspaceComponentWrapper)element;
            label.setText(WorkspaceComponentLabelProvider.computeShortLabel((WorkspaceComponentWrapper)componentWrapper));
            label.setImage((Image)this.getResources().get((DeviceResourceDescriptor)WorkspaceComponentLabelProvider.computeBasicImage((WorkspaceComponentWrapper)componentWrapper)));
        } else if (element instanceof IComponent) {
            IComponent component = (IComponent)element;
            label.setText(component.getName());
            label.setImage((Image)this.getResources().get((DeviceResourceDescriptor)ImagePool.COMPONENT));
        } else if (element instanceof BaselineWrapper) {
            BaselineWrapper wrapper = (BaselineWrapper)element;
            label.setText(wrapper.getLabel());
            label.setImage((Image)this.getResources().get((DeviceResourceDescriptor)ImagePool.BASELINE));
        }
    }
}

