/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.client.internal.namespace.impl.DescriptionRecord;
import com.ibm.team.filesystem.ui.changes.views.DecorationImageDescriptor;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.internal.utils.BaseLabelProvider;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import java.util.BitSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerLabel;

public class ChangeSetToWorkItemSummaryLabelProvider
extends BaseLabelProvider {
    public void updateLabel(ViewerLabel label, Object element) {
        DescriptionRecord e = (DescriptionRecord)element;
        label.setText(e.getChangeSetLinkSummary().getSummary());
        Object imageDescriptor = e.isComplete() ? ImagePool.CHANGE_COMPLETED : ImagePool.CHANGE;
        BitSet flags = ChangeSetToWorkItemSummaryLabelProvider.getFlagsFor(e);
        imageDescriptor = new DecorationImageDescriptor((ImageDescriptor)imageDescriptor, flags, 0);
        label.setImage(this.getImage((ImageDescriptor)imageDescriptor));
    }

    public static BitSet getFlagsFor(DescriptionRecord record) {
        IChangeSetHandle original;
        IChangeSet changeSet;
        int type = record.getWorkItemType();
        BitSet flags = new BitSet();
        switch (type) {
            case 1: {
                flags.set(16);
                break;
            }
            case 2: {
                flags.set(17);
            }
        }
        if (record.isComplete()) {
            flags.set(3);
        }
        if ((changeSet = record.getChangeSet()) != null && (original = changeSet.getOriginalChangeSet()) != null) {
            if (original.sameItemId((IItemHandle)changeSet)) {
                flags.set(26);
            } else {
                flags.set(28);
            }
        }
        return flags;
    }
}

