/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.namespace.impl.DescriptionRecord;
import com.ibm.team.filesystem.client.internal.namespace.impl.EraCache;
import com.ibm.team.filesystem.ui.item.ItemListenerUtil;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.links.client.ILinkEvent;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SlowFunction;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.services.IDisposable;

public class ChangeSetToChangeDescriptionFunction
extends SlowFunction<ChangeSetWrapper, DescriptionRecord>
implements IListener,
IDisposable {
    private ISharedItemChangeListener changeSetListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            for (ISharedItemChangeEvent event : events) {
                IItem item = event.getSharedItem();
                if (!(item instanceof IChangeSet)) continue;
                IChangeSet changeSet = (IChangeSet)item;
                ChangeSetWrapper wrapper = (ChangeSetWrapper)((Object)ChangeSetToChangeDescriptionFunction.this.wrapperMap.get(ItemId.forItem((IItem)changeSet)));
                if (wrapper == null) continue;
                ChangeSetToChangeDescriptionFunction.this.markDirty((Object)wrapper);
            }
        }
    };
    private Map<ItemId<IChangeSet>, ChangeSetWrapper> wrapperMap = NewCollection.hashMap();
    private boolean linkListenerRegistered;
    private ITeamRepository repo;

    public ChangeSetToChangeDescriptionFunction(ISetWithListeners domain, IOperationRunner runner, boolean isLazy) {
        super(domain, runner, Display.getCurrent(), isLazy);
    }

    protected void elementAdded(ChangeSetWrapper element) {
        this.wrapperMap.put((ItemId<IChangeSet>)ItemId.forItem((IItem)element.getChangeSet()), element);
        ItemListenerUtil.addListener((IItem)element.getChangeSet(), this.changeSetListener);
        if (!this.linkListenerRegistered) {
            this.repo = element.getRepository();
            ILinkManager linkManager = (ILinkManager)this.repo.getClientLibrary(ILinkManager.class);
            linkManager.addGenericListener((Object)"com.ibm.team.links.LinkSaveEvent", (IListener)this);
            linkManager.addGenericListener((Object)"com.ibm.team.links.LinkDeletedEvent", (IListener)this);
            this.linkListenerRegistered = true;
        }
        super.elementAdded((Object)element);
    }

    protected void elementRemoved(ChangeSetWrapper element) {
        this.wrapperMap.remove(ItemId.forItem((IItem)element.getChangeSet()));
        ItemListenerUtil.removeListener((IItem)element.getChangeSet(), this.changeSetListener);
        super.elementRemoved((Object)element);
    }

    protected Map<ChangeSetWrapper, DescriptionRecord> doFetch(Collection<ChangeSetWrapper> toFetch, IProgressMonitor reporter) throws OperationFailedException {
        try {
            HashMap result = NewCollection.hashMap();
            Map<ITeamRepository, List<ChangeSetWrapper>> groupedByRepository = AbstractWrapper.groupByRepository(toFetch);
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)reporter, (int)(groupedByRepository.size() * 2));
            for (ITeamRepository repo : groupedByRepository.keySet()) {
                List<ChangeSetWrapper> changeSets = groupedByRepository.get(repo);
                repo.login((IProgressMonitor)progress.newChild(1));
                Map descriptions = EraCache.fetchDescriptions((ITeamRepository)repo, ChangeSetWrapper.getChangeSets(changeSets), (IRepositoryResolver)IRepositoryResolver.EXISTING_SHARED, (IProgressMonitor)progress.newChild(1));
                for (ChangeSetWrapper next : changeSets) {
                    result.put(next, (DescriptionRecord)descriptions.get(ItemId.forItem((IItem)next.getChangeSet())));
                }
            }
            return result;
        }
        catch (TeamRepositoryException e) {
            throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
        }
    }

    protected DescriptionRecord getDefaultValue() {
        return null;
    }

    protected String getOperationName() {
        return Messages.ChangeSetToChangeDescriptionFunction_0;
    }

    public void handleEvents(List events) {
        for (IEvent event : events) {
            ChangeSetWrapper changeSetWrapper;
            ILink link;
            IReference sourceRef;
            Object sourceRefObject;
            if (!(event instanceof ILinkEvent) || !((sourceRefObject = (sourceRef = (link = ((ILinkEvent)event).getLink()).getSourceRef()).resolve()) instanceof IChangeSetHandle)) continue;
            IChangeSetHandle changeSetHandle = (IChangeSetHandle)sourceRefObject;
            IChangeSet cs = (IChangeSet)this.repo.itemManager().getSharedItemIfKnown((IItemHandle)changeSetHandle);
            if (cs == null || (changeSetWrapper = this.wrapperMap.get(ItemId.forItem((IItem)cs))) == null) continue;
            this.markDirty((Object)changeSetWrapper);
        }
    }

    public void dispose() {
        if (this.linkListenerRegistered) {
            ILinkManager linkManager = (ILinkManager)this.repo.getClientLibrary(ILinkManager.class);
            linkManager.removeGenericListener((Object)"com.ibm.team.links.LinkSaveEvent", (IListener)this);
            linkManager.removeGenericListener((Object)"com.ibm.team.links.LinkDeletedEvent", (IListener)this);
            this.linkListenerRegistered = false;
        }
    }
}

