/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.DecoratedChangeSetLabelProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingSet;
import com.ibm.team.repository.rcp.ui.internal.viewers.IConversion;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.labelproviders.ListeningLabelProvider;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.scm.common.IChangeSet;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;

public final class ChangeSetLabelProvider
extends ListeningLabelProvider {
    private IViewerLabelProvider nestedLabelProvider;
    private IOperationRunner operationRunner;
    private ILabelProviderListener labelProviderListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            ChangeSetLabelProvider.this.fireChangeEvent(event.getElements());
        }
    };

    public ChangeSetLabelProvider() {
        this.operationRunner = new JobRunner(false);
        this.init();
    }

    public ChangeSetLabelProvider(ISetWithListeners knownElements, IOperationRunner operationRunner) {
        super(knownElements);
        this.operationRunner = operationRunner;
        this.init();
    }

    private void init() {
        ConvertingSet conversion = new ConvertingSet(this.getKnownElements(), (IConversion)new IConversion<IChangeSet, ChangeSetWrapper>(){

            public ChangeSetWrapper createAdapter(IChangeSet source) {
                ITeamRepository repo = ClientRepositoryUtil.getRepository((IItemHandle)source);
                return new ChangeSetWrapper(repo, source);
            }
        }, true);
        DecoratedChangeSetLabelProvider decoratedLabelProvider = new DecoratedChangeSetLabelProvider(Messages.DecoratedChangeSetLabelProvider_componentComment, Messages.DecoratedChangeSetLabelProvider_componentNone, Messages.DecoratedChangeSetLabelProvider_componentComment, Messages.DecoratedChangeSetLabelProvider_componentNone, false, (ISetWithListeners<ChangeSetWrapper>)conversion.getRange(), this.operationRunner);
        this.nestedLabelProvider = new ConvertingLabelProvider((IViewerLabelProvider)decoratedLabelProvider, (IDynamicFunction)conversion);
        this.nestedLabelProvider.addListener(this.labelProviderListener);
    }

    public void doUpdateLabel(ViewerLabel label, Object element) {
        this.nestedLabelProvider.updateLabel(label, element);
    }

    public void dispose() {
        this.nestedLabelProvider.removeListener(this.labelProviderListener);
        this.nestedLabelProvider.dispose();
    }
}

