/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.ui.item.ItemListenerUtil;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SetTransformer;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.widgets.Display;

public final class ChangeSetDateFunction
extends SetTransformer<ChangeSetWrapper, Date> {
    private ISharedItemChangeListener listener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            final ArrayList<ChangeSetWrapper> changeSets = new ArrayList<ChangeSetWrapper>();
            for (ISharedItemChangeEvent event : events) {
                ItemId afterOwner;
                ItemId beforeOwner;
                IChangeSet beforeState = (IChangeSet)event.getBeforeState();
                IChangeSet afterState = (IChangeSet)event.getAfterState();
                if (beforeState == null || afterState == null || (beforeOwner = ChangeSetUtil.getAuthor((IChangeSet)beforeState)).equals((Object)(afterOwner = ChangeSetUtil.getAuthor((IChangeSet)afterState)))) continue;
                ChangeSetWrapper csw = new ChangeSetWrapper(event.getItemManager().teamRepository(), (IChangeSet)event.getSharedItem());
                changeSets.add(csw);
            }
            SWTUtil.greedyExec((Display)ChangeSetDateFunction.this.display, (Runnable)new Runnable(){

                @Override
                public void run() {
                    HashMap<ChangeSetWrapper, Date> newValues = new HashMap<ChangeSetWrapper, Date>();
                    for (ChangeSetWrapper next : changeSets) {
                        newValues.put(next, next.getChangeSet().getLastChangeDate());
                    }
                    ChangeSetDateFunction.this.reportResults(newValues);
                }
            });
        }
    };
    private Display display = Display.getCurrent();

    public ChangeSetDateFunction(ISetWithListeners domain, boolean lazy) {
        super(domain, lazy);
    }

    protected Date doComputeResult(ChangeSetWrapper element) {
        return element.getChangeSet().getLastChangeDate();
    }

    protected void elementAdded(ChangeSetWrapper element) {
        ItemListenerUtil.addListener((IItem)element.getChangeSet(), this.listener);
        super.elementAdded((Object)element);
    }

    protected void elementRemoved(ChangeSetWrapper element) {
        ItemListenerUtil.removeListener((IItem)element.getChangeSet(), this.listener);
        super.elementRemoved((Object)element);
    }
}

