/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.CopyFileAreaPathResolver;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.ChangeFolder;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.PathFunction;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.labelproviders.ListeningLabelProvider;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import org.eclipse.jface.viewers.ViewerLabel;

public final class ChangeFolderLabelProvider
extends ListeningLabelProvider {
    private IDynamicFunction<ChangeFolder, VersionablePath> pathFunction;
    private volatile IPathResolver pathResolver = CopyFileAreaPathResolver.create();
    private IChangeListener pathListener = new IChangeListener(){

        public void changed(Object source, Object property) {
            Object[] elements = (Object[])property;
            ChangeFolderLabelProvider.this.fireChangeEvent(elements);
        }
    };

    public ChangeFolderLabelProvider() {
        this(null, (IOperationRunner)new JobRunner(false));
    }

    public ChangeFolderLabelProvider(ISetWithListeners elements, IOperationRunner runner) {
        super(elements);
        this.pathFunction = new PathFunction<ChangeFolder>(this.getKnownElements(), runner){

            @Override
            protected IPathResolver getResolverFor(ChangeFolder next) {
                return ChangeFolderLabelProvider.this.pathResolver;
            }

            @Override
            protected SiloedItemId<IVersionable> getUnresolvedPath(ChangeFolder nextFolder) {
                return SiloedItemId.upcast(nextFolder.getPath());
            }
        };
        this.pathFunction.addListener(this.pathListener);
    }

    public void dispose() {
        this.pathFunction.removeListener(this.pathListener);
        super.dispose();
    }

    public void setPathResolver(IPathResolver resolver) {
        this.pathResolver = resolver;
        this.fireAllElementsChangedEvent();
    }

    public void doUpdateLabel(ViewerLabel label, Object element) {
        ChangeFolder changeFolder = (ChangeFolder)element;
        label.setImage(this.getImage(UiPlugin.getFileSystemImageDescriptor(null)));
        VersionablePath path = (VersionablePath)this.pathFunction.computeResult((Object)changeFolder);
        String text = path == null ? Messages.ChangeFolderLabelProvider_0 : this.getPathString(path);
        label.setText(text);
    }

    private String getPathString(VersionablePath path) {
        return path.toString();
    }
}

