/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import java.util.Comparator;

public class BinaryHeap {
    private Object[] elements = new Object[4];
    private Comparator comparator;
    private int size = 0;

    public BinaryHeap(Comparator comparator) {
        this.comparator = comparator;
    }

    public Object peek() {
        if (this.size == 0) {
            return null;
        }
        return this.elements[0];
    }

    public void add(Object toAdd) {
        if (toAdd == null) {
            throw new NullPointerException();
        }
        if (this.size == this.elements.length) {
            Object[] newElements = new Object[this.elements.length * 2];
            System.arraycopy(this.elements, 0, newElements, 0, this.size);
            this.elements = newElements;
        }
        this.elements[this.size] = toAdd;
        int idx = this.size;
        idx = this.trickleUp(idx);
        ++this.size;
    }

    private int trickleUp(int idx) {
        while (idx > 0) {
            int parent = (idx - 1) / 2;
            int compare = this.comparator.compare(this.elements[parent], this.elements[idx]);
            if (compare <= 0) break;
            this.swap(idx, parent);
            idx = parent;
        }
        return idx;
    }

    private void swap(int idx, int parent) {
        Object tmp = this.elements[parent];
        this.elements[parent] = this.elements[idx];
        this.elements[idx] = tmp;
    }

    public void remove(Object toRemove) {
        int i = 0;
        while (i < this.size) {
            Object next = this.elements[i];
            if (next.equals(toRemove)) {
                this.elements[i] = this.elements[this.size - 1];
                this.elements[this.size - 1] = null;
                --this.size;
                this.trickle(i);
            }
            ++i;
        }
        this.readjustSize();
    }

    private void readjustSize() {
        if (this.size < this.elements.length / 4) {
            Object[] newElements = new Object[this.elements.length / 2];
            System.arraycopy(this.elements, 0, newElements, 0, this.size);
            this.elements = newElements;
        }
    }

    public Object removeFirst() {
        if (this.size == 0) {
            return null;
        }
        Object result = this.elements[0];
        this.elements[0] = this.elements[this.size - 1];
        this.elements[this.size - 1] = null;
        --this.size;
        this.trickle(0);
        this.readjustSize();
        return result;
    }

    private void trickle(int idx) {
        int child1;
        if (idx >= this.size) {
            return;
        }
        if (idx > 0) {
            int parent = (idx - 1) / 2;
            int compare = this.comparator.compare(this.elements[parent], this.elements[idx]);
            if (compare > 0) {
                this.swap(parent, idx);
                this.trickleUp(parent);
            }
            return;
        }
        int cursor = idx;
        while ((child1 = cursor * 2 + 1) < this.size) {
            int compare;
            int child2 = child1 + 1;
            int smallChild = child1;
            if (child2 < this.size) {
                compare = this.comparator.compare(this.elements[child1], this.elements[child2]);
                int n = smallChild = compare < 0 ? child1 : child2;
            }
            if ((compare = this.comparator.compare(this.elements[smallChild], this.elements[cursor])) >= 0) break;
            this.swap(smallChild, cursor);
            cursor = smallChild;
        }
    }
}

