/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.BaselineWrapper;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.BaselineComponentFunction;
import com.ibm.team.internal.filesystem.ui.labelproviders.ComponentShortLabelProvider;
import com.ibm.team.internal.filesystem.ui.labelproviders.SharedItemLabelProvider;
import com.ibm.team.internal.filesystem.ui.labelproviders.WorkspaceComponentLabelProvider;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ConvertingLabelProvider;
import com.ibm.team.repository.rcp.ui.internal.viewers.IDynamicFunction;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.scm.common.IBaseline;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class BaselineLabelProvider
extends SharedItemLabelProvider {
    public static final String BASELINE_ID_NAME_FORMAT_STR = "{0}";
    public static final String BASELINE_DATE_FORMAT_STR = "{1}";
    public static final String BASELINE_COMPONENT_FORMAT_STR = "{2}";
    public static final String BASELINE_ID_FORMAT_STR = "{3}";
    public static final String BASELINE_NAME_FORMAT_STR = "{4}";
    public static final String BASELINE_DESC_FORMAT_STR = "{5}";
    private boolean shouldShowBaselineIcon = true;
    private Image baselineImage;
    private String formatString;
    private IOperationRunner background;
    private ConvertingLabelProvider componentLabel;
    private Set<Object> enqueuedEvents = new HashSet<Object>();
    private boolean allItemsEnqueued = false;
    private int enqueueCounter = 0;
    private ILabelProviderListener labelListener = new ILabelProviderListener(){

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] elements = event.getElements();
            if (elements == null) {
                BaselineLabelProvider.this.allItemsEnqueued = true;
                BaselineLabelProvider.this.enqueuedEvents.clear();
            } else if (!BaselineLabelProvider.this.allItemsEnqueued) {
                int i = 0;
                while (i < elements.length) {
                    Object next = elements[i];
                    BaselineLabelProvider.this.enqueuedEvents.add(next);
                    ++i;
                }
            }
            BaselineLabelProvider.this.enqueueChange();
        }
    };

    protected void enqueueChange() {
        ++this.enqueueCounter;
        SWTUtil.greedyExec((Display)this.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                BaselineLabelProvider baselineLabelProvider = BaselineLabelProvider.this;
                baselineLabelProvider.enqueueCounter = baselineLabelProvider.enqueueCounter - 1;
                if (BaselineLabelProvider.this.enqueueCounter > 0) {
                    return;
                }
                boolean allItems = BaselineLabelProvider.this.allItemsEnqueued;
                ArrayList changedItems = new ArrayList();
                changedItems.addAll(BaselineLabelProvider.this.enqueuedEvents);
                BaselineLabelProvider.this.enqueuedEvents.clear();
                BaselineLabelProvider.this.allItemsEnqueued = false;
                if (allItems) {
                    BaselineLabelProvider.this.fireAllElementsChangedEvent();
                } else {
                    BaselineLabelProvider.this.fireChangeEvent(changedItems);
                }
            }
        });
    }

    public BaselineLabelProvider() {
        this(true);
    }

    public BaselineLabelProvider(boolean showDate) {
        this.background = new JobRunner(false);
        this.init(showDate ? Messages.BaselineLabelProvider_0 : BASELINE_ID_NAME_FORMAT_STR);
    }

    public BaselineLabelProvider(String formatString, ISetWithListeners<BaselineWrapper> baselines, IOperationRunner ops) {
        super(baselines);
        this.background = ops;
        this.init(formatString);
    }

    private void init(String formatString) {
        this.formatString = formatString;
        this.baselineImage = this.getImage(ImagePool.BASELINE);
        if (formatString.contains(BASELINE_COMPONENT_FORMAT_STR)) {
            this.initComponentLabel();
        }
    }

    private void initComponentLabel() {
        if (this.componentLabel == null) {
            ISetWithListeners baselines = this.getKnownElements();
            BaselineComponentFunction baselineComponents = new BaselineComponentFunction((ISetWithListeners<BaselineWrapper>)baselines, this.background, Display.getCurrent(), true);
            this.componentLabel = new ConvertingLabelProvider((IViewerLabelProvider)new ComponentShortLabelProvider(baselineComponents.getRange(), this.background), (IDynamicFunction)baselineComponents);
            this.componentLabel.addListener(this.labelListener);
        }
    }

    public boolean getShouldShowIcon() {
        return this.shouldShowBaselineIcon;
    }

    public void setShouldShowIcon(boolean shouldShowIcon) {
        this.shouldShowBaselineIcon = shouldShowIcon;
    }

    public void doUpdateLabel(ViewerLabel label, Object element) {
        if (element instanceof BaselineWrapper) {
            BaselineWrapper wrapper = (BaselineWrapper)element;
            if (this.getShouldShowIcon()) {
                label.setImage(this.baselineImage);
            }
            String formatStringToUse = this.formatString;
            if (wrapper.getParentSnapshot() != null || wrapper.getHierarchyData() != null) {
                this.initComponentLabel();
                formatStringToUse = NLS.bind((String)Messages.BaselineLabelProvider_0, (Object)BASELINE_COMPONENT_FORMAT_STR, (Object)BASELINE_ID_NAME_FORMAT_STR);
            } else {
                formatStringToUse = this.formatString;
            }
            if (formatStringToUse.contains(BASELINE_ID_FORMAT_STR)) {
                this.setBaselineIdAsLabel(wrapper.getBaseline(), label);
            } else if (formatStringToUse.contains(BASELINE_NAME_FORMAT_STR)) {
                this.setBaselineNameAsLabel(wrapper.getBaseline(), label);
            } else if (formatStringToUse.contains(BASELINE_DESC_FORMAT_STR)) {
                this.setBaselineDescriptionAsLabel(wrapper.getBaseline(), label);
            } else {
                String componentString = this.getText((IViewerLabelProvider)this.componentLabel, element);
                String dateString = Messages.BaselineLabelProvider_2;
                Date date = wrapper.getDate();
                if (date != null) {
                    dateString = BaselineLabelProvider.getDate(date);
                }
                String shortName = BaselineWrapper.getLabel(wrapper.getBaseline());
                label.setText(NLS.bind((String)formatStringToUse, (Object[])new String[]{shortName, dateString, componentString}));
            }
            String subcomponentCycleText = WorkspaceComponentLabelProvider.getSubcomponentCycleText(wrapper);
            if (subcomponentCycleText != null) {
                label.setText(NLS.bind((String)Messages.WorkspaceComponentLabelProvider_0, (Object)label.getText(), (Object)subcomponentCycleText));
            }
        }
    }

    private void setBaselineIdAsLabel(IBaseline baseLine, ViewerLabel label) {
        label.setText(String.valueOf(baseLine.getId()));
    }

    private void setBaselineNameAsLabel(IBaseline baseLine, ViewerLabel label) {
        label.setText(baseLine.getName());
    }

    private void setBaselineDescriptionAsLabel(IBaseline baseLine, ViewerLabel label) {
        label.setText(baseLine.getComment());
    }

    public static String getDate(Date date) {
        DateFormat shortDateFormat = DateFormat.getDateTimeInstance(2, 3);
        return shortDateFormat.format(date);
    }

    private String getText(IViewerLabelProvider labelProvider, Object element) {
        if (labelProvider == null) {
            return "";
        }
        ViewerLabel vl = new ViewerLabel("", null);
        labelProvider.updateLabel(vl, element);
        return vl.getText();
    }

    public static String getText(IBaseline baseline, boolean showDate) {
        Date date;
        String text = BaselineWrapper.getLabel(baseline);
        if (showDate && (date = baseline.getCreationDate()) != null) {
            text = NLS.bind((String)Messages.BaselineLabelProvider_0, (Object)text, (Object)BaselineLabelProvider.getDate(date));
        }
        return text;
    }

    public void dispose() {
        if (this.componentLabel != null) {
            this.componentLabel.dispose();
            this.componentLabel = null;
        }
        super.dispose();
    }

    @Override
    protected IItem getSharedItemFor(Object element) {
        return ((AbstractWrapper)((Object)element)).getItem();
    }
}

