/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.labelproviders;

import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.namespace.impl.DescriptionRecord;
import com.ibm.team.filesystem.client.internal.namespace.impl.EraCache;
import com.ibm.team.filesystem.ui.wrapper.ChangeSetWrapper;
import com.ibm.team.filesystem.ui.wrapper.PlannedForWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.links.client.ILinkEvent;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.SlowFunction;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.internal.util.ItemId;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.services.IDisposable;

public abstract class AbstractPlannedForFunction<T>
extends SlowFunction<T, PlannedForWrapper>
implements IDisposable {
    protected IListener linkListener;
    protected ITeamRepository repo;

    protected abstract ITeamRepository getRepository(T var1);

    protected abstract Collection<ChangeSetWrapper> getChangeSetsForViewObjects(Collection<T> var1);

    protected abstract T getViewObjectForChangeSet(IChangeSetHandle var1);

    public AbstractPlannedForFunction(ISetWithListeners<T> domain, IOperationRunner runner, Display display, boolean isLazy) {
        super(domain, runner, display, isLazy);
    }

    protected Map<T, PlannedForWrapper> doFetch(Collection<T> toFetch, IProgressMonitor monitor) throws OperationFailedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap<T, PlannedForWrapper> result = new HashMap<T, PlannedForWrapper>();
        if (toFetch.isEmpty() || this.repo == null) {
            return result;
        }
        try {
            if (!this.repo.loggedIn()) {
                this.repo.login((IProgressMonitor)progress.newChild(10));
            }
        }
        catch (TeamRepositoryException e) {
            throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
        }
        Collection<ChangeSetWrapper> changeSetWrappers = this.getChangeSetsForViewObjects(toFetch);
        try {
            List<IChangeSet> changeSets = ChangeSetWrapper.getChangeSets(changeSetWrappers);
            Map changeSetToDescriptionMap = EraCache.fetchDescriptions((ITeamRepository)this.repo, changeSets, (IRepositoryResolver)IRepositoryResolver.EXISTING_SHARED, (IProgressMonitor)progress.newChild(90));
            for (Map.Entry entry : changeSetToDescriptionMap.entrySet()) {
                IChangeSetLinkSummary linkSummary = ((DescriptionRecord)entry.getValue()).getChangeSetLinkSummary();
                if (linkSummary == null) continue;
                List plannedFor = linkSummary.getPlannedForNames();
                IChangeSetHandle changeSetHandle = (IChangeSetHandle)((ItemId)entry.getKey()).toHandle((Object)this.repo);
                T viewObject = this.getViewObjectForChangeSet(changeSetHandle);
                if (viewObject == null) continue;
                result.put(viewObject, new PlannedForWrapper(changeSetHandle, plannedFor));
            }
        }
        catch (TeamRepositoryException e) {
            throw new OperationFailedException(StatusUtil.newStatus((Object)((Object)this), (Throwable)e));
        }
        return result;
    }

    protected IListener createLinkListener() {
        return new IListener(){

            public void handleEvents(List events) {
                for (Object event : events) {
                    IChangeSetHandle changeSetHandle;
                    Object viewObject;
                    ILink link;
                    IReference sourceRef;
                    Object sourceRefObject;
                    if (!(event instanceof ILinkEvent) || !((sourceRefObject = (sourceRef = (link = ((ILinkEvent)event).getLink()).getSourceRef()).resolve()) instanceof IChangeSetHandle) || (viewObject = AbstractPlannedForFunction.this.getViewObjectForChangeSet(changeSetHandle = (IChangeSetHandle)sourceRefObject)) == null) continue;
                    AbstractPlannedForFunction.this.markDirty(viewObject);
                }
            }
        };
    }

    protected String getOperationName() {
        return Messages.PlannedForFunction_operationName;
    }

    protected PlannedForWrapper getDefaultValue() {
        return null;
    }

    protected void elementAdded(T element) {
        ITeamRepository repoFromElement = this.getRepository(element);
        if (repoFromElement != null && !repoFromElement.equals(this.repo)) {
            this.disposeListenerAndRepo();
        }
        if (this.linkListener == null) {
            this.linkListener = this.createLinkListener();
            this.repo = repoFromElement;
            if (this.repo != null) {
                ILinkManager linkManager = (ILinkManager)this.repo.getClientLibrary(ILinkManager.class);
                linkManager.addGenericListener((Object)"com.ibm.team.links.LinkSaveEvent", this.linkListener);
                linkManager.addGenericListener((Object)"com.ibm.team.links.LinkDeletedEvent", this.linkListener);
            }
        }
        super.elementAdded(element);
    }

    public void dispose() {
        this.disposeListenerAndRepo();
    }

    private void disposeListenerAndRepo() {
        if (this.linkListener != null && this.repo != null) {
            ILinkManager linkManager = (ILinkManager)this.repo.getClientLibrary(ILinkManager.class);
            linkManager.removeGenericListener((Object)"com.ibm.team.links.LinkSaveEvent", this.linkListener);
            linkManager.removeGenericListener((Object)"com.ibm.team.links.LinkDeletedEvent", this.linkListener);
        }
        this.linkListener = null;
        this.repo = null;
    }
}

