/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.ignore;

import java.util.Comparator;
import org.eclipse.core.resources.IResource;

public class ResourceComparator
implements Comparator<IResource> {
    public static final int[] TYPE_ORDERING = new int[]{8, 4, 2, 1};
    private static ResourceComparator instance = new ResourceComparator();

    private static int getIndex(int type) {
        int i = 0;
        while (i < TYPE_ORDERING.length) {
            if (TYPE_ORDERING[i] == type) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException("Unknown resource type " + type);
    }

    private ResourceComparator() {
    }

    public static ResourceComparator getInstance() {
        return instance;
    }

    @Override
    public int compare(IResource o1, IResource o2) {
        int o2Index;
        if (o1.getType() == o2.getType()) {
            return o1.getName().compareTo(o2.getName());
        }
        int o1Index = ResourceComparator.getIndex(o1.getType());
        if (o1Index < (o2Index = ResourceComparator.getIndex(o2.getType()))) {
            return -1;
        }
        if (o1Index == o2Index) {
            return 0;
        }
        return 1;
    }
}

