/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.ignore;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.internal.filesystem.ui.util.ShareablesUtil;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Display;

public class IgnoresPatternQuery
extends AbstractSetWithListeners<IgnoreRule>
implements DefaultIgnoreProvider.IIgnoreVisitor {
    LinkedList<IgnoreRule> ignorePatterns = new LinkedList();
    List<IProject> projectsToShare = null;
    final IgnoreManager ignoreManager;
    final DefaultIgnoreProvider ignoresProvider;
    final Display display;

    public IgnoresPatternQuery(Display display, IgnoreManager ignoreManager, DefaultIgnoreProvider ignoresProvider) throws FileSystemException {
        this.display = display;
        this.ignoreManager = ignoreManager;
        this.ignoresProvider = ignoresProvider;
        ignoreManager.addGenericListener((Object[])IIgnoreEvent.ALL_EVENTS, new IListener(){

            public void handleEvents(final List events) {
                IgnoresPatternQuery.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IgnoresPatternQuery.this.onIgnoreEvents(events);
                    }
                });
            }
        });
    }

    public void init(List<IProject> projects) {
        this.ignorePatterns = new LinkedList();
        ArrayList<IShareable> roots = new ArrayList<IShareable>(projects.size());
        for (IProject project : projects) {
            roots.add(ShareablesUtil.getShareableWithoutSandbox((IResource)project));
        }
        try {
            this.ignoresProvider.accept(roots, (DefaultIgnoreProvider.IIgnoreVisitor)this, null, null);
        }
        catch (FileSystemException e) {
            StatusUtil.log((Object)"com.ibm.team.filesystem.client", (Throwable)e);
        }
    }

    private IgnoreEventType getEventType(IIgnoreEvent event) {
        if ("ignore".equals(event.getChangeType())) {
            return IgnoreEventType.ADD;
        }
        if ("unignore".equals(event.getChangeType())) {
            return IgnoreEventType.REMOVE;
        }
        if ("unknown".equals(event.getChangeType())) {
            return IgnoreEventType.UNKNOWN;
        }
        throw new RuntimeException("Could not determine ignore mode for " + event.getChangeType());
    }

    private void onIgnoreEvent(IIgnoreEvent event) {
        Collection rules = event.getRules();
        IgnoreEventType mode = this.getEventType(event);
        for (IIgnoreProvider.IIgnoreRule rule : rules) {
            switch (mode) {
                case ADD: {
                    this.ignorePatterns.add((IgnoreRule)rule);
                    this.fireAdded((IgnoreRule)rule);
                    break;
                }
                case REMOVE: {
                    this.ignorePatterns.remove(rule);
                    this.fireRemoved((IgnoreRule)rule);
                    break;
                }
                default: {
                    StatusUtil.log((Object)"com.ibm.team.filesystem.ide.ui", (int)4, (String)("Don't know how to handle ignore event type " + (Object)((Object)mode)));
                }
            }
        }
    }

    private void onIgnoreEvents(List<IIgnoreEvent> events) {
        for (IIgnoreEvent event : events) {
            this.onIgnoreEvent(event);
        }
    }

    public void visit(Collection<IgnoreRule> rules) {
        this.ignorePatterns.addAll(rules);
    }

    protected Collection<IgnoreRule> computeElements() {
        return this.ignorePatterns;
    }

    private static enum IgnoreEventType {
        ADD,
        REMOVE,
        UNKNOWN;

    }
}

