/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.ignore;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoredItemSet;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.labelproviders.ResourceLabelProvider;
import com.ibm.team.internal.filesystem.ui.util.ShareablesUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Color;

public class IgnoredResourceLabelProvider
extends ResourceLabelProvider {
    private static final String TEXT_PROCESS_SEPARATORS = "()";
    IIgnoreManager manager;
    final IgnoredItemSet set;
    private final Color ignoredForeground;

    public IgnoredResourceLabelProvider(IgnoredItemSet ignoredItems, Color ignoredForeground) {
        this.set = ignoredItems;
        this.ignoredForeground = ignoredForeground;
    }

    public void setIgnoreManager(IIgnoreManager ignoreManager) {
        this.manager = ignoreManager;
    }

    @Override
    protected void updateText(ViewerLabel label, IResource resource) {
        super.updateText(label, resource);
        if (this.manager == null) {
            return;
        }
        IShareable shareable = ShareablesUtil.getShareableWithoutSandbox(resource);
        if (this.manager.shouldBeIgnored(shareable, (IProgressMonitor)TempHelper.MONITOR)) {
            String suffix = null;
            boolean isInherited = false;
            boolean isModifiable = false;
            IIgnoreManager.IIgnoreReason reason = null;
            if (this.set != null && this.set.hasIgnoredAncestor(shareable)) {
                isInherited = true;
            }
            if (!isInherited) {
                try {
                    reason = this.manager.findIgnoreReasons(shareable, (IProgressMonitor)TempHelper.MONITOR);
                }
                catch (FileSystemException e) {
                    label.setText(NLS.bind((String)Messages.IgnoredResourceLabelProvider_0, (Object)label.getText(), (Object)e.getMessage()));
                    return;
                }
                assert (reason != null);
                if (reason.inherited()) {
                    isInherited = true;
                } else {
                    for (IIgnoreProvider.IIgnoreRule rule : reason.getRules()) {
                        if (!(rule.getProvider() instanceof DefaultIgnoreProvider)) continue;
                        isModifiable = true;
                        break;
                    }
                }
            }
            if (isInherited) {
                assert (suffix == null);
                suffix = Messages.IgnoredResourceLabelProvider_1;
            } else if (isModifiable) {
                suffix = this.set == null ? Messages.IgnoredResourceLabelProvider_3 : NLS.bind((String)Messages.IgnoredResourceLabelProvider_4, (Object)this.set.getIgnoredDescendentCount(shareable));
            } else if (reason != null) {
                String ruleText = null;
                for (IIgnoreProvider.IIgnoreRule rule : reason.getRules()) {
                    ruleText = ruleText == null ? rule.getShortDescription() : NLS.bind((String)Messages.IgnoredResourceLabelProvider_5, (Object)ruleText, (Object)rule.getShortDescription());
                }
                suffix = NLS.bind((String)Messages.IgnoredResourceLabelProvider_6, ruleText);
            }
            label.setText(TextProcessor.process((String)NLS.bind((String)Messages.IgnoredResourceLabelProvider_2, (Object)label.getText(), (Object)suffix), (String)TEXT_PROCESS_SEPARATORS));
            label.setForeground(this.ignoredForeground);
        }
    }
}

