/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.handlers;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.ce.ChangeSummaryView;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsComponentEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemEntry;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryViewUtil;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractConfigurationHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.AbstractVersionableHistoryViewInput;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.StateId;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowHistoryHandler
extends AbstractHandler {
    private static String getFullyQualifiedName(CombinedChangeSetsItemEntry itemEntry) {
        String name = itemEntry.getName();
        if (name == null && (name = itemEntry.getFallbackName()) == null) {
            return Messages.CompareWithAction_6;
        }
        String path = itemEntry.getPath();
        if (path == null) {
            return name;
        }
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + '/';
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return String.valueOf(path) + name;
    }

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ChangeSummaryView view = (ChangeSummaryView)HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        Shell shell = activeWorkbenchWindow.getShell();
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        Object element = selection.getFirstElement();
        AbstractHistoryViewInput input = this.createHistoryInput(view, element);
        if (input != null) {
            HistoryViewUtil.showHistory(UIContext.createShellContext((Shell)shell), input);
        }
        return null;
    }

    private StateId getStateId(CombinedChangeSetsItemEntry entry) {
        UUID finalState = entry.getEstimatedFinalState();
        IVersionableHandle versionable = entry.getVersionableHandle();
        UUID itemId = versionable.getItemId();
        IItemType type = versionable.getItemType();
        return finalState == null ? StateId.getDeletedState((IItemType)type, (UUID)itemId) : new StateId(type, itemId, finalState);
    }

    private AbstractHistoryViewInput createHistoryInput(ChangeSummaryView view, Object element) throws ExecutionException {
        if (element instanceof CombinedChangeSetsComponentEntry) {
            CombinedChangeSetsComponentEntry entry = (CombinedChangeSetsComponentEntry)element;
            ItemNamespace itemNamespace = view.getItemNamespace(entry.getComponentId());
            if (itemNamespace == null) {
                throw new ExecutionException(element.toString());
            }
            return AbstractConfigurationHistoryViewInput.newConfigurationHistoryViewInput(itemNamespace, null);
        }
        if (element instanceof CombinedChangeSetsItemEntry) {
            CombinedChangeSetsItemEntry entry = (CombinedChangeSetsItemEntry)element;
            ItemNamespace itemNamespace = view.getItemNamespace(entry.getItemId());
            if (itemNamespace == null) {
                throw new ExecutionException(element.toString());
            }
            String fqName = ShowHistoryHandler.getFullyQualifiedName(entry);
            StateId stateId = this.getStateId(entry);
            return AbstractVersionableHistoryViewInput.newVersionableHistoryViewInput(AbstractFileSystemItemWrapper.newWrapper(stateId, fqName, itemNamespace));
        }
        throw new ExecutionException(element.toString());
    }
}

