/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.handlers;

import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.views.ce.ChangeSummaryView;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsComponentEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedSubcomponentChangeEntry;
import com.ibm.team.internal.filesystem.ui.views.history.HistoryViewUtil;
import com.ibm.team.internal.filesystem.ui.views.history.inputs.BaselinesInRepositoryHistoryViewInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesComponentNode;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.nodes.StructuralChangesSubcomponentNode;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ShowBaselinesHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object entry;
        ITeamRepository repository = null;
        UUID componentID = null;
        Object selectedItem = this.getSelectedObject(event);
        if (selectedItem == null) {
            return null;
        }
        IWorkbenchPart activePart = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        if (selectedItem instanceof CombinedChangeSetsComponentEntry) {
            entry = (CombinedChangeSetsComponentEntry)selectedItem;
            repository = ((ChangeSummaryView)activePart).getSnapshotId().getRepository();
            componentID = ((CombinedChangeSetsComponentEntry)entry).getComponentId();
        } else if (selectedItem instanceof CombinedSubcomponentChangeEntry) {
            entry = (CombinedSubcomponentChangeEntry)selectedItem;
            repository = ((CombinedSubcomponentChangeEntry)entry).getRepository();
            if (((CombinedSubcomponentChangeEntry)entry).getComponent() != null) {
                componentID = ((CombinedSubcomponentChangeEntry)entry).getComponent().getItemId();
            }
        } else if (selectedItem instanceof StructuralChangesComponentNode) {
            entry = (StructuralChangesComponentNode)selectedItem;
            repository = ((StructuralChangesComponentNode)entry).getRepository();
            if (((StructuralChangesComponentNode)entry).getComponent() != null) {
                componentID = ((StructuralChangesComponentNode)entry).getComponent().getItemId();
            }
        } else if (selectedItem instanceof StructuralChangesSubcomponentNode) {
            entry = (StructuralChangesSubcomponentNode)selectedItem;
            repository = ((StructuralChangesSubcomponentNode)entry).getRepository();
            if (((StructuralChangesSubcomponentNode)entry).getComponent() != null) {
                componentID = ((StructuralChangesSubcomponentNode)entry).getComponent().getItemId();
            }
        } else if (selectedItem instanceof WorkspaceComponentWrapper) {
            entry = (WorkspaceComponentWrapper)selectedItem;
            repository = ((WorkspaceComponentWrapper)entry).getRepository();
            componentID = ((WorkspaceComponentWrapper)entry).getComponentHandle().getItemId();
        }
        if (repository != null && componentID != null) {
            ItemId itemId = ItemId.create((IItemHandle)IComponent.ITEM_TYPE.createItemHandle(componentID, null));
            HistoryViewUtil.showHistory(UIContext.createPartContext((IWorkbenchPart)activePart), new BaselinesInRepositoryHistoryViewInput(repository, (ItemId<IComponent>)itemId));
        }
        return null;
    }

    private Object getSelectedObject(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structureSelection;
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (structureSelection = (IStructuredSelection)selection).size() == 1) {
            return structureSelection.getFirstElement();
        }
        return null;
    }
}

