/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.handlers;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.ui.editor.PartUtil;
import com.ibm.team.filesystem.ui.editor.RemoteFileEditorInput;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemEntry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.impl.MessageDialogFactory;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenRemoteFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)selection;
            this.open(event, iss);
        }
        return null;
    }

    private void open(ExecutionEvent event, final IStructuredSelection iss) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        final UIContext context = UIContext.createPartContext((IWorkbenchPart)part);
        ITeamRepository repository = (ITeamRepository)((CombinedChangeSetsItemEntry)iss.getFirstElement()).getVersionableHandle().getOrigin();
        JobRunner.enqueue((String)Messages.OpenAfterStateAction_2, (boolean)true, (Operation)new RepositoryOperation(repository){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                final ArrayList<String> invalidItems = new ArrayList<String>();
                final int[] deletedItems = new int[1];
                SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)iss.size());
                ArrayList<RemoteFileEditorInput> inputs = new ArrayList<RemoteFileEditorInput>();
                Object[] objectArray = iss.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    CombinedChangeSetsItemEntry e = (CombinedChangeSetsItemEntry)o;
                    if (e.getEstimatedFinalState() == null) {
                        if (!e.isComparable()) {
                            String name = e.getName();
                            if (name == null) {
                                invalidItems.add(e.getFallbackName());
                            } else {
                                invalidItems.add(name);
                            }
                            sm.worked(1);
                        } else {
                            deletedItems[0] = deletedItems[0] + 1;
                        }
                    } else {
                        inputs.add(RemoteFileEditorInput.createInput((ITeamRepository)e.getVersionableHandle().getOrigin(), (StateId<? extends IVersionable>)new StateId(IFileItem.ITEM_TYPE, e.getVersionableHandle().getItemId(), e.getEstimatedFinalState()), null, (IProgressMonitor)sm.newChild(1)));
                    }
                    ++n2;
                }
                if (!sm.isCanceled()) {
                    for (RemoteFileEditorInput input : inputs) {
                        PartUtil.openEditor(context, input, null, true);
                    }
                    context.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            int i = 0;
                            while (i < deletedItems[0]) {
                                MessageDialogFactory.showMessage((Shell)context.getShell(), (int)1, (String)Messages.OpenAfterStateAction_0, (String)Messages.OpenAfterStateAction_1);
                                ++i;
                            }
                            if (!invalidItems.isEmpty()) {
                                if (invalidItems.size() == 1) {
                                    MessageDialog.openError((Shell)context.getShell(), (String)Messages.OpenRemoteFileHandler_openFailureDialogTitle, (String)NLS.bind((String)Messages.OpenRemoteFileHandler_singleOpenFailureDialogMessage, invalidItems.get(0)));
                                } else {
                                    InvalidDialog dialog = new InvalidDialog(context.getShell(), invalidItems);
                                    dialog.open();
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    class InvalidDialog
    extends Dialog {
        private List<String> invalidItems;

        public InvalidDialog(Shell shell, List<String> invalidItems) {
            super(shell);
            this.invalidItems = invalidItems;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.OpenRemoteFileHandler_openFailureDialogTitle);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label label = new Label(composite, 16384);
            label.setText(Messages.OpenRemoteFileHandler_multiOpenFailureDialogMessage);
            org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(composite, 2048);
            for (String invalidItem : this.invalidItems) {
                list.add(invalidItem);
            }
            InvalidDialog.applyDialogFont((Control)composite);
            GridData data = new GridData(4, 4, true, true);
            data.heightHint = list.getItemHeight() * 8;
            list.setLayoutData((Object)data);
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
    }
}

