/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.handlers;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.ui.changes.actions.OpenLocalFileAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemEntry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.WorkbenchJob;

public class OpenLocalFileHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)selection;
            this.open(event, iss);
        }
        return null;
    }

    private void open(ExecutionEvent event, final IStructuredSelection iss) throws ExecutionException {
        final IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ITeamRepository repository = (ITeamRepository)((CombinedChangeSetsItemEntry)iss.getFirstElement()).getVersionableHandle().getOrigin();
        JobRunner.enqueue((String)Messages.OpenLocalFileAction_0, (boolean)true, (Operation)new RepositoryOperation(repository){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)iss.size());
                ISharingManager mgr = FileSystemCore.getSharingManager();
                final ArrayList shareables = new ArrayList();
                Object[] objectArray = iss.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    IVersionableHandle versionable = null;
                    if (o instanceof IAdaptable) {
                        versionable = (IVersionableHandle)((IAdaptable)o).getAdapter(IVersionableHandle.class);
                    }
                    if (versionable == null) {
                        versionable = (IVersionableHandle)Platform.getAdapterManager().getAdapter(o, IVersionableHandle.class);
                    }
                    if (versionable != null) {
                        shareables.addAll(mgr.findShareables(versionable, (IProgressMonitor)sm.newChild(1)));
                    }
                    ++n2;
                }
                new WorkbenchJob(Messages.OpenLocalFileAction_1){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (shareables.isEmpty()) {
                            MessageDialog.openWarning((Shell)workbenchWindow.getShell(), (String)Messages.OpenLocalFileAction_2, (String)Messages.OpenLocalFileAction_3);
                            return Status.CANCEL_STATUS;
                        }
                        IWorkbenchPage page = workbenchWindow.getActivePage();
                        if (page != null) {
                            for (IShareable shareable : shareables) {
                                OpenLocalFileAction.openLocalFile(workbenchWindow.getShell(), page, shareable);
                            }
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        });
    }
}

