/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.handlers;

import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.ui.changes.actions.CreatePatchAction;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.patches.ChangeFolder;
import com.ibm.team.internal.filesystem.ui.views.ce.AggregateChangesTree;
import com.ibm.team.internal.filesystem.ui.views.ce.ChangeSummaryView;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsParentEntry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.utils.SWTUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class NewPatchHandler
extends AbstractHandler {
    public final Object execute(ExecutionEvent event) throws ExecutionException {
        final IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (!this.isComplete(selection)) {
            StatusManager.getManager().handle((IStatus)new Status(4, Messages.NewPatchHandler_incompleteChangeDialogTitle, Messages.NewPatchHandler_incompleteChangeDialogMessage), 2);
            return null;
        }
        final IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        final ChangeSummaryView view = (ChangeSummaryView)HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        ITeamRepository repository = view.getSnapshotId().getRepository();
        JobRunner runner = new JobRunner(true);
        runner.enqueue(Messages.CreatePatchAction_ComputingPatchJobName, (Operation)new RepositoryOperation(repository){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                final ArrayList<ChangeFolder> selectedElements = new ArrayList<ChangeFolder>();
                HashSet<CombinedChangeSetsParentEntry> processed = new HashSet<CombinedChangeSetsParentEntry>();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CombinedChangeSetsItemEntry entry;
                    Object o = objectArray[n2];
                    if (o instanceof CombinedChangeSetsParentEntry) {
                        CombinedChangeSetsParentEntry parent = (CombinedChangeSetsParentEntry)o;
                        ChangeFolder changeFolder = null;
                        CombinedChangeSetsItemEntry[] combinedChangeSetsItemEntryArray = parent.getItemEntries();
                        int n3 = combinedChangeSetsItemEntryArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            CombinedChangeSetsItemEntry entry2 = combinedChangeSetsItemEntryArray[n4];
                            UUID componentId = NewPatchHandler.getComponentId(parent);
                            if (changeFolder == null) {
                                changeFolder = new ChangeFolder((SiloedItemId<IFolder>)new SiloedItemId(IFolder.ITEM_TYPE, parent.getFolderItemId(), componentId));
                            }
                            changeFolder.addChange(this.createFileChange(componentId, entry2));
                            ++n4;
                        }
                        processed.add(parent);
                        selectedElements.add(changeFolder);
                    } else if (o instanceof CombinedChangeSetsItemEntry && !processed.contains((entry = (CombinedChangeSetsItemEntry)o).getParent())) {
                        selectedElements.add((ChangeFolder)this.createFileChange(NewPatchHandler.getComponentId(entry), entry));
                    }
                    ++n2;
                }
                if (selectedElements.isEmpty()) {
                    return;
                }
                final Shell shell = activeWorkbenchWindow.getShell();
                SWTUtil.greedyExec((Display)shell.getDisplay(), (Control)shell, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CreatePatchAction action = new CreatePatchAction();
                        action.init((IViewPart)view);
                        action.run(shell, activeWorkbenchWindow.getActivePage(), (IStructuredSelection)new StructuredSelection(selectedElements));
                    }
                });
            }

            private FileChange createFileChange(UUID componentId, CombinedChangeSetsItemEntry entry) throws TeamRepositoryException {
                FileState afterFileState = AggregateChangesTree.createAfterFileState(entry, null);
                FileState beforeFileState = AggregateChangesTree.createBeforeFileState(entry, null);
                SiloedItemId itemId = new SiloedItemId(entry.getVersionableHandle().getItemType(), entry.getItemId(), componentId);
                return new FileChange(beforeFileState, afterFileState, itemId);
            }
        });
        return null;
    }

    private boolean isComplete(IStructuredSelection selection) {
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof CombinedChangeSetsParentEntry) {
                CombinedChangeSetsParentEntry parent = (CombinedChangeSetsParentEntry)o;
                CombinedChangeSetsItemEntry[] combinedChangeSetsItemEntryArray = parent.getItemEntries();
                int n3 = combinedChangeSetsItemEntryArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    CombinedChangeSetsItemEntry entry = combinedChangeSetsItemEntryArray[n4];
                    if (!entry.isComparable()) {
                        return false;
                    }
                    ++n4;
                }
            } else if (o instanceof CombinedChangeSetsItemEntry) {
                CombinedChangeSetsItemEntry entry = (CombinedChangeSetsItemEntry)o;
                if (!entry.isComparable()) {
                    return false;
                }
            } else {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static UUID getComponentId(CombinedChangeSetsItemEntry item) {
        return NewPatchHandler.getComponentId(item.getParent());
    }

    private static UUID getComponentId(CombinedChangeSetsParentEntry parent) {
        return parent.getParent().getComponentId();
    }
}

