/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.handlers;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.ide.ui.internal.actions.team.ConfigureVersionableAccessControlAction;
import com.ibm.team.filesystem.ui.wrapper.AbstractFileSystemItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.internal.filesystem.ui.views.ce.ChangeSummaryView;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsParentEntry;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class ChangeAccessControlHandler
extends AbstractHandler {
    public final Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        ChangeSummaryView view = (ChangeSummaryView)HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        Shell shell = activeWorkbenchWindow.getShell();
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        Object[] selectionArray = selection.toArray();
        ArrayList<AbstractFileSystemItemWrapper> wrappers = new ArrayList<AbstractFileSystemItemWrapper>(selectionArray.length);
        int i = 0;
        while (i < selectionArray.length) {
            AbstractFileSystemItemWrapper item = this.createWrapper(shell, selectionArray[i], view);
            if (item != null) {
                wrappers.add(item);
            }
            ++i;
        }
        ConfigureVersionableAccessControlAction action = new ConfigureVersionableAccessControlAction();
        action.init(part);
        action.run(shell, activeWorkbenchWindow.getActivePage(), (IStructuredSelection)new StructuredSelection(wrappers));
        return null;
    }

    private AbstractFileSystemItemWrapper createWrapper(Shell shell, Object selection, ChangeSummaryView view) {
        if (selection instanceof CombinedChangeSetsParentEntry) {
            CombinedChangeSetsParentEntry entry = (CombinedChangeSetsParentEntry)selection;
            return new FolderItemWrapper(new StateId(IFolder.ITEM_TYPE, entry.getFolderItemId(), StateId.STATE_DELETED), entry.getPath(), view.getItemNamespace(entry.getFolderItemId()));
        }
        if (selection instanceof CombinedChangeSetsItemEntry) {
            CombinedChangeSetsItemEntry entry = (CombinedChangeSetsItemEntry)selection;
            String fqName = String.valueOf(entry.getPath()) + entry.getName();
            fqName = fqName.substring(1);
            if (entry.getVersionableHandle() instanceof IFileItemHandle) {
                return new FileItemWrapper(new StateId(IFileItem.ITEM_TYPE, entry.getVersionableHandle().getItemId(), StateId.STATE_DELETED), fqName, view.getItemNamespace(entry.getItemId()));
            }
            return new FolderItemWrapper(new StateId(IFolder.ITEM_TYPE, entry.getVersionableHandle().getItemId(), StateId.STATE_DELETED), fqName, view.getItemNamespace(entry.getItemId()));
        }
        return null;
    }
}

