/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.handlers;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.ui.wrapper.FileItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.FolderItemWrapper;
import com.ibm.team.filesystem.ui.wrapper.SymbolicLinkItemWrapper;
import com.ibm.team.internal.filesystem.ui.views.ce.ChangeSummaryView;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemEntry;
import com.ibm.team.internal.filesystem.ui.views.ce.CombinedChangeSetsItemReviewEntry;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.StateId;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractWrapperHandler
extends AbstractHandler {
    public final Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        ChangeSummaryView view = (ChangeSummaryView)HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        Shell shell = activeWorkbenchWindow.getShell();
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        Object[] wrapper = this.createWrappers(view, selection);
        AbstractActionDelegate action = this.createActionDelegate();
        action.init(part);
        action.run(shell, activeWorkbenchWindow.getActivePage(), (IStructuredSelection)new StructuredSelection(wrapper));
        return null;
    }

    protected Object[] createWrappers(ChangeSummaryView view, IStructuredSelection selection) {
        Object[] array = selection.toArray();
        int i = 0;
        while (i < array.length) {
            CombinedChangeSetsItemEntry entry = (CombinedChangeSetsItemEntry)array[i];
            array[i] = this.createWrapper(entry, view.getItemNamespace(entry.getItemId()));
            ++i;
        }
        return array;
    }

    protected UUID getStateId(CombinedChangeSetsItemEntry entry) {
        CombinedChangeSetsItemReviewEntry reviewEntry = entry.getReviewEntries()[entry.getReviewEntries().length - 1];
        UUID finalState = reviewEntry.getAfter();
        return finalState == null ? reviewEntry.getBefore() : finalState;
    }

    protected Object createWrapper(CombinedChangeSetsItemEntry entry, ItemNamespace itemNamespace) {
        String fqName = String.valueOf(entry.getPath()) + entry.getName();
        fqName = fqName.substring(1);
        UUID stateId = this.getStateId(entry);
        IVersionableHandle handle = entry.getVersionableHandle();
        if (handle instanceof IFileItemHandle) {
            return new FileItemWrapper(new StateId(IFileItem.ITEM_TYPE, handle.getItemId(), stateId), fqName, itemNamespace);
        }
        if (handle instanceof ISymbolicLinkHandle) {
            return new SymbolicLinkItemWrapper(new StateId(ISymbolicLink.ITEM_TYPE, handle.getItemId(), stateId), fqName, itemNamespace);
        }
        return new FolderItemWrapper(new StateId(IFolder.ITEM_TYPE, handle.getItemId(), stateId), fqName, itemNamespace);
    }

    protected abstract AbstractActionDelegate createActionDelegate();
}

