/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.port;

import com.ibm.team.filesystem.ide.ui.internal.actions.port.ProcessPendingPortsAction;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.PortsCacheManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.CurrentPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortsNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.ui.changes.views.LocalSynchronizeDecorator;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.editors.port.PendingPortsPage;
import com.ibm.team.internal.filesystem.ui.editors.port.PortEditor;
import com.ibm.team.internal.filesystem.ui.editors.port.PortEditorInput;
import com.ibm.team.internal.filesystem.ui.labelproviders.PortLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SourceChangeSetControl {
    private IWorkspaceConnection fWorkspace;
    private IComponent fComponent;
    private IOperationRunner fOpRunner;
    private FormToolkit fToolkit;
    private IWorkbenchPartSite fParentPartSite;
    private PortsNode fPortsNode;
    private Composite fParentComposite;
    private Composite fMainComposite;
    private Composite fCurrentPortComposite;
    private DecoratingLabelProvider fChangeSetLabelProvider;
    private Link fCurrentPortHyperlink;
    private Label fCurrentPortIcon;
    private Link fCurrentPortText;
    private final String ACCEPT_HYPERLINK = Messages.SourceChangeSetControl_ACCEPT_HYPERLINK;

    public SourceChangeSetControl(FormToolkit toolkit, IWorkbenchPartSite parentPartSite, Composite parent, IWorkspaceConnection workspace, IComponent component, IOperationRunner operationRunner) {
        Assert.isNotNull((Object)parentPartSite);
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)workspace);
        Assert.isNotNull((Object)component);
        Assert.isNotNull((Object)operationRunner);
        this.fToolkit = toolkit;
        this.fParentPartSite = parentPartSite;
        this.fParentComposite = parent;
        this.fWorkspace = workspace;
        this.fComponent = component;
        this.fOpRunner = operationRunner;
        this.fMainComposite = this.createComposite(this.fParentComposite);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.fMainComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.fMainComposite);
        this.createCurrentPortWidgets(this.fMainComposite);
        this.requestRefresh();
    }

    public Composite getComposite() {
        return this.fMainComposite;
    }

    public void requestRefresh() {
        PortsNode portNode = PortsCacheManager.getInstance().getPortNode(this.fWorkspace.teamRepository(), (IWorkspaceHandle)this.fWorkspace.getResolvedWorkspace(), (IComponentHandle)this.fComponent);
        this.setPortsNode(portNode);
        this.refreshCurrentPortLabels();
    }

    private void createCurrentPortWidgets(Composite parent) {
        this.fCurrentPortHyperlink = new Link(parent, 0);
        this.fCurrentPortHyperlink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SourceChangeSetControl.this.openCurrentPortInChangeExplorer();
            }
        });
        Color labelForeground = null;
        if (this.fToolkit != null) {
            labelForeground = this.fToolkit.getColors().getColor("com.ibm.team.workitem.ide.ui.internal.editor.LABEL_FOREGROUND");
        }
        if (labelForeground != null) {
            this.fCurrentPortHyperlink.setForeground(labelForeground);
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)this.fCurrentPortHyperlink);
        this.fCurrentPortComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).applyTo((Control)this.fCurrentPortComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(this.fCurrentPortComposite);
        this.fCurrentPortIcon = this.createLabel(this.fCurrentPortComposite, null);
        this.fCurrentPortIcon.setImage(null);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).indent(2, 0).applyTo((Control)this.fCurrentPortIcon);
        this.fCurrentPortText = new Link(this.fCurrentPortComposite, 0);
        this.fCurrentPortText.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (SourceChangeSetControl.this.ACCEPT_HYPERLINK.equals(event.text)) {
                    SourceChangeSetControl.this.doStartPorting();
                }
                if (PendingPortsPage.PAGE_NAME.equals(event.text)) {
                    SourceChangeSetControl.this.openPendingPortsPage();
                }
                if (LocalWorkspaceChangesView.VIEW_NAME.equals(event.text)) {
                    SourceChangeSetControl.this.openPendingChangesView();
                }
            }
        });
        if (labelForeground != null) {
            this.fCurrentPortText.setForeground(labelForeground);
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).indent(-2, 0).applyTo((Control)this.fCurrentPortText);
        this.setNoCurrentPortText();
    }

    private void refreshCurrentPortLabels() {
        PortsNode portsNode = this.getPortsNode();
        if (portsNode != null && portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode() != null) {
            CurrentPortNode currentPortNode = portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode();
            this.fCurrentPortHyperlink.setText(currentPortNode.getPortSourceChangeSet() == null ? Messages.SourceChangeSetControl_NO_CHANGE_SET_SOURCE_LABEL : Messages.SourceChangeSetControl_SOURCE_CHANGE_SET_HYPERLINK);
            if (currentPortNode.getPortSourceChangeSet() != null) {
                this.setVisible(true);
                if (this.fChangeSetLabelProvider == null) {
                    AbstractSetWithListeners<CurrentPortNode> set = new AbstractSetWithListeners<CurrentPortNode>(){

                        protected Collection<CurrentPortNode> computeElements() {
                            CurrentPortNode currentPortNode;
                            PortsNode portsNode = SourceChangeSetControl.this.getPortsNode();
                            if (portsNode != null && (currentPortNode = portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode()) != null) {
                                return Collections.singletonList(currentPortNode);
                            }
                            return Collections.emptyList();
                        }
                    };
                    PortLabelProvider labelProvider = new PortLabelProvider((ISetWithListeners)set, this.fOpRunner);
                    LocalSynchronizeDecorator labelDecorator = new LocalSynchronizeDecorator(true);
                    this.fChangeSetLabelProvider = new DecoratingLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)labelDecorator);
                    this.fChangeSetLabelProvider.addListener(new ILabelProviderListener(){

                        public void labelProviderChanged(LabelProviderChangedEvent event) {
                            CurrentPortNode currentPortNode;
                            PortsNode portsNode = SourceChangeSetControl.this.getPortsNode();
                            if (portsNode != null && (currentPortNode = portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode()) != null && currentPortNode.equals(event.getElement())) {
                                boolean updated = false;
                                if (SourceChangeSetControl.this.fCurrentPortIcon != null && !SourceChangeSetControl.this.fCurrentPortIcon.isDisposed()) {
                                    Image newImage = SourceChangeSetControl.this.fChangeSetLabelProvider.getImage((Object)currentPortNode);
                                    if (SourceChangeSetControl.this.fCurrentPortIcon.getImage() == null || !SourceChangeSetControl.this.fCurrentPortIcon.getImage().equals((Object)newImage)) {
                                        SourceChangeSetControl.this.fCurrentPortIcon.setImage(SourceChangeSetControl.this.fChangeSetLabelProvider.getImage((Object)currentPortNode));
                                        updated = true;
                                    }
                                }
                                if (SourceChangeSetControl.this.fCurrentPortText != null && !SourceChangeSetControl.this.fCurrentPortText.isDisposed()) {
                                    String newText = SourceChangeSetControl.this.fChangeSetLabelProvider.getText((Object)currentPortNode);
                                    if (!SourceChangeSetControl.this.fCurrentPortText.getText().equals(newText)) {
                                        SourceChangeSetControl.this.fCurrentPortText.setText(SourceChangeSetControl.this.fChangeSetLabelProvider.getText((Object)currentPortNode));
                                        updated = true;
                                    }
                                }
                                if (updated && SourceChangeSetControl.this.fParentComposite != null && !SourceChangeSetControl.this.fParentComposite.isDisposed()) {
                                    SourceChangeSetControl.this.fParentComposite.layout();
                                }
                            }
                        }
                    });
                }
                this.fCurrentPortIcon.setImage(this.fChangeSetLabelProvider.getImage((Object)currentPortNode));
                String text = this.fChangeSetLabelProvider.getText((Object)currentPortNode);
                if (text == null) {
                    text = "";
                }
                this.fCurrentPortText.setText(text);
                this.fParentComposite.layout();
            } else {
                this.setVisible(false);
            }
        } else {
            this.setVisible(true);
            this.setNoCurrentPortText();
        }
    }

    private void setVisible(boolean visible) {
        if (!this.fMainComposite.isDisposed()) {
            this.fMainComposite.setVisible(visible);
            GridData data = (GridData)this.fMainComposite.getLayoutData();
            data.exclude = !visible;
            this.fMainComposite.setLayoutData((Object)data);
            if (!this.fParentComposite.isDisposed()) {
                this.fParentComposite.layout();
            }
        }
    }

    private void setNoCurrentPortText() {
        IComponentSyncContext context;
        this.fCurrentPortHyperlink.setText(Messages.SourceChangeSetControl_SOURCE_CHANGE_SET_NO_HYPERLINK);
        this.fCurrentPortIcon.setImage(null);
        String pendingPortsPageHyperlink = PendingPortsPage.PAGE_NAME;
        String message = NLS.bind((String)Messages.SourceChangeSetControl_NO_SOURCE_CHANGE_SET_HYPERLINK_TEXT, (Object)this.ACCEPT_HYPERLINK, (Object)pendingPortsPageHyperlink);
        IComponentSyncContext[] contexts = ComponentSyncModel.getInstance().getComponentSyncContexts((IConnection)this.fWorkspace, (IComponentHandle)this.fComponent);
        if (contexts.length > 0 && (context = contexts[0]) != null && context.getUnresolvedSource().containsConflict()) {
            message = NLS.bind((String)Messages.SourceChangeSetControl_CONFLICTS_IN_PENDING_CHANGES_VIEW, (Object)LocalWorkspaceChangesView.VIEW_NAME);
        }
        this.fCurrentPortText.setText(message);
        this.fParentComposite.layout();
    }

    private void openCurrentPortInChangeExplorer() {
        CurrentPortNode currentPortNode;
        PortsNode portsNode = this.getPortsNode();
        if (portsNode != null && (currentPortNode = portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode()) != null && currentPortNode.getPortSourceChangeSet() != null) {
            ChangesViewConverter.openChangeExplorer(this.fParentPartSite.getPage(), new ChangeSetInput(Arrays.asList(currentPortNode.getPortSourceChangeSet())));
        }
    }

    private void doStartPorting() {
        ProcessPendingPortsAction.processPendingPorts(this.fParentPartSite.getPart(), this.fOpRunner, this.fWorkspace, this.fComponent, false);
    }

    private void openPendingPortsPage() {
        PortEditor portEditor = (PortEditor)((Object)this.fParentPartSite.getPart().getAdapter(PortEditor.class));
        PortEditorInput portEditorInput = portEditor.getPortEditorInput();
        if (portEditor != null && portEditorInput != null && portEditorInput.getWorkspace().equals((Object)this.fWorkspace) && portEditorInput.getComponent().sameItemId((IItemHandle)this.fComponent)) {
            portEditor.setActivePage("com.ibm.team.internal.filesystem.ui.editors.port.PendingPortsPage");
        } else {
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                int n3 = iWorkbenchPageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
                    int n5 = iEditorReferenceArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IWorkbenchPart part;
                        IEditorReference editor = iEditorReferenceArray[n6];
                        if (editor.getId().equals("com.ibm.team.filesystem.ide.ui.PortEditor") && (part = editor.getPart(true)) instanceof PortEditor && (portEditorInput = (portEditor = (PortEditor)part).getPortEditorInput()) != null && portEditorInput.getWorkspace().equals((Object)this.fWorkspace) && portEditorInput.getComponent().sameItemId((IItemHandle)this.fComponent)) {
                            portEditor.setActivePage("com.ibm.team.internal.filesystem.ui.editors.port.PendingPortsPage");
                            return;
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void openPendingChangesView() {
        try {
            this.fParentPartSite.getPage().showView("com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesView");
        }
        catch (PartInitException e) {
            StatusUtil.log((Object)this, (Throwable)e);
        }
    }

    private synchronized PortsNode getPortsNode() {
        return this.fPortsNode;
    }

    private synchronized void setPortsNode(PortsNode portsNode) {
        this.fPortsNode = portsNode;
    }

    public void setFocus() {
        this.fCurrentPortHyperlink.setFocus();
    }

    private Composite createComposite(Composite parent) {
        if (this.fToolkit != null) {
            return this.fToolkit.createComposite(parent);
        }
        return new Composite(parent, 0);
    }

    private Label createLabel(Composite parent, String text) {
        if (this.fToolkit != null) {
            return this.fToolkit.createLabel(parent, text);
        }
        Label label = new Label(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        return label;
    }

    public void dispose() {
        if (this.fMainComposite != null) {
            this.fMainComposite.dispose();
            this.fMainComposite = null;
        }
        if (this.fChangeSetLabelProvider != null) {
            this.fChangeSetLabelProvider.dispose();
            this.fChangeSetLabelProvider = null;
        }
    }
}

