/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.port;

import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class PortEditorInput
implements IEditorInput {
    private IWorkspaceConnection fWorkspace;
    private IComponent fComponent;

    public PortEditorInput(IWorkspaceConnection workspace, IComponent component) {
        Assert.isNotNull((Object)workspace);
        Assert.isNotNull((Object)component);
        this.fWorkspace = workspace;
        this.fComponent = component;
    }

    public IWorkspaceConnection getWorkspace() {
        return this.fWorkspace;
    }

    public IComponent getComponent() {
        return this.fComponent;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImagePool.PORT_EDITOR_ICON;
    }

    public String getName() {
        return Messages.PortEditorInput_EDITOR_INPUT_NAME;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fComponent == null ? 0 : this.fComponent.getItemId().hashCode());
        result = 31 * result + (this.fWorkspace == null ? 0 : this.fWorkspace.getResolvedWorkspace().getItemId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortEditorInput other = (PortEditorInput)obj;
        if (this.fComponent == null ? other.fComponent != null : !this.fComponent.sameItemId((IItemHandle)other.fComponent)) {
            return false;
        }
        return !(this.fWorkspace == null ? other.fWorkspace != null : !this.fWorkspace.equals((Object)other.fWorkspace));
    }
}

