/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.port;

import com.ibm.team.filesystem.ide.ui.internal.actions.port.ProcessPendingPortsAction;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditorInput;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.PortsCacheManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.CurrentPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortsNode;
import com.ibm.team.filesystem.ui.changes.views.LocalSynchronizeDecorator;
import com.ibm.team.filesystem.ui.views.TeamPlaceEditorInput;
import com.ibm.team.filesystem.ui.views.TeamPlacePart2;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.editors.port.PendingPortsPage;
import com.ibm.team.internal.filesystem.ui.editors.port.PortEditor;
import com.ibm.team.internal.filesystem.ui.labelproviders.PortLabelProvider;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetInput;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.rcp.ui.internal.viewers.AbstractSetWithListeners;
import com.ibm.team.repository.rcp.ui.internal.viewers.ISetWithListeners;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PortEditorHeaderPart
extends AbstractFormPart
implements IListener {
    private PortEditor fEditor;
    private IManagedForm fHeader;
    private IOperationRunner fOpRunner;
    private FormToolkit fToolkit;
    private Composite fMainComposite;
    private ISharedItemChangeListener fItemChangeListener;
    private IWorkspaceConnection fWorkspace;
    private String fWorkspaceName;
    private IComponent fComponent;
    private String fComponentName;
    private Link fPortLocationLink;
    private PortsNode fPortsNode;
    private Composite fCurrentPortComposite;
    private DecoratingLabelProvider fChangeSetLabelProvider;
    private Link fCurrentPortHyperlink;
    private Label fCurrentPortIcon;
    private Link fCurrentPortText;

    public PortEditorHeaderPart(PortEditor editor, IOperationRunner opRunner) {
        Assert.isNotNull((Object)((Object)editor));
        Assert.isNotNull((Object)opRunner);
        this.fEditor = editor;
        this.fHeader = editor.getHeaderForm();
        this.fWorkspace = editor.getPortEditorInput().getWorkspace();
        this.fComponent = editor.getPortEditorInput().getComponent();
        this.fOpRunner = opRunner;
        this.fToolkit = editor.getHeaderForm().getToolkit();
        Form form = this.fHeader.getForm().getForm();
        this.fMainComposite = this.fToolkit.createComposite(form.getHead());
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(10, 1, 0, 4).spacing(LayoutConstants.getSpacing()).applyTo(this.fMainComposite);
        this.fMainComposite.setBackground(null);
        this.fToolkit.paintBordersFor(this.fMainComposite);
        form.setHeadClient((Control)this.fMainComposite);
        this.createPortLocationWidgets(this.fMainComposite);
        this.createSpacer(this.fToolkit, this.fMainComposite);
        this.createCurrentPortWidgets(this.fMainComposite);
        this.addListeners();
        this.requestRefresh();
    }

    private void addListeners() {
        this.fItemChangeListener = new ISharedItemChangeListener(){

            public void itemsChanged(List events) {
                for (Object changeEvent : events) {
                    Display display;
                    if (!(changeEvent instanceof ISharedItemChangeEvent) || PortEditorHeaderPart.this.fMainComposite == null || PortEditorHeaderPart.this.fMainComposite.isDisposed() || (display = PortEditorHeaderPart.this.fMainComposite.getDisplay()) == null || display.isDisposed()) continue;
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PortEditorHeaderPart.this.requestRefresh();
                        }
                    });
                }
            }
        };
        this.fWorkspace.teamRepository().itemManager().addItemChangeListener((IItem)this.fWorkspace.getResolvedWorkspace(), this.fItemChangeListener);
        this.fWorkspace.teamRepository().itemManager().addItemChangeListener((IItem)this.fComponent, this.fItemChangeListener);
        PortsCacheManager.getInstance().addGenericListener((Object)"PORTS_CACHE_UPDATED", (IListener)this);
    }

    public void handleEvents(List events) {
        Display display;
        boolean portsUpdated = false;
        for (Object object : events) {
            IEvent event;
            if (!(object instanceof IEvent) || (event = (IEvent)object).getEventType() != "PORTS_CACHE_UPDATED") continue;
            portsUpdated = true;
            break;
        }
        if (portsUpdated && this.fMainComposite != null && !this.fMainComposite.isDisposed() && (display = this.fMainComposite.getDisplay()) != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    PortEditorHeaderPart.this.requestRefresh();
                }
            });
        }
    }

    public void requestRefresh() {
        PortsNode portNode = PortsCacheManager.getInstance().getPortNode(this.fWorkspace.teamRepository(), (IWorkspaceHandle)this.fWorkspace.getResolvedWorkspace(), (IComponentHandle)this.fComponent);
        if (portNode != null) {
            this.setPortsNode(portNode);
        } else {
            this.setPortsNode(null);
        }
        this.refreshPortLocationLabels();
        this.refreshCurrentPortLabels();
    }

    private void createPortLocationWidgets(Composite parent) {
        this.fWorkspaceName = this.fWorkspace.getName();
        this.fComponentName = this.fComponent.getName();
        this.fPortLocationLink = new Link(parent, 0);
        this.fPortLocationLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (PortEditorHeaderPart.this.fWorkspaceName.equals(event.text)) {
                    PortEditorHeaderPart.this.openWorkspaceEditor();
                }
                if (PortEditorHeaderPart.this.fComponentName.equals(event.text)) {
                    PortEditorHeaderPart.this.openComponentEditor();
                }
            }
        });
        this.fPortLocationLink.setText(this.getPortLocationLinkText());
        Color labelForeground = this.fToolkit.getColors().getColor("com.ibm.team.workitem.ide.ui.internal.editor.LABEL_FOREGROUND");
        if (labelForeground != null) {
            this.fPortLocationLink.setForeground(labelForeground);
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(3, 1).applyTo((Control)this.fPortLocationLink);
    }

    private void refreshPortLocationLabels() {
        this.fWorkspaceName = this.fWorkspace.getName();
        this.fComponentName = this.fComponent.getName();
        this.fPortLocationLink.setText(this.getPortLocationLinkText());
        this.fMainComposite.layout();
    }

    private String getPortLocationLinkText() {
        return NLS.bind((String)Messages.PortEditorHeaderPart_PORT_LOCATION_LINK_TEXT, (Object)this.fComponentName, (Object)this.fWorkspaceName);
    }

    private void openWorkspaceEditor() {
        TeamPlacePart2.open(this.fEditor.getEditorSite().getPage(), TeamPlaceEditorInput.newForEdit(AbstractPlaceWrapper.newWrapper(this.fWorkspace.getResolvedWorkspace())));
    }

    private void openComponentEditor() {
        ComponentEditor.open(this.fEditor.getEditorSite().getPage(), ComponentEditorInput.newForEdit(new ComponentWrapper(this.fWorkspace.teamRepository(), this.fComponent)));
    }

    private void createCurrentPortWidgets(Composite parent) {
        this.fCurrentPortHyperlink = new Link(parent, 0);
        this.fCurrentPortHyperlink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PortEditorHeaderPart.this.openCurrentPortInChangeExplorer();
            }
        });
        Color labelForeground = this.fToolkit.getColors().getColor("com.ibm.team.workitem.ide.ui.internal.editor.LABEL_FOREGROUND");
        if (labelForeground != null) {
            this.fCurrentPortHyperlink.setForeground(labelForeground);
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).applyTo((Control)this.fCurrentPortHyperlink);
        this.fCurrentPortComposite = new Composite(parent, 0);
        this.fCurrentPortComposite.setBackground(null);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).applyTo((Control)this.fCurrentPortComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(this.fCurrentPortComposite);
        this.fCurrentPortIcon = this.createLabel(this.fCurrentPortComposite, null);
        this.fCurrentPortIcon.setImage(null);
        this.fCurrentPortIcon.setBackground(null);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).indent(2, 0).applyTo((Control)this.fCurrentPortIcon);
        this.fCurrentPortText = new Link(this.fCurrentPortComposite, 0);
        this.fCurrentPortText.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (Messages.PortEditorHeaderPart_ACCEPT_HYPERLINK.equals(event.text)) {
                    PortEditorHeaderPart.this.doStartPorting();
                }
                if (PendingPortsPage.PAGE_NAME.equals(event.text)) {
                    PortEditorHeaderPart.this.openPendingPortsPage();
                }
            }
        });
        if (labelForeground != null) {
            this.fCurrentPortText.setForeground(labelForeground);
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).indent(-2, 0).applyTo((Control)this.fCurrentPortText);
        this.setNoCurrentPortText();
    }

    private void refreshCurrentPortLabels() {
        PortsNode portsNode = this.getPortsNode();
        if (portsNode != null && portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode() != null) {
            CurrentPortNode currentPortNode = portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode();
            this.fCurrentPortHyperlink.setText(Messages.PortEditorHeaderPart_CHANGE_SET_TO_MERGE_HYPERLINK);
            if (this.fChangeSetLabelProvider == null) {
                AbstractSetWithListeners<CurrentPortNode> set = new AbstractSetWithListeners<CurrentPortNode>(){

                    protected Collection<CurrentPortNode> computeElements() {
                        CurrentPortNode currentPortNode;
                        PortsNode portsNode = PortEditorHeaderPart.this.getPortsNode();
                        if (portsNode != null && (currentPortNode = portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode()) != null) {
                            return Collections.singletonList(currentPortNode);
                        }
                        return Collections.emptyList();
                    }
                };
                PortLabelProvider labelProvider = new PortLabelProvider((ISetWithListeners)set, this.fOpRunner);
                LocalSynchronizeDecorator labelDecorator = new LocalSynchronizeDecorator(true);
                this.fChangeSetLabelProvider = new DecoratingLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)labelDecorator);
                this.fChangeSetLabelProvider.addListener(new ILabelProviderListener(){

                    public void labelProviderChanged(LabelProviderChangedEvent event) {
                        CurrentPortNode currentPortNode;
                        PortsNode portsNode = PortEditorHeaderPart.this.getPortsNode();
                        if (portsNode != null && (currentPortNode = portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode()) != null && currentPortNode.equals(event.getElement())) {
                            boolean updated = false;
                            if (PortEditorHeaderPart.this.fCurrentPortIcon != null && !PortEditorHeaderPart.this.fCurrentPortIcon.isDisposed()) {
                                Image newImage = PortEditorHeaderPart.this.fChangeSetLabelProvider.getImage((Object)currentPortNode);
                                if (PortEditorHeaderPart.this.fCurrentPortIcon.getImage() == null || !PortEditorHeaderPart.this.fCurrentPortIcon.getImage().equals((Object)newImage)) {
                                    PortEditorHeaderPart.this.fCurrentPortIcon.setImage(PortEditorHeaderPart.this.fChangeSetLabelProvider.getImage((Object)currentPortNode));
                                    updated = true;
                                }
                            }
                            if (PortEditorHeaderPart.this.fCurrentPortText != null && !PortEditorHeaderPart.this.fCurrentPortText.isDisposed()) {
                                String newText = PortEditorHeaderPart.this.fChangeSetLabelProvider.getText((Object)currentPortNode);
                                if (!PortEditorHeaderPart.this.fCurrentPortText.getText().equals(newText)) {
                                    PortEditorHeaderPart.this.fCurrentPortText.setText(PortEditorHeaderPart.this.fChangeSetLabelProvider.getText((Object)currentPortNode));
                                    updated = true;
                                }
                            }
                            if (updated && PortEditorHeaderPart.this.fMainComposite != null && !PortEditorHeaderPart.this.fMainComposite.isDisposed()) {
                                PortEditorHeaderPart.this.fMainComposite.layout();
                            }
                        }
                    }
                });
            }
            this.fCurrentPortIcon.setImage(this.fChangeSetLabelProvider.getImage((Object)currentPortNode));
            this.fCurrentPortText.setText(this.fChangeSetLabelProvider.getText((Object)currentPortNode));
            this.fMainComposite.layout();
        } else {
            this.setNoCurrentPortText();
        }
    }

    private void setNoCurrentPortText() {
        this.fCurrentPortHyperlink.setText(Messages.PortEditorHeaderPart_CHANGE_SET_TO_MERGE_NO_HYPERLINK);
        this.fCurrentPortIcon.setImage(null);
        this.fCurrentPortText.setText(Messages.PortEditorHeaderPart_NO_CHANGE_SET);
        this.fMainComposite.layout();
    }

    private void openCurrentPortInChangeExplorer() {
        CurrentPortNode currentPortNode;
        PortsNode portsNode = this.getPortsNode();
        if (portsNode != null && (currentPortNode = portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode()) != null && currentPortNode.getPortSourceChangeSet() != null) {
            ChangesViewConverter.openChangeExplorer(this.fEditor.getEditorSite().getPage(), new ChangeSetInput(Arrays.asList(currentPortNode.getPortSourceChangeSet())));
        }
    }

    private void doStartPorting() {
        ProcessPendingPortsAction.processPendingPorts(this.fEditor.getEditorSite().getPart(), this.fOpRunner, this.fWorkspace, this.fComponent, false);
    }

    private void openPendingPortsPage() {
        this.fEditor.setActivePage("com.ibm.team.internal.filesystem.ui.editors.port.PendingPortsPage");
    }

    private synchronized PortsNode getPortsNode() {
        return this.fPortsNode;
    }

    private synchronized void setPortsNode(PortsNode portsNode) {
        this.fPortsNode = portsNode;
    }

    private Label createLabel(Composite parent, String text) {
        if (this.fToolkit != null) {
            return this.fToolkit.createLabel(parent, text);
        }
        return new Label(parent, 0);
    }

    private void createSpacer(FormToolkit toolkit, Composite parent) {
        Label spacerLabel = toolkit.createLabel(parent, null);
        spacerLabel.setBackground(null);
        GridDataFactory.fillDefaults().grab(false, false).span(3, 1).hint(-1, 1).applyTo((Control)spacerLabel);
    }

    public void setFocus() {
    }

    public void dispose() {
        if (this.fItemChangeListener != null) {
            this.fWorkspace.teamRepository().itemManager().removeItemChangeListener((IItem)this.fWorkspace.getResolvedWorkspace(), this.fItemChangeListener);
            this.fWorkspace.teamRepository().itemManager().removeItemChangeListener((IItem)this.fComponent, this.fItemChangeListener);
            this.fItemChangeListener = null;
        }
        PortsCacheManager.getInstance().removeGenericListener((Object)"PORTS_CACHE_UPDATED", (IListener)this);
        if (this.fMainComposite != null) {
            this.fMainComposite.dispose();
            this.fMainComposite = null;
        }
        if (this.fChangeSetLabelProvider != null) {
            this.fChangeSetLabelProvider.dispose();
            this.fChangeSetLabelProvider = null;
        }
        super.dispose();
    }
}

