/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.port;

import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.editors.port.PortEditor;
import com.ibm.team.internal.filesystem.ui.editors.port.PortEditorHeaderPart;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PortEditorHeader
extends AbstractFormPart {
    private PortEditor fEditor;
    private IOperationRunner fOpRunner;
    private LocalResourceManager fLocalResourceManager;
    private Action fRefreshAction;
    private PortEditorHeaderPart fCurrentPortPart;

    public PortEditorHeader(PortEditor editor, IOperationRunner opRunner) {
        this.fEditor = editor;
        this.fOpRunner = opRunner;
        this.fLocalResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fEditor.getHeaderForm().getForm().getForm().getHead());
        this.createEditorHeader();
    }

    public void createEditorHeader() {
        FormToolkit toolkit = this.fEditor.getHeaderForm().getToolkit();
        toolkit.decorateFormHeading(this.fEditor.getHeaderForm().getForm().getForm());
        this.updateTitle();
        this.fCurrentPortPart = new PortEditorHeaderPart(this.fEditor, this.fOpRunner);
        this.fEditor.getHeaderForm().addPart((IFormPart)this.fCurrentPortPart);
    }

    public String getTitleText() {
        return Messages.PortEditorHeader_HEADER_TITLE;
    }

    public ImageDescriptor getTitleImageDescriptor() {
        return ImagePool.PORT_EDITOR_ICON;
    }

    protected void updateTitle() {
        ImageDescriptor image;
        String title = this.getTitleText();
        if (title != null) {
            this.fEditor.getHeaderForm().getForm().setText(title);
        }
        if ((image = this.getTitleImageDescriptor()) != null) {
            this.fEditor.getHeaderForm().getForm().setImage(JazzResources.getImageWithDefault((ResourceManager)this.fLocalResourceManager, (ImageDescriptor)image));
        }
    }

    public void updateEnablement() {
        this.fRefreshAction.setEnabled(true);
    }

    public void setFocus() {
    }

    public void dispose() {
        this.fEditor = null;
        this.fLocalResourceManager = null;
        this.fRefreshAction = null;
        this.fCurrentPortPart = null;
        this.initialize(null);
        super.dispose();
    }
}

