/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.port;

import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.editor.FileSystemEditorToolkit;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortPage;
import com.ibm.team.internal.filesystem.ui.editors.port.PendingPortsPage;
import com.ibm.team.internal.filesystem.ui.editors.port.PortEditorInput;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.parts.PartSiteJobRunner;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.ui.editor.TeamFormEditor;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PortEditor
extends TeamFormEditor
implements IListener {
    public static final String ID = "com.ibm.team.filesystem.ide.ui.PortEditor";
    private PartSiteJobRunner fRunner;
    private ResourceManager fResources;
    private PortEditorInput fEditorInput;
    private CurrentPortPage fCurrentPortPage;
    private PendingPortsPage fPendingPortsPage;
    private ISharedItemChangeListener fItemListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            for (Object event : events) {
                ISharedItemChangeEvent changeEvent;
                if (!(event instanceof ISharedItemChangeEvent) || (changeEvent = (ISharedItemChangeEvent)event).getSharedItem().getItemType() != IWorkspace.ITEM_TYPE || PortEditor.this.fEditorInput == null) continue;
                IWorkspace workspace = PortEditor.this.fEditorInput.getWorkspace().getResolvedWorkspace();
                if (!changeEvent.getSharedItem().sameItemId((IItemHandle)workspace) || changeEvent.getBeforeState() == null || changeEvent.getAfterState() != null) continue;
                PortEditor.this.close(false);
                break;
            }
        }
    };

    public static void open(IWorkbenchPage page, PortEditorInput input) {
        PortEditor.open(page, input, null);
    }

    public static void open(IWorkbenchPage page, PortEditorInput input, String pageID) {
        try {
            IEditorPart editorPart = page.openEditor((IEditorInput)input, ID);
            if (("com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortPage".equals(pageID) || "com.ibm.team.internal.filesystem.ui.editors.port.PendingPortsPage".equals(pageID)) && editorPart != null && editorPart instanceof PortEditor) {
                PortEditor editor = (PortEditor)editorPart;
                editor.setActivePage(pageID);
            }
        }
        catch (PartInitException e) {
            StatusUtil.log(PortEditor.class, (Throwable)e);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.fEditorInput = (PortEditorInput)input;
        IWorkspaceConnection wc = this.fEditorInput.getWorkspace();
        wc.teamRepository().itemManager().addItemChangeListener(IWorkspace.ITEM_TYPE, this.fItemListener);
        wc.addGenericListener((Object)"components", (IListener)this);
    }

    protected FormToolkit createToolkit(Display display) {
        return new FileSystemEditorToolkit(UiPlugin.getDefault().getSharedFormColors(display));
    }

    protected void createHeaderContents(IManagedForm headerForm) {
    }

    protected Composite createPageContainer(final Composite parent) {
        final Display display = parent.getDisplay();
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.fRunner = new PartSiteJobRunner(this.getSite(), false){

            protected boolean reportProblem(final String opName, Operation op, final IStatus reason) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!parent.isDisposed()) {
                            IStatus adjustedReason = reason;
                            ErrorDialog.openError((Shell)PortEditor.this.getSite().getShell(), (String)NLS.bind((String)Messages.PortEditor_JOB_RUNNER_ERROR_MESSAGE, (Object)opName), null, (IStatus)adjustedReason);
                        }
                    }
                });
                return false;
            }
        };
        this.setPartName(this.getEditorName());
        this.setTitleImage(this.fResources.createImageWithDefault(ImagePool.PORT_EDITOR_ICON));
        return super.createPageContainer(parent);
    }

    protected void addPages() {
        try {
            this.fCurrentPortPage = new CurrentPortPage((FormEditor)this, this.fEditorInput, (IOperationRunner)this.fRunner);
            this.addPage((IFormPage)this.fCurrentPortPage);
            this.fPendingPortsPage = new PendingPortsPage((FormEditor)this, this.fEditorInput, (IOperationRunner)this.fRunner);
            this.addPage((IFormPage)this.fPendingPortsPage);
        }
        catch (PartInitException e) {
            StatusUtil.log((Object)((Object)this), (Throwable)e);
        }
    }

    public void setFocus() {
        super.setFocus();
        if (this.fCurrentPortPage != null) {
            this.fCurrentPortPage.setFocus();
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        this.fRunner = null;
        this.fResources = null;
        if (this.fEditorInput != null) {
            IWorkspaceConnection wc = this.fEditorInput.getWorkspace();
            wc.teamRepository().itemManager().removeItemChangeListener(IWorkspace.ITEM_TYPE, this.fItemListener);
            wc.removeGenericListener((Object)"components", (IListener)this);
        }
        this.fItemListener = null;
        this.fCurrentPortPage = null;
        this.fPendingPortsPage = null;
        super.dispose();
    }

    public void handleEvents(List events) {
        if (this.fEditorInput != null) {
            IWorkspaceConnection workspace = this.fEditorInput.getWorkspace();
            IComponent component = this.fEditorInput.getComponent();
            for (Object object : events) {
                Object affectedObject;
                IPropertyChangeEvent event;
                if (!(object instanceof IPropertyChangeEvent) || !"components".equals((event = (IPropertyChangeEvent)object).getProperty()) || !((affectedObject = event.getObject()) instanceof IWorkspaceConnection) || !workspace.equals((Object)((IWorkspaceConnection)affectedObject))) continue;
                Object oldValue = event.getOldValue();
                Object newValue = event.getNewValue();
                if (!(oldValue instanceof IComponentHandle) || !component.sameItemId((IItemHandle)((IComponentHandle)oldValue)) || newValue != null) continue;
                this.close(false);
                break;
            }
        }
    }

    public PortEditorInput getPortEditorInput() {
        return this.fEditorInput;
    }

    public String getEditorName() {
        if (this.fEditorInput == null) {
            return Messages.PortEditor_EDITOR_NAME_DEFAULT;
        }
        return NLS.bind((String)Messages.PortEditor_EDITOR_NAME, (Object)this.fEditorInput.getComponent().getName());
    }

    public CurrentPortPage getCurrentPortPage() {
        return this.fCurrentPortPage;
    }

    public PendingPortsPage getPendingPortsPage() {
        return this.fPendingPortsPage;
    }
}

