/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.port;

import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PendingPortNode;
import com.ibm.team.internal.filesystem.ui.editors.port.PendingPortsControl;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class PendingPortsTableDropTargetAdapter
extends DropTargetAdapter {
    private PendingPortsControl fPendingPortsControl;

    public PendingPortsTableDropTargetAdapter(PendingPortsControl pendingPortsControl) {
        Assert.isNotNull((Object)pendingPortsControl);
        this.fPendingPortsControl = pendingPortsControl;
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = 0;
        if (!LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            return;
        }
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        if (ss.size() > 0) {
            TableItem dropTargetTableItem;
            Object dropTargetNode;
            boolean allValid = true;
            PendingPortNode pendingPortDropNode = null;
            Widget dropTarget = event.item;
            if (dropTarget instanceof TableItem && (dropTargetNode = (dropTargetTableItem = (TableItem)dropTarget).getData()) instanceof PendingPortNode) {
                pendingPortDropNode = (PendingPortNode)dropTargetNode;
            }
            if (pendingPortDropNode == null) {
                allValid = false;
            } else {
                Object[] objectArray = ss.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (element instanceof PendingPortNode) {
                        PendingPortNode toMove = (PendingPortNode)element;
                        if (toMove.getPortSource().getSourceId().equals((Object)pendingPortDropNode.getPortSource().getSourceId())) {
                            allValid = false;
                            break;
                        }
                    } else {
                        allValid = false;
                        break;
                    }
                    ++n2;
                }
            }
            if (allValid) {
                event.detail = 2;
            }
        }
    }

    public void drop(DropTargetEvent event) {
        TableItem dropTargetTableItem;
        Object dropTargetNode;
        Widget dropTarget;
        if (!LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            return;
        }
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        ArrayList<PendingPortNode> toMove = new ArrayList<PendingPortNode>(ss.size());
        for (Object object : ss.toList()) {
            if (!(object instanceof PendingPortNode)) continue;
            toMove.add((PendingPortNode)object);
        }
        if (toMove.size() > 0 && (dropTarget = event.item) instanceof TableItem && (dropTargetNode = (dropTargetTableItem = (TableItem)dropTarget).getData()) instanceof PendingPortNode) {
            this.fPendingPortsControl.movePendingPorts(toMove, (PendingPortNode)dropTargetNode);
        }
    }
}

