/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.port;

import com.ibm.team.filesystem.rcp.core.internal.changes.ports.PortsCacheManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.editors.port.PendingPortsControl;
import com.ibm.team.internal.filesystem.ui.editors.port.PortEditorInput;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.ui.editor.TeamFormPage;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class PendingPortsPage
extends TeamFormPage
implements IListener {
    public static final String PAGE_ID = "com.ibm.team.internal.filesystem.ui.editors.port.PendingPortsPage";
    public static final String PAGE_NAME = Messages.PendingPortsPage_PENDING_PORTS_PAGE_NAME;
    private PortEditorInput fEditorInput;
    private IOperationRunner fOpRunner;
    private IManagedForm fManagedForm;
    private FormToolkit fToolkit;
    private Section fPendingPortsSection;
    private PendingPortsControl fPendingPortsControl;

    public PendingPortsPage(FormEditor editor, PortEditorInput editorInput, IOperationRunner runner) {
        super(editor, PAGE_ID, PAGE_NAME);
        this.fEditorInput = editorInput;
        this.fOpRunner = runner;
        this.addListeners();
    }

    private void addListeners() {
        PortsCacheManager.getInstance().addGenericListener((Object)"PORTS_CACHE_UPDATED", (IListener)this);
    }

    public void handleEvents(List events) {
        if (this.fManagedForm != null) {
            Display display;
            ScrolledForm form;
            boolean portsUpdated = false;
            for (Object object : events) {
                IEvent event;
                if (!(object instanceof IEvent) || (event = (IEvent)object).getEventType() != "PORTS_CACHE_UPDATED") continue;
                portsUpdated = true;
                break;
            }
            if (portsUpdated && (form = this.fManagedForm.getForm()) != null && !form.isDisposed() && (display = form.getDisplay()) != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PendingPortsPage.this.fPendingPortsControl != null) {
                            PendingPortsPage.this.fPendingPortsControl.requestRefresh();
                            PendingPortsPage.this.updatePortsSectionCollapsedText();
                        }
                    }
                });
            }
        }
    }

    private IOperationRunner getOperationRunner() {
        return this.fOpRunner;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.fManagedForm = managedForm;
        this.fToolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        Composite body = form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants2.getFormBodyMargins()).spacing(LayoutConstants2.getFormBodySpacing()).applyTo(body);
        this.createPortsSection(body);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fManagedForm.getForm(), "com.ibm.team.filesystem.ide.ui.editor_gap_mergequeuepage");
        }
    }

    private void createPortsSection(Composite parent) {
        int sectionStyle = 448;
        this.fPendingPortsSection = this.createSection(this.fToolkit, parent, sectionStyle, Messages.PendingPortsPage_PENDING_PORTS_SECTION_TITLE);
        this.fPendingPortsSection.setDescription(Messages.PendingPortsPage_PENDING_PORTS_SECTION_DESCRIPTION);
        Composite sectionBody = this.createComposite(this.fToolkit, (Composite)this.fPendingPortsSection, 0);
        this.fPendingPortsSection.setClient((Control)sectionBody);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(sectionBody);
        this.fPendingPortsControl = new PendingPortsControl(this.fToolkit, (IWorkbenchPartSite)this.getEditorSite(), sectionBody, this.fEditorInput.getWorkspace(), this.fEditorInput.getComponent(), this.getOperationRunner());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 600;
        this.fPendingPortsControl.getComposite().setLayoutData((Object)gridData);
        this.fPendingPortsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanging(ExpansionEvent e) {
                if (e.getState()) {
                    PendingPortsPage.this.fPendingPortsSection.setText(Messages.PendingPortsPage_PENDING_PORTS_SECTION_TITLE);
                    GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)PendingPortsPage.this.fPendingPortsSection);
                } else {
                    String statusLabel = PendingPortsPage.this.fPendingPortsControl.getStatusLabelText();
                    if (statusLabel == null || statusLabel.trim().length() == 0) {
                        PendingPortsPage.this.fPendingPortsSection.setText(Messages.PendingPortsPage_PENDING_PORTS_SECTION_TITLE);
                    } else {
                        PendingPortsPage.this.fPendingPortsSection.setText(NLS.bind((String)Messages.PendingPortsPage_PENDING_PORTS_SECTION_TITLE_COLLAPSED, (Object)statusLabel));
                    }
                    GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)PendingPortsPage.this.fPendingPortsSection);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.fPendingPortsSection);
        ToolBarManager toolbarManager = PendingPortsPage.createSectionHeader(this.fToolkit, (Composite)this.fPendingPortsSection);
        toolbarManager.add((IAction)new RefreshPortCacheAction());
        toolbarManager.update(true);
    }

    private void updatePortsSectionCollapsedText() {
        if (this.fPendingPortsSection != null && this.fPendingPortsControl != null && !this.fPendingPortsSection.isExpanded()) {
            String statusLabel = this.fPendingPortsControl.getStatusLabelText();
            if (statusLabel.trim().length() == 0) {
                this.fPendingPortsSection.setText(Messages.PendingPortsPage_PENDING_PORTS_SECTION_TITLE);
            } else {
                this.fPendingPortsSection.setText(NLS.bind((String)Messages.PendingPortsPage_PENDING_PORTS_SECTION_TITLE_COLLAPSED, (Object)statusLabel));
            }
            this.fPendingPortsSection.layout();
        }
    }

    public PendingPortsControl getPortsControl() {
        return this.fPendingPortsControl;
    }

    private Composite createComposite(FormToolkit toolkit, Composite parent, int style) {
        Composite composite = toolkit.createComposite(parent);
        return composite;
    }

    private Section createSection(FormToolkit toolkit, Composite parent, int style, String title) {
        Section section = toolkit.createSection(parent, style);
        section.setText(title);
        return section;
    }

    public static ToolBarManager createSectionHeader(FormToolkit toolkit, Composite parent) {
        Composite current = parent;
        while (current != null && !(current instanceof Section)) {
            current = current.getParent();
        }
        Section section = (Section)current;
        Composite textClientContainer = new Composite((Composite)section, 0);
        textClientContainer.setBackground(null);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        textClientContainer.setLayout((Layout)layout);
        Label filler = new Label(textClientContainer, 0);
        filler.setBackground(null);
        filler.setForeground(section.getTitleBarForeground());
        filler.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarManager.createControl(textClientContainer);
        GridData gridData = new GridData(131072, 128, false, false, 1, 1);
        toolBar.setLayoutData((Object)gridData);
        toolkit.adapt((Control)toolBar, false, false);
        toolBar.setBackground(null);
        section.setTextClient((Control)textClientContainer);
        return toolBarManager;
    }

    public void setFocus() {
        this.fPendingPortsControl.setInitialFocus();
    }

    public void dispose() {
        PortsCacheManager.getInstance().removeGenericListener((Object)"PORTS_CACHE_UPDATED", (IListener)this);
        if (this.fPendingPortsControl != null) {
            this.fPendingPortsControl.dispose();
        }
        this.initialize(null);
        super.dispose();
    }

    private class RefreshPortCacheAction
    extends Action {
        public RefreshPortCacheAction() {
            super(null, 1);
            this.setToolTipText(Messages.CurrentPortPage_REFRESH_ACTION_TOOLTIP);
            this.setImageDescriptor(ImagePool.REFRESH_ICON);
        }

        public void run() {
            if (ModelUtil.TRACE_PORT_CACHE_UPDATE) {
                ModelUtil.log((String)"\nPendingPortsPage#RefreshPortCacheAction#run : Refresh requested");
            }
            HashSet<PortsCacheManager.ComponentUpdateRequest> componentToRefresh = new HashSet<PortsCacheManager.ComponentUpdateRequest>(1);
            PortsCacheManager.ComponentUpdateRequest request = new PortsCacheManager.ComponentUpdateRequest(PendingPortsPage.this.fEditorInput.getWorkspace(), (IComponentHandle)PendingPortsPage.this.fEditorInput.getComponent(), false, true);
            request.refreshPendingPortItems();
            componentToRefresh.add(request);
            PortsCacheManager.getInstance().requestPortCacheComponentRefresh(componentToRefresh);
        }
    }
}

