/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.port;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.ProcessPendingPortsAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.RemovePendingPortAction;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.PortsCacheManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PendingPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortsNode;
import com.ibm.team.filesystem.ui.changes.views.LocalSynchronizeDecorator;
import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.editors.port.PendingPortsTableComparator;
import com.ibm.team.internal.filesystem.ui.editors.port.PendingPortsTableDragAdapter;
import com.ibm.team.internal.filesystem.ui.editors.port.PendingPortsTableDropTargetAdapter;
import com.ibm.team.internal.filesystem.ui.views.ce.ChangeSummaryView;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangeSetInput;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.internal.viewers.MenuManagerWithDefaultAdditions;
import com.ibm.team.repository.rcp.ui.openactions.IWorkbenchRunnable;
import com.ibm.team.repository.rcp.ui.openactions.OpenAction;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PendingPortsControl {
    private IWorkspaceConnection fWorkspace;
    private IComponent fComponent;
    private IOperationRunner fOpRunner;
    private IWorkbenchPartSite fParentPartSite;
    private FormToolkit fToolkit;
    private Composite fComposite;
    private PortsNode fPortsNode = null;
    public static final String PENDING_PORTS_CONTEXT_MENU_ID = "com.ibm.team.internal.filesystem.ui.editors.port.PendingPortsPage.PortsControl.PendingPorts";
    private final int PENDING_PORTS_TABLE_VIEWER_HEIGHT_HINT = 200;
    private TableViewer fTableViewer;
    private Button fStartPortingButton;
    private Button fRemoveButton;
    private Image fInfoImage;
    private Label fStatusLabel;

    public PendingPortsControl(FormToolkit toolkit, IWorkbenchPartSite parentPartSite, Composite parent, IWorkspaceConnection workspace, IComponent component, IOperationRunner operationRunner) {
        Assert.isNotNull((Object)parentPartSite);
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)workspace);
        Assert.isNotNull((Object)component);
        Assert.isNotNull((Object)operationRunner);
        this.fToolkit = toolkit;
        this.fParentPartSite = parentPartSite;
        this.fWorkspace = workspace;
        this.fComponent = component;
        this.fOpRunner = operationRunner;
        this.fComposite = this.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fComposite);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(this.fComposite);
        this.createPendingPortWidgets(this.fComposite);
        this.createStatusLabelWidgets(this.fComposite);
        this.requestRefresh();
    }

    public Composite getComposite() {
        return this.fComposite;
    }

    public void requestRefresh() {
        PortsNode portNode = PortsCacheManager.getInstance().getPortNode(this.fWorkspace.teamRepository(), (IWorkspaceHandle)this.fWorkspace.getResolvedWorkspace(), (IComponentHandle)this.fComponent);
        this.fPortsNode = portNode != null ? portNode : null;
        this.refreshTableViewer();
        this.refreshStatusLabel();
        this.updateEnablement();
    }

    public void setEnabled(boolean enabled) {
        if (this.fTableViewer != null && !this.fTableViewer.getTable().isDisposed()) {
            this.fTableViewer.getTable().setEnabled(enabled);
        }
        if (this.fStartPortingButton != null && !this.fStartPortingButton.isDisposed()) {
            this.fStartPortingButton.setEnabled(enabled);
        }
        if (this.fRemoveButton != null && !this.fRemoveButton.isDisposed()) {
            this.fRemoveButton.setEnabled(enabled);
        }
        if (enabled) {
            this.updateEnablement();
        }
    }

    public boolean setInitialFocus() {
        if (this.fStartPortingButton != null && !this.fStartPortingButton.isDisposed() && this.isStartPortingEnabled()) {
            return this.fStartPortingButton.setFocus();
        }
        if (this.fTableViewer != null && !this.fTableViewer.getTable().isDisposed()) {
            return this.fTableViewer.getTable().setFocus();
        }
        return false;
    }

    public String getStatusLabelText() {
        String statusText = "";
        long numPendingPorts = 0L;
        if (this.fPortsNode != null) {
            numPendingPorts = this.fPortsNode.getChildPendingPortsContainerNode().getChildPendingPorts().size();
        }
        if (numPendingPorts == 0L) {
            statusText = NLS.bind((String)Messages.PendingPortsControl_STATUS_TEXT_MANY_PENDING_CHANGE_SETS, (Object)numPendingPorts);
        } else if (numPendingPorts == 1L) {
            statusText = Messages.PendingPortsControl_STATUS_TEXT_1_PENDING_CHANGE_SET;
        } else if (numPendingPorts > 0L) {
            statusText = NLS.bind((String)Messages.PendingPortsControl_STATUS_TEXT_MANY_PENDING_CHANGE_SETS, (Object)numPendingPorts);
            try {
                long totalNumPendingPorts = this.fPortsNode.getWorkspaceConnection().getAcceptQueueSize((IComponentHandle)this.fPortsNode.getComponent());
                if (totalNumPendingPorts > numPendingPorts) {
                    statusText = NLS.bind((String)Messages.PendingPortsControl_STATUS_TEXT_X_OUT_OF_Y_PENDING_CHANGE_SETS, (Object)numPendingPorts, (Object)totalNumPendingPorts);
                }
            }
            catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
                // empty catch block
            }
        }
        return statusText;
    }

    public void movePendingPorts(final List<PendingPortNode> portsToReorder, final PendingPortNode afterPendingPort) {
        if (MessageDialog.openQuestion((Shell)this.fParentPartSite.getShell(), (String)Messages.PendingPortsControl_REORDER_DIALOG_TITLE, (String)Messages.PendingPortsControl_REORDER_DIALOG_MESSAGE)) {
            this.fOpRunner.enqueue(Messages.PendingPortsControl_REORDERING_PENDING_CHANGE_SETS_JOB_NAME, (Operation)new RepositoryOperation(this.fWorkspace.teamRepository()){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemException, OperationFailedException {
                    UUID[] portsByUUIDToReorder = new UUID[portsToReorder.size()];
                    int i = 0;
                    while (i < portsToReorder.size()) {
                        portsByUUIDToReorder[i] = ((PendingPortNode)portsToReorder.get(i)).getPortSource().getSourceId();
                        ++i;
                    }
                    PendingPortsControl.this.fWorkspace.reorderAcceptQueueEntries((IComponentHandle)PendingPortsControl.this.fComponent, portsByUUIDToReorder, afterPendingPort.getPortSource().getSourceId(), monitor);
                }
            });
        }
    }

    public void dispose() {
        if (this.fInfoImage != null) {
            this.fInfoImage.dispose();
            this.fInfoImage = null;
        }
        if (this.fComposite != null) {
            this.fComposite.dispose();
            this.fComposite = null;
        }
    }

    private void createPendingPortWidgets(Composite parent) {
        Composite tableComposite = this.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        GridLayoutFactory.fillDefaults().applyTo(tableComposite);
        Table table = this.createTable(tableComposite, 2818);
        table.setHeaderVisible(false);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(-1, 200).applyTo((Control)table);
        this.fTableViewer = new TableViewer(table);
        StandardLabelProvider labelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        LocalSynchronizeDecorator labelDecorator = new LocalSynchronizeDecorator(true);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)labelDecorator));
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setComparator((ViewerComparator)new PendingPortsTableComparator());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PendingPortsControl.this.updateEnablement();
            }
        });
        this.fTableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection structuredSelection;
                List elements;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (elements = (structuredSelection = (IStructuredSelection)selection).toList()) != null && elements.size() > 0) {
                    PendingPortsControl.this.handleOpenTableElements(elements);
                }
            }
        });
        this.fTableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    PendingPortsControl.this.doRemove();
                }
            }
        });
        this.addViewerContextMenu((StructuredViewer)this.fTableViewer, PENDING_PORTS_CONTEXT_MENU_ID);
        this.addTableDragSupport(this.fTableViewer);
        this.addTableDropSupport(this.fTableViewer);
        this.addTooltipSupport((StructuredViewer)this.fTableViewer);
        Composite buttonBar = this.createComposite(parent);
        GridDataFactory.fillDefaults().align(0x1000008, 4).grab(false, true).span(1, 1).applyTo((Control)buttonBar);
        GridLayoutFactory.swtDefaults().numColumns(1).equalWidth(false).applyTo(buttonBar);
        this.fStartPortingButton = this.createPushButton(buttonBar, Messages.PendingPortsControl_START_PORTING_BUTTON_LABEL, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PendingPortsControl.this.doStartPorting();
            }
        });
        this.fStartPortingButton.setEnabled(false);
        this.fRemoveButton = this.createPushButton(buttonBar, Messages.PendingPortsControl_REMOVE_BUTTON_LABEL, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PendingPortsControl.this.doRemove();
            }
        });
        this.fRemoveButton.setEnabled(false);
    }

    private void refreshTableViewer() {
        if (this.fTableViewer.getControl() != null && !this.fTableViewer.getControl().isDisposed()) {
            this.fTableViewer.getControl().setRedraw(false);
            if (this.fPortsNode != null && this.fPortsNode.getChildPendingPortsContainerNode().getChildPendingPorts().size() > 0) {
                this.fTableViewer.setInput((Object)this.fPortsNode.getChildPendingPortsContainerNode().getChildPendingPorts());
            } else {
                this.fTableViewer.setInput((Object)new Object[]{Messages.PendingPortsControl_NO_PENDING_CHANGE_SETS_NODE});
            }
            this.fTableViewer.getControl().setRedraw(true);
            IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
            if (!selection.isEmpty()) {
                this.fTableViewer.reveal(selection.getFirstElement());
            }
        }
    }

    private void addViewerContextMenu(StructuredViewer viewer, String menuID) {
        MenuManagerWithDefaultAdditions menuManager = new MenuManagerWithDefaultAdditions();
        ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)menuManager);
        viewer.getControl().setMenu(menuManager.createContextMenu(viewer.getControl()));
        this.fParentPartSite.registerContextMenu(menuID, (MenuManager)menuManager, (ISelectionProvider)viewer);
    }

    private void addTableDragSupport(TableViewer viewer) {
        viewer.addDragSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new PendingPortsTableDragAdapter(viewer));
    }

    private void addTableDropSupport(TableViewer viewer) {
        viewer.addDropSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new PendingPortsTableDropTargetAdapter(this));
    }

    private void addTooltipSupport(StructuredViewer viewer) {
        new TooltipSupport(viewer.getControl(), true, true){

            public Object doResolve(Object element) {
                if (DomainAdapterUtils.getDomainAdapter((Object)element) == null) {
                    if (element instanceof IModelAccessor) {
                        return ((IModelAccessor)element).getModelInstance();
                    }
                    return null;
                }
                return super.doResolve(element);
            }

            protected void hoverToolTipOpened() {
            }

            protected void openRequested(Object element) {
            }
        };
    }

    private void handleOpenTableElements(List elements) {
        ArrayList<IChangeSet> changeSets = new ArrayList<IChangeSet>();
        for (Object element : elements) {
            IWorkbenchRunnable genericOpenAction = OpenAction.getActionFor(element);
            if (genericOpenAction != null) {
                genericOpenAction.run(this.fParentPartSite.getShell(), this.fParentPartSite.getPage(), (IStructuredSelection)new StructuredSelection(element));
                continue;
            }
            if (!(element instanceof PendingPortNode)) continue;
            PendingPortNode pendingPortNode = (PendingPortNode)element;
            IChangeSet changeSet = pendingPortNode.getSourceChangeSet();
            changeSets.add(changeSet);
        }
        this.openChangeSetsInChangeSummary(changeSets);
    }

    private void openChangeSetsInChangeSummary(List<IChangeSet> changeSets) {
        if (changeSets.size() > 0) {
            ChangeSummaryView.open(new ChangeSetInput(changeSets).getOutgoing(), changeSets);
        }
    }

    private void createStatusLabelWidgets(Composite parent) {
        Composite statusLabelComposite = this.createComposite(parent);
        statusLabelComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        statusLabelComposite.setLayout((Layout)new GridLayout(2, false));
        Label infoIcon = new Label(statusLabelComposite, 0);
        this.fInfoImage = ImagePool.INFO_OBJ.createImage();
        infoIcon.setImage(this.fInfoImage);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).indent(-7, 0).applyTo((Control)infoIcon);
        this.fStatusLabel = this.createLabel(statusLabelComposite, this.getStatusLabelText());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).indent(-2, 0).applyTo((Control)this.fStatusLabel);
    }

    private void refreshStatusLabel() {
        if (this.fStatusLabel != null && !this.fStatusLabel.isDisposed()) {
            this.fStatusLabel.setText(this.getStatusLabelText());
        }
    }

    private void doStartPorting() {
        if (this.isStartPortingEnabled()) {
            ProcessPendingPortsAction.processPendingPorts(this.fParentPartSite.getPart(), this.fOpRunner, this.fWorkspace, this.fComponent, false);
        }
    }

    private boolean isStartPortingEnabled() {
        boolean isEnabled = false;
        if (this.fPortsNode != null && this.fPortsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode() == null && this.fPortsNode.getChildPendingPortsContainerNode().getChildPendingPorts().size() > 0) {
            isEnabled = true;
        }
        return isEnabled;
    }

    private void doRemove() {
        if (this.isValidSelectionForRemove()) {
            RemovePendingPortAction.removePendingPorts((ISelection)this.getPendingPortsTableSelection(), this.fParentPartSite.getPart(), this.fOpRunner);
        }
    }

    private boolean isValidSelectionForRemove() {
        return RemovePendingPortAction.isValidSelection((ISelection)this.getPendingPortsTableSelection());
    }

    private IStructuredSelection getPendingPortsTableSelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    private void updateEnablement() {
        if (this.fTableViewer != null && !this.fTableViewer.getTable().isDisposed()) {
            this.fTableViewer.getTable().setEnabled(true);
        }
        if (this.fStartPortingButton != null && !this.fStartPortingButton.isDisposed()) {
            this.fStartPortingButton.setEnabled(this.isStartPortingEnabled());
        }
        if (this.fRemoveButton != null && !this.fRemoveButton.isDisposed()) {
            this.fRemoveButton.setEnabled(this.isValidSelectionForRemove());
        }
    }

    private Composite createComposite(Composite parent) {
        if (this.fToolkit != null) {
            return this.fToolkit.createComposite(parent);
        }
        return new Composite(parent, 0);
    }

    private Label createLabel(Composite parent, String text) {
        if (this.fToolkit != null) {
            return this.fToolkit.createLabel(parent, text);
        }
        return new Label(parent, 0);
    }

    private Table createTable(Composite parent, int style) {
        if (this.fToolkit != null) {
            return this.fToolkit.createTable(parent, style);
        }
        return new Table(parent, style);
    }

    private Button createPushButton(Composite parent, String text, SelectionListener listener) {
        return this.createButton(parent, text, listener, 8);
    }

    private Button createButton(Composite parent, String text, SelectionListener listener, int style) {
        Button button;
        if (this.fToolkit != null) {
            button = this.fToolkit.createButton(parent, text, style);
        } else {
            button = new Button(parent, 8);
            button.setText(text);
        }
        button.addSelectionListener(listener);
        int minX = Math.max(button.computeSize((int)-1, (int)-1, (boolean)true).x, LayoutConstants.getMinButtonSize().x);
        GridDataFactory.fillDefaults().align(4, 128).hint(minX, -1).applyTo((Control)button);
        return button;
    }
}

