/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.port;

import com.ibm.team.filesystem.ide.ui.internal.actions.port.ProcessPendingPortsAction;
import com.ibm.team.filesystem.rcp.core.internal.changes.locks.UserLockCache;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.PortsCacheManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.CurrentPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortsNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ModelUtil;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortDetailsControl;
import com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortDetailsFilterActionGroup;
import com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortOutputControl;
import com.ibm.team.internal.filesystem.ui.editors.port.PendingPortsPage;
import com.ibm.team.internal.filesystem.ui.editors.port.PortEditorInput;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.utils.LayoutConstants2;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.ui.editor.TeamFormPage;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class CurrentPortPage
extends TeamFormPage
implements IListener {
    public static final String PAGE_ID = "com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortPage";
    public static final String PAGE_NAME = Messages.CurrentPortPage_CURRENT_PORT_PAGE_NAME;
    private PortEditorInput fEditorInput;
    private IOperationRunner fOpRunner;
    private IManagedForm fManagedForm;
    private FormToolkit fToolkit;
    private Composite fPageBody;
    private Composite fNoCurrentPortComposite;
    private Link fNoCurrentPortLink;
    private Composite fCurrentPortComposite;
    private Section fCurrentPortDetailsSection;
    private CurrentPortDetailsControl fCurrentPortDetailsControl;
    private CurrentPortDetailsFilterActionGroup fCurrentPortDetailsFilterActionGroup;
    private Section fCurrentPortOutputSection;
    private CurrentPortOutputControl fCurrentPortOutputControl;

    public CurrentPortPage(FormEditor editor, PortEditorInput editorInput, IOperationRunner runner) {
        super(editor, PAGE_ID, PAGE_NAME);
        this.fEditorInput = editorInput;
        this.fOpRunner = runner;
        this.addListeners();
    }

    private void addListeners() {
        PortsCacheManager.getInstance().addGenericListener((Object)"PORTS_CACHE_UPDATED", (IListener)this);
        ComponentSyncModel.getInstance().addGenericListener((Object)"refreshedUnresolvedCompleted", (IListener)this);
        ComponentSyncModel.getInstance().addGenericListener((Object)"refreshedRemoteCompleted", (IListener)this);
        ComponentSyncModel.getInstance().getUpdateManager().addGenericListener((Object)"Update Status Completed", (IListener)this);
        UserLockCache.get().addGenericListener((Object)"lock", (IListener)this);
    }

    private void removeListeners() {
        PortsCacheManager.getInstance().removeGenericListener((Object)"PORTS_CACHE_UPDATED", (IListener)this);
        ComponentSyncModel.getInstance().removeGenericListener((Object)"refreshedUnresolvedCompleted", (IListener)this);
        ComponentSyncModel.getInstance().removeGenericListener((Object)"refreshedRemoteCompleted", (IListener)this);
        ComponentSyncModel.getInstance().getUpdateManager().removeGenericListener((Object)"Update Status Completed", (IListener)this);
        UserLockCache.get().removeGenericListener((Object)"lock", (IListener)this);
    }

    public void handleEvents(List events) {
        if (this.fManagedForm != null) {
            Display display;
            ScrolledForm form;
            boolean refreshCurrentPortOutputControl;
            boolean portsUpdated = false;
            boolean pcViewRefreshedUnresolved = false;
            boolean pcViewRefreshedRemote = false;
            boolean pcViewUpdateStatusCompleted = false;
            boolean locksUpdated = false;
            for (Object object : events) {
                if (!(object instanceof IEvent)) continue;
                IEvent event = (IEvent)object;
                if (event.getEventType() == "PORTS_CACHE_UPDATED") {
                    portsUpdated = true;
                }
                if (event.getEventType() == "refreshedUnresolvedCompleted") {
                    pcViewRefreshedUnresolved = true;
                }
                if (event.getEventType() == "refreshedRemoteCompleted") {
                    pcViewRefreshedRemote = true;
                }
                if (event.getEventType() == "Update Status Completed") {
                    pcViewUpdateStatusCompleted = true;
                }
                if (event.getEventType() != "lock") continue;
                locksUpdated = true;
            }
            final boolean refreshCurrentPortDetailsControl = portsUpdated || pcViewRefreshedUnresolved || pcViewUpdateStatusCompleted || locksUpdated;
            boolean bl = refreshCurrentPortOutputControl = portsUpdated || pcViewRefreshedRemote || pcViewUpdateStatusCompleted || locksUpdated;
            if ((refreshCurrentPortDetailsControl || refreshCurrentPortOutputControl) && (form = this.fManagedForm.getForm()) != null && !form.isDisposed() && (display = form.getDisplay()) != null && !display.isDisposed()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CurrentPortPage.this.refreshPage(refreshCurrentPortDetailsControl, refreshCurrentPortOutputControl);
                    }
                });
            }
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.fManagedForm = managedForm;
        this.fToolkit = managedForm.getToolkit();
        this.fPageBody = managedForm.getForm().getBody();
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(LayoutConstants2.getFormBodyMargins()).spacing(LayoutConstants2.getFormBodySpacing()).applyTo(this.fPageBody);
        this.fCurrentPortDetailsFilterActionGroup = new CurrentPortDetailsFilterActionGroup();
        this.refreshPage(true, true);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fManagedForm.getForm(), "com.ibm.team.filesystem.ide.ui.editor_gap_currentmergepage");
        }
    }

    private void refreshPage(boolean refreshCurrentPortDetailsControl, boolean refreshCurrentPortOutputControl) {
        if (!this.fPageBody.isDisposed()) {
            boolean showNoCurrentPortWidgets = false;
            boolean hasCurrentPort = PortsCacheManager.getInstance().hasCurrentPort(this.fEditorInput.getWorkspace().teamRepository(), (IWorkspaceHandle)this.fEditorInput.getWorkspace().getResolvedWorkspace(), (IComponentHandle)this.fEditorInput.getComponent());
            if (showNoCurrentPortWidgets && !hasCurrentPort) {
                this.removeCurrentPortWidgets();
                this.createNoCurrentPortWidgets(this.fPageBody);
            } else {
                this.removeNoCurrentPortWidgets();
                this.createCurrentPortWidgets(this.fPageBody);
                if (this.fCurrentPortDetailsSection != null) {
                    this.fCurrentPortDetailsSection.setDescription(this.getCurrentPortDetailsSectionDescription());
                }
                if (refreshCurrentPortDetailsControl && this.fCurrentPortDetailsControl != null) {
                    this.fCurrentPortDetailsControl.requestRefresh();
                    this.updateCurrentPortDetailsSectionCollapsedText();
                }
                if (refreshCurrentPortOutputControl && this.fCurrentPortOutputControl != null) {
                    this.fCurrentPortOutputControl.requestRefresh();
                    this.updateCurrentPortOutputSectionCollapsedText();
                }
            }
        }
    }

    private void removeNoCurrentPortWidgets() {
        if (this.fNoCurrentPortComposite != null) {
            this.fNoCurrentPortComposite.dispose();
            this.fNoCurrentPortComposite = null;
        }
        if (this.fNoCurrentPortLink != null) {
            this.fNoCurrentPortLink.dispose();
            this.fNoCurrentPortLink = null;
        }
    }

    private void createNoCurrentPortWidgets(Composite parent) {
        if (this.fNoCurrentPortComposite == null) {
            this.fNoCurrentPortComposite = this.createComposite(this.fToolkit, parent, 0);
            GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.fNoCurrentPortComposite);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.fNoCurrentPortComposite);
            this.fNoCurrentPortLink = new Link(this.fNoCurrentPortComposite, 0);
            final String acceptHyperlink = Messages.CurrentPortPage_ACCEPT_HYPERLINK;
            final String pendingPortsPageHyperlink = PendingPortsPage.PAGE_NAME;
            this.fNoCurrentPortLink.setText(NLS.bind((String)Messages.CurrentPortPage_NO_CURRENT_PORT_MESSAGE, (Object)acceptHyperlink, (Object)pendingPortsPageHyperlink));
            this.fNoCurrentPortLink.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (acceptHyperlink.equals(event.text)) {
                        CurrentPortPage.this.doStartPorting();
                    }
                    if (pendingPortsPageHyperlink.equals(event.text)) {
                        CurrentPortPage.this.openPendingPortsPage();
                    }
                }
            });
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).applyTo((Control)this.fNoCurrentPortLink);
            this.fNoCurrentPortLink.setBackground(this.fNoCurrentPortComposite.getBackground());
            parent.layout();
        }
    }

    private void doStartPorting() {
        ProcessPendingPortsAction.processPendingPorts(this.getEditorSite().getPart(), this.fOpRunner, this.fEditorInput.getWorkspace(), this.fEditorInput.getComponent(), false);
    }

    private void openPendingPortsPage() {
        this.getEditor().setActivePage("com.ibm.team.internal.filesystem.ui.editors.port.PendingPortsPage");
    }

    private void removeCurrentPortWidgets() {
        if (this.fCurrentPortComposite != null) {
            this.fCurrentPortComposite.dispose();
            this.fCurrentPortComposite = null;
        }
        if (this.fCurrentPortDetailsSection != null) {
            this.fCurrentPortDetailsSection.dispose();
            this.fCurrentPortDetailsSection = null;
        }
        if (this.fCurrentPortDetailsControl != null) {
            this.fCurrentPortDetailsControl.dispose();
            this.fCurrentPortDetailsControl = null;
        }
        if (this.fCurrentPortDetailsFilterActionGroup != null) {
            this.fCurrentPortDetailsFilterActionGroup.dispose();
            this.fCurrentPortDetailsFilterActionGroup = null;
        }
        if (this.fCurrentPortOutputSection != null) {
            this.fCurrentPortOutputSection.dispose();
            this.fCurrentPortOutputSection = null;
        }
        if (this.fCurrentPortOutputControl != null) {
            this.fCurrentPortOutputControl.dispose();
            this.fCurrentPortOutputControl = null;
        }
    }

    private void createCurrentPortWidgets(Composite parent) {
        if (this.fCurrentPortComposite == null) {
            this.fCurrentPortComposite = this.createComposite(this.fToolkit, parent, 0);
            GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.fCurrentPortComposite);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.fCurrentPortComposite);
            this.createCurrentPortDetailsSection(this.fCurrentPortComposite);
            this.createCurrentPortOutputSection(this.fCurrentPortComposite);
            parent.layout();
        }
    }

    private boolean createCurrentPortDetailsSection(Composite parent) {
        boolean widgetsCreated = false;
        if (this.fCurrentPortDetailsSection == null) {
            int sectionStyle = 450;
            this.fCurrentPortDetailsSection = this.createSection(this.fToolkit, parent, sectionStyle, Messages.CurrentPortPage_CURRENT_PORT_DETAILS_SECTION_TITLE);
            this.fCurrentPortDetailsSection.setDescription(this.getCurrentPortDetailsSectionDescription());
            Composite sectionBody = this.createComposite(this.fToolkit, (Composite)this.fCurrentPortDetailsSection, 0);
            this.fCurrentPortDetailsSection.setClient((Control)sectionBody);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(sectionBody);
            this.fCurrentPortDetailsControl = new CurrentPortDetailsControl(this.fToolkit, (IWorkbenchPartSite)this.getEditorSite(), sectionBody, this.fEditorInput.getWorkspace(), this.fEditorInput.getComponent(), this.fOpRunner);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.widthHint = 600;
            this.fCurrentPortDetailsControl.getComposite().setLayoutData((Object)gridData);
            this.fCurrentPortDetailsSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanging(ExpansionEvent e) {
                    if (e.getState()) {
                        CurrentPortPage.this.fCurrentPortDetailsSection.setText(Messages.CurrentPortPage_CURRENT_PORT_DETAILS_SECTION_TITLE);
                        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)CurrentPortPage.this.fCurrentPortDetailsSection);
                    } else {
                        String statusLabel = CurrentPortPage.this.fCurrentPortDetailsControl.getStatusLabelText();
                        if (statusLabel == null || statusLabel.trim().length() == 0) {
                            CurrentPortPage.this.fCurrentPortDetailsSection.setText(Messages.CurrentPortPage_CURRENT_PORT_DETAILS_SECTION_TITLE);
                        } else {
                            CurrentPortPage.this.fCurrentPortDetailsSection.setText(NLS.bind((String)Messages.CurrentPortPage_CURRENT_PORT_DETAILS_SECTION_TITLE_COLLAPSED, (Object)statusLabel));
                        }
                        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)CurrentPortPage.this.fCurrentPortDetailsSection);
                    }
                }
            });
            GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.fCurrentPortDetailsSection);
            ToolBarManager toolbarManager = this.createSectionHeader(this.fToolkit, (Composite)this.fCurrentPortDetailsSection);
            toolbarManager.add((IAction)new RefreshPortCacheAction());
            toolbarManager.add((IContributionItem)new Separator());
            toolbarManager.add((IAction)new FilterDropDownAction());
            toolbarManager.update(true);
            parent.layout();
            widgetsCreated = true;
        }
        return widgetsCreated;
    }

    private String getCurrentPortDetailsSectionDescription() {
        CurrentPortNode currentPortNode;
        String description = Messages.CurrentPortPage_CURRENT_PORT_DETAILS_SECTION_DESCRIPTION;
        PortsNode root = PortsCacheManager.getInstance().getPortNode(this.fEditorInput.getWorkspace().teamRepository(), (IWorkspaceHandle)this.fEditorInput.getWorkspace().getResolvedWorkspace(), (IComponentHandle)this.fEditorInput.getComponent());
        if (root != null && (currentPortNode = root.getChildCurrentPortContainerNode().getChildCurrentPortNode()) != null && currentPortNode.getPortSourceChangeSet() == null) {
            description = Messages.CurrentPortPage_CURRENT_PORT_DETAILS_SECTION_DESCRIPTION_NO_SOURCE_CHANGE_SET;
        }
        return description;
    }

    private void updateCurrentPortDetailsSectionCollapsedText() {
        if (this.fCurrentPortDetailsSection != null && this.fCurrentPortDetailsControl != null && !this.fCurrentPortDetailsSection.isExpanded()) {
            String statusLabel = this.fCurrentPortDetailsControl.getStatusLabelText();
            if (statusLabel.trim().length() == 0) {
                this.fCurrentPortDetailsSection.setText(Messages.CurrentPortPage_CURRENT_PORT_DETAILS_SECTION_TITLE);
            } else {
                this.fCurrentPortDetailsSection.setText(NLS.bind((String)Messages.CurrentPortPage_CURRENT_PORT_DETAILS_SECTION_TITLE_COLLAPSED, (Object)statusLabel));
            }
            this.fCurrentPortDetailsSection.layout();
        }
    }

    public CurrentPortDetailsControl getCurrentPortDetailsControl() {
        return this.fCurrentPortDetailsControl;
    }

    private boolean createCurrentPortOutputSection(Composite parent) {
        boolean widgetsCreated = false;
        if (this.fCurrentPortOutputSection == null) {
            int sectionStyle = 450;
            this.fCurrentPortOutputSection = this.createSection(this.fToolkit, parent, sectionStyle, Messages.CurrentPortPage_CURRENT_PORT_OUTPUT_SECTION_TITLE);
            this.fCurrentPortOutputSection.setDescription(Messages.CurrentPortPage_CURRENT_PORT_OUTPUT_SECTION_DESCRIPTION);
            Composite sectionBody = this.createComposite(this.fToolkit, (Composite)this.fCurrentPortOutputSection, 0);
            this.fCurrentPortOutputSection.setClient((Control)sectionBody);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(sectionBody);
            this.fCurrentPortOutputControl = new CurrentPortOutputControl(this.fToolkit, (IWorkbenchPartSite)this.getEditorSite(), this.getEditorSite().getActionBars(), sectionBody, this.fEditorInput.getWorkspace(), this.fEditorInput.getComponent(), this.fOpRunner);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.widthHint = 600;
            this.fCurrentPortOutputControl.getComposite().setLayoutData((Object)gridData);
            this.fCurrentPortOutputSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanging(ExpansionEvent e) {
                    if (e.getState()) {
                        CurrentPortPage.this.fCurrentPortOutputSection.setText(Messages.CurrentPortPage_CURRENT_PORT_OUTPUT_SECTION_TITLE);
                        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)CurrentPortPage.this.fCurrentPortOutputSection);
                    } else {
                        String statusLabel = CurrentPortPage.this.fCurrentPortOutputControl.getStatusLabelText();
                        if (statusLabel == null || statusLabel.trim().length() == 0) {
                            CurrentPortPage.this.fCurrentPortOutputSection.setText(Messages.CurrentPortPage_CURRENT_PORT_OUTPUT_SECTION_TITLE);
                        } else {
                            CurrentPortPage.this.fCurrentPortOutputSection.setText(NLS.bind((String)Messages.CurrentPortPage_CURRENT_PORT_OUTPUT_SECTION_TITLE_COLLAPSED, (Object)statusLabel));
                        }
                        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)CurrentPortPage.this.fCurrentPortOutputSection);
                    }
                }
            });
            GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.fCurrentPortOutputSection);
            ToolBarManager toolbarManager = this.createSectionHeader(this.fToolkit, (Composite)this.fCurrentPortOutputSection);
            toolbarManager.update(true);
            parent.layout();
            widgetsCreated = true;
        }
        return widgetsCreated;
    }

    private void updateCurrentPortOutputSectionCollapsedText() {
        if (this.fCurrentPortOutputSection != null && this.fCurrentPortOutputControl != null && !this.fCurrentPortOutputSection.isExpanded()) {
            String statusLabel = this.fCurrentPortOutputControl.getStatusLabelText();
            if (statusLabel.trim().length() == 0) {
                this.fCurrentPortOutputSection.setText(Messages.CurrentPortPage_CURRENT_PORT_OUTPUT_SECTION_TITLE);
            } else {
                this.fCurrentPortOutputSection.setText(NLS.bind((String)Messages.CurrentPortPage_CURRENT_PORT_OUTPUT_SECTION_TITLE_COLLAPSED, (Object)statusLabel));
            }
            this.fCurrentPortOutputSection.layout();
        }
    }

    public CurrentPortOutputControl getCurrentPortOutputControl() {
        return this.fCurrentPortOutputControl;
    }

    private Composite createComposite(FormToolkit toolkit, Composite parent, int style) {
        Composite composite = toolkit.createComposite(parent);
        return composite;
    }

    private Section createSection(FormToolkit toolkit, Composite parent, int style, String title) {
        Section section = toolkit.createSection(parent, style);
        section.setText(title);
        return section;
    }

    private ToolBarManager createSectionHeader(FormToolkit toolkit, Composite parent) {
        Composite current = parent;
        while (current != null && !(current instanceof Section)) {
            current = current.getParent();
        }
        Section section = (Section)current;
        Composite textClientContainer = new Composite((Composite)section, 0);
        textClientContainer.setBackground(null);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        textClientContainer.setLayout((Layout)layout);
        Label filler = new Label(textClientContainer, 0);
        filler.setBackground(null);
        filler.setForeground(section.getTitleBarForeground());
        filler.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarManager.createControl(textClientContainer);
        GridData gridData = new GridData(131072, 128, false, false, 1, 1);
        toolBar.setLayoutData((Object)gridData);
        toolkit.adapt((Control)toolBar, false, false);
        toolBar.setBackground(null);
        section.setTextClient((Control)textClientContainer);
        return toolBarManager;
    }

    public void setFocus() {
        this.fCurrentPortDetailsControl.setInitialFocus();
    }

    public void dispose() {
        this.removeListeners();
        this.removeNoCurrentPortWidgets();
        this.removeCurrentPortWidgets();
        this.initialize(null);
        super.dispose();
    }

    private class FilterDropDownAction
    extends Action {
        private final String TOOLTIP;

        public FilterDropDownAction() {
            super(null, 4);
            this.TOOLTIP = Messages.CurrentPortPage_FILTER_MENU_TOOLTIP;
            this.setToolTipText(this.TOOLTIP);
            this.setImageDescriptor(ImagePool.FILTER_ICON);
            this.setMenuCreator(new IMenuCreator(){
                private MenuManager fDropDownMenuMgr;

                private void createDropDownMenuMgr() {
                    if (this.fDropDownMenuMgr == null) {
                        this.fDropDownMenuMgr = new MenuManager();
                        if (CurrentPortPage.this.fCurrentPortDetailsFilterActionGroup == null) {
                            CurrentPortPage.this.fCurrentPortDetailsFilterActionGroup = new CurrentPortDetailsFilterActionGroup();
                        }
                        CurrentPortPage.this.fCurrentPortDetailsFilterActionGroup.fillContextMenu((IMenuManager)this.fDropDownMenuMgr);
                    }
                }

                public Menu getMenu(Control parent) {
                    this.createDropDownMenuMgr();
                    Menu menu = this.fDropDownMenuMgr.createContextMenu(parent);
                    return menu;
                }

                public Menu getMenu(Menu parent) {
                    this.createDropDownMenuMgr();
                    Menu menu = new Menu(parent);
                    IContributionItem[] items = this.fDropDownMenuMgr.getItems();
                    int i = 0;
                    while (i < items.length) {
                        IContributionItem item;
                        IContributionItem newItem = item = items[i];
                        if (item instanceof ActionContributionItem) {
                            newItem = new ActionContributionItem(((ActionContributionItem)item).getAction());
                        }
                        newItem.fill(menu, -1);
                        ++i;
                    }
                    return menu;
                }

                public void dispose() {
                    if (this.fDropDownMenuMgr != null) {
                        this.fDropDownMenuMgr.dispose();
                        this.fDropDownMenuMgr = null;
                    }
                }
            });
        }

        public void run() {
            if (CurrentPortPage.this.fCurrentPortDetailsFilterActionGroup != null) {
                CurrentPortPage.this.fCurrentPortDetailsFilterActionGroup.toggleDefaultFilterAction();
            }
        }
    }

    private class RefreshPortCacheAction
    extends Action {
        public RefreshPortCacheAction() {
            super(null, 1);
            this.setToolTipText(Messages.CurrentPortPage_REFRESH_ACTION_TOOLTIP);
            this.setImageDescriptor(ImagePool.REFRESH_ICON);
        }

        public void run() {
            if (ModelUtil.TRACE_PORT_CACHE_UPDATE) {
                ModelUtil.log((String)"\nCurrentPortPage#RefreshPortCacheAction#run : Refresh requested");
            }
            CurrentPortPage.this.fOpRunner.enqueue(Messages.CurrentPortPage_RefreshCurrentPortJobName, (Operation)new RepositoryOperation(CurrentPortPage.this.fEditorInput.getWorkspace().teamRepository()){

                public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                    Display display;
                    IWorkspaceConnection workspaceConnection = CurrentPortPage.this.fEditorInput.getWorkspace();
                    workspaceConnection.refresh(monitor);
                    ScrolledForm form = CurrentPortPage.this.fManagedForm.getForm();
                    if (form != null && !form.isDisposed() && (display = form.getDisplay()) != null && !display.isDisposed()) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                HashSet<PortsCacheManager.ComponentUpdateRequest> componentToRefresh = new HashSet<PortsCacheManager.ComponentUpdateRequest>(1);
                                PortsCacheManager.ComponentUpdateRequest request = new PortsCacheManager.ComponentUpdateRequest(CurrentPortPage.this.fEditorInput.getWorkspace(), (IComponentHandle)CurrentPortPage.this.fEditorInput.getComponent(), true, false);
                                request.refreshCurrentPortItems();
                                componentToRefresh.add(request);
                                PortsCacheManager.getInstance().requestPortCacheComponentRefresh(componentToRefresh);
                            }
                        });
                    }
                }
            });
        }
    }
}

