/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.port;

import com.ibm.team.filesystem.ide.ui.internal.actions.port.AbortCurrentPortAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.CompleteCurrentPortAction;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditor;
import com.ibm.team.filesystem.ide.ui.internal.editors.component.ComponentEditorInput;
import com.ibm.team.filesystem.ide.ui.internal.util.ExternalCompareToolUtils;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISubcomponentChange;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.PortsCacheManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.CurrentPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortsNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeParentNode;
import com.ibm.team.filesystem.ui.changes.RenameChangeSetUtil;
import com.ibm.team.filesystem.ui.changes.RenameRemoteActivityComment;
import com.ibm.team.filesystem.ui.changes.actions.OpenAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenInExternalCompareAction;
import com.ibm.team.filesystem.ui.changes.configuration.ChangesSorter;
import com.ibm.team.filesystem.ui.changes.views.CommentComposite;
import com.ibm.team.filesystem.ui.changes.views.CommentTextListener;
import com.ibm.team.filesystem.ui.changes.views.InternalConvertingSelectionProvider;
import com.ibm.team.filesystem.ui.changes.views.LocalSynchronizeDecorator;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.filesystem.ui.changes.views.zoom.workitems.IZoomWorkItemRoot;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewer;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewerTooltipSupport;
import com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortDetailsDragAdapter;
import com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortOutputComparator;
import com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortOutputContentProvider;
import com.ibm.team.internal.filesystem.ui.util.MenuUtil;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.internal.menus.ActionExtContributionItem;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.PushAction;
import com.ibm.team.repository.rcp.ui.internal.viewers.MenuManagerWithDefaultAdditions;
import com.ibm.team.repository.rcp.ui.openactions.IWorkbenchRunnable;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.IDE;

public class CurrentPortOutputControl {
    public static final String CONTROL_ID = "com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortPage.CurrentPortOutputControl";
    private IWorkspaceConnection fWorkspace;
    private IComponent fComponent;
    private IOperationRunner fOpRunner;
    private IWorkbenchPartSite fParentPartSite;
    private FormToolkit fToolkit;
    private Composite fComposite;
    private final int TREE_VIEWER_HINT = 100;
    private Tree fTree;
    private CustomTreeViewer fTreeViewer;
    private LocalWorkspaceChangesViewLabelProvider fLabelProvider;
    private MenuManager fMenuManager;
    private Button fCompleteCurrentPortButton;
    private Button fAbandonCurrentPortButton;
    private Button fCreatePortLinkButton;
    private Image fInfoImage;
    private Label fStatusLabel;
    private IActionBars fActionBars;
    private TextActionHandler fTextActionHandler;
    private TreeEditor fTreeEditor;
    private TreeItem fLastEditItem;
    private boolean fAlreadyRenaming = false;
    private Runnable fRenameChangeRunnable = new Runnable(){

        @Override
        public void run() {
            TreeItem item = null;
            if (CurrentPortOutputControl.this.fTree != null && !CurrentPortOutputControl.this.fTree.isDisposed()) {
                TreeItem[] items;
                if (CurrentPortOutputControl.this.fLastEditItem != null && !CurrentPortOutputControl.this.fLastEditItem.isDisposed()) {
                    items = new TreeItem[]{CurrentPortOutputControl.this.fLastEditItem};
                    CurrentPortOutputControl.this.textEdit(items);
                }
                item = (items = CurrentPortOutputControl.this.fTree.getSelection()) != null && items.length == 1 ? items[0] : null;
            }
            CurrentPortOutputControl.this.fAlreadyRenaming = false;
            CurrentPortOutputControl.this.fLastEditItem = item == CurrentPortOutputControl.this.fLastEditItem ? null : item;
        }
    };
    private Action fRenameChangeSetAction = new Action(){

        public void run() {
            if (CurrentPortOutputControl.this.isRenameActionEnabled()) {
                CurrentPortOutputControl.this.textEdit();
            }
        }
    };

    public CurrentPortOutputControl(FormToolkit toolkit, IWorkbenchPartSite parentPartSite, IActionBars actionBars, Composite parent, IWorkspaceConnection workspace, IComponent component, IOperationRunner operationRunner) {
        Assert.isNotNull((Object)parentPartSite);
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)workspace);
        Assert.isNotNull((Object)component);
        Assert.isNotNull((Object)operationRunner);
        this.fToolkit = toolkit;
        this.fParentPartSite = parentPartSite;
        this.fActionBars = actionBars;
        this.fTextActionHandler = new TextActionHandler(actionBars);
        this.fWorkspace = workspace;
        this.fComponent = component;
        this.fOpRunner = operationRunner;
        this.fComposite = this.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fComposite);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(this.fComposite);
        Composite treeComposite = this.createComposite(this.fComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)treeComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(treeComposite);
        this.fTree = this.createTree(treeComposite, 2818);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 100).span(1, 2).applyTo((Control)this.fTree);
        this.fTreeViewer = new CustomTreeViewer(this.fTree);
        this.fLabelProvider = new LocalWorkspaceChangesViewLabelProvider(true);
        LocalSynchronizeDecorator labelDecorator = new LocalSynchronizeDecorator(true);
        this.fTreeViewer.init(new DecoratingLabelProvider((ILabelProvider)this.fLabelProvider, (ILabelDecorator)labelDecorator));
        this.fTreeViewer.setContentProvider((IContentProvider)new CurrentPortOutputContentProvider());
        this.fTreeViewer.setComparator((ViewerComparator)new CurrentPortOutputComparator());
        this.fTreeViewer.setInput(PortsCacheManager.getInstance().getPortNode(this.fWorkspace.teamRepository(), (IWorkspaceHandle)this.fWorkspace.getResolvedWorkspace(), (IComponentHandle)this.fComponent));
        this.fTreeViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        this.fTreeViewer.addOpenListener(this.getOpenListener());
        this.addTreeEditCommentSupport();
        this.addTreeContextMenu();
        this.addTreeDragSupport();
        this.addTreeTooltipSupport();
        Composite buttonBar = this.createComposite(this.fComposite);
        buttonBar.setLayoutData((Object)new GridData(131072, 4, false, true));
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        this.fCompleteCurrentPortButton = this.createPushButton(buttonBar, Messages.CurrentPortOutputControl_COMPLETE_BUTTON_LABEL, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CurrentPortOutputControl.this.doCompleteCurrentPort();
            }
        });
        this.fCompleteCurrentPortButton.setEnabled(true);
        this.fAbandonCurrentPortButton = this.createPushButton(buttonBar, Messages.CurrentPortOutputControl_ABANDON_BUTTON_LABEL, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CurrentPortOutputControl.this.doAbandonCurrentPort();
            }
        });
        this.fAbandonCurrentPortButton.setEnabled(true);
        this.fCreatePortLinkButton = this.createCheckBoxButton(this.fComposite, Messages.CurrentPortOutputControl_CREATE_LINK_BUTTON_LABEL, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.fCreatePortLinkButton.setSelection(true);
        GridDataFactory.fillDefaults().grab(false, false).span(2, 1).applyTo((Control)this.fCreatePortLinkButton);
        Composite infoComposite = this.createComposite(this.fComposite);
        infoComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        infoComposite.setLayout((Layout)new GridLayout(2, false));
        Label infoIcon = new Label(infoComposite, 0);
        this.fInfoImage = ImagePool.INFO_OBJ.createImage();
        infoIcon.setImage(this.fInfoImage);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).indent(-7, 0).applyTo((Control)infoIcon);
        this.fStatusLabel = toolkit.createLabel(infoComposite, this.getStatusLabelText());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).indent(-2, 0).applyTo((Control)this.fStatusLabel);
        this.requestRefresh();
    }

    public Composite getComposite() {
        return this.fComposite;
    }

    public CustomTreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    public LocalWorkspaceChangesViewLabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    public TreeEditor getTreeEditor() {
        return this.fTreeEditor;
    }

    public void requestRefresh() {
        this.refreshTreeViewer();
        this.refreshStatusLabel();
        this.updateCreatePortLinkButtonVisibility();
        this.updateEnablement();
    }

    public void setEnabled(boolean enabled) {
        if (this.fTreeViewer != null && !this.fTreeViewer.getTree().isDisposed()) {
            this.fTreeViewer.getTree().setEnabled(enabled);
        }
        if (this.fCompleteCurrentPortButton != null && !this.fCompleteCurrentPortButton.isDisposed()) {
            this.fCompleteCurrentPortButton.setEnabled(enabled);
        }
        if (this.fAbandonCurrentPortButton != null && !this.fAbandonCurrentPortButton.isDisposed()) {
            this.fAbandonCurrentPortButton.setEnabled(enabled);
        }
        if (enabled) {
            this.updateEnablement();
        }
    }

    public boolean setInitialFocus() {
        return this.fTreeViewer.getControl().setFocus();
    }

    public boolean isCreatePortLink() {
        return this.fCreatePortLinkButton.isVisible() ? this.fCreatePortLinkButton.getSelection() : false;
    }

    public String getStatusLabelText() {
        String statusText = "";
        PortsNode portsNode = PortsCacheManager.getInstance().getPortNode(this.fWorkspace.teamRepository(), (IWorkspaceHandle)this.fWorkspace.getResolvedWorkspace(), (IComponentHandle)this.fComponent);
        if (portsNode == null || portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode() == null) {
            statusText = Messages.CurrentPortOutputControl_STATUS_TEXT_NO_CHANGE_SET;
        } else {
            TreeItem treeItem;
            CurrentPortNode currentPort = portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode();
            IOutgoingRemoteActivity outgoingChangeSet = null;
            Tree tree = this.fTreeViewer.getTree();
            if (tree != null && tree.getItemCount() > 0 && (treeItem = tree.getItem(0)) != null && treeItem.getData() instanceof IOutgoingRemoteActivity) {
                outgoingChangeSet = (IOutgoingRemoteActivity)treeItem.getData();
            }
            if (outgoingChangeSet == null) {
                statusText = Messages.CurrentPortOutputControl_STATUS_TEXT_NO_CHANGE_SET;
            } else {
                IChangeSet changeSet = outgoingChangeSet.getChangeSet();
                if (changeSet == null || changeSet.changes().size() == 0) {
                    statusText = Messages.CurrentPortOutputControl_STATUS_TEXT_EMPTY_CHANGE_SET;
                } else {
                    int numMissingFiles = this.getNumMissingFiles(outgoingChangeSet, currentPort);
                    int numAdditionalFiles = this.getNumAdditionalFiles(outgoingChangeSet, currentPort);
                    if (numMissingFiles == 0 && numAdditionalFiles == 0) {
                        statusText = Messages.CurrentPortOutputControl_STATUS_TEXT_NO_MISSING_OR_EXTRA;
                    } else if (numMissingFiles == 0 && numAdditionalFiles == 1) {
                        statusText = Messages.CurrentPortOutputControl_STATUS_TEXT_1_EXTRA;
                    } else if (numMissingFiles == 0 && numAdditionalFiles > 1) {
                        statusText = NLS.bind((String)Messages.CurrentPortOutputControl_STATUS_TEXT_MANY_EXTRA, (Object)numAdditionalFiles);
                    } else if (numMissingFiles == 1 && numAdditionalFiles == 0) {
                        statusText = Messages.CurrentPortOutputControl_STATUS_TEXT_1_MISSING;
                    } else if (numMissingFiles == 1 && numAdditionalFiles == 1) {
                        statusText = Messages.CurrentPortOutputControl_STATUS_TEXT_1_MISSING_1_EXTRA;
                    } else if (numMissingFiles == 1 && numAdditionalFiles > 1) {
                        statusText = NLS.bind((String)Messages.CurrentPortOutputControl_STATUS_TEXT_1_MISSING_MANY_EXTRA, (Object)numAdditionalFiles);
                    } else if (numMissingFiles > 1 && numAdditionalFiles == 0) {
                        statusText = NLS.bind((String)Messages.CurrentPortOutputControl_STATUS_TEXT_MANY_MISSING, (Object)numMissingFiles);
                    } else if (numMissingFiles > 1 && numAdditionalFiles == 1) {
                        statusText = NLS.bind((String)Messages.CurrentPortOutputControl_STATUS_TEXT_MANY_MISSING_1_EXTRA, (Object)numMissingFiles);
                    } else if (numMissingFiles > 1 && numAdditionalFiles > 1) {
                        statusText = NLS.bind((String)Messages.CurrentPortOutputControl_STATUS_TEXT_MANY_MISSING_MANY_EXTRA, (Object)numMissingFiles, (Object)numAdditionalFiles);
                    }
                }
            }
        }
        return statusText;
    }

    public void dispose() {
        if (this.fInfoImage != null && !this.fInfoImage.isDisposed()) {
            this.fInfoImage.dispose();
            this.fInfoImage = null;
        }
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), null);
            this.fActionBars.updateActionBars();
        }
        if (this.fComposite != null && !this.fComposite.isDisposed()) {
            this.fComposite.dispose();
            this.fComposite = null;
        }
        this.fRenameChangeRunnable = null;
        this.fRenameChangeSetAction = null;
    }

    private void doCompleteCurrentPort() {
        if (this.isCompleteCurrentPortButtonEnabled()) {
            CompleteCurrentPortAction.completeCurrentPort(this.fWorkspace, this.fComponent, this.isCreatePortLink(), this.fParentPartSite.getPart(), this.fOpRunner);
        }
    }

    private boolean isCompleteCurrentPortButtonEnabled() {
        TreeItem treeItem;
        IOutgoingRemoteActivity outgoingChangeSet = null;
        Tree tree = this.fTreeViewer.getTree();
        if (tree != null && tree.getItemCount() > 0 && (treeItem = tree.getItem(0)) != null && treeItem.getData() instanceof IOutgoingRemoteActivity) {
            outgoingChangeSet = (IOutgoingRemoteActivity)treeItem.getData();
        }
        if (outgoingChangeSet == null) {
            return false;
        }
        IChangeSet changeSet = outgoingChangeSet.getChangeSet();
        return changeSet != null && changeSet.changes().size() != 0;
    }

    private void doAbandonCurrentPort() {
        if (this.isAbandonCurrentPortButtonEnabled()) {
            AbortCurrentPortAction.abortCurrentPort(this.fWorkspace, this.fComponent, this.fParentPartSite.getPart(), this.fOpRunner);
        }
    }

    private boolean isAbandonCurrentPortButtonEnabled() {
        boolean serverHasCurrentPort;
        boolean uiHasCurrentPort = PortsCacheManager.getInstance().hasCurrentPort(this.fWorkspace.teamRepository(), (IWorkspaceHandle)this.fWorkspace.getResolvedWorkspace(), (IComponentHandle)this.fComponent);
        boolean bl = serverHasCurrentPort = this.fWorkspace.getCurrentPatch((IComponentHandle)this.fComponent) != null;
        if (uiHasCurrentPort || serverHasCurrentPort) {
            return true;
        }
        boolean uiHasPendingPorts = PortsCacheManager.getInstance().hasPendingPorts(this.fWorkspace.teamRepository(), (IWorkspaceHandle)this.fWorkspace.getResolvedWorkspace(), (IComponentHandle)this.fComponent);
        boolean serverHasPendingPorts = false;
        try {
            serverHasPendingPorts = this.fWorkspace.getAcceptQueueSize((IComponentHandle)this.fComponent) > 0L;
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            // empty catch block
        }
        return !uiHasPendingPorts && serverHasPendingPorts;
    }

    private boolean isCreatePortLinkButtonEnabled() {
        CurrentPortNode currentPortNode;
        boolean isEnabled = false;
        PortsNode root = PortsCacheManager.getInstance().getPortNode(this.fWorkspace.teamRepository(), (IWorkspaceHandle)this.fWorkspace.getResolvedWorkspace(), (IComponentHandle)this.fComponent);
        if (root != null && (currentPortNode = root.getChildCurrentPortContainerNode().getChildCurrentPortNode()) != null && currentPortNode.getPortSourceChangeSet() != null) {
            isEnabled = true;
        }
        return isEnabled;
    }

    private boolean isRenameActionEnabled() {
        IStructuredSelection selection;
        boolean isEnabled = false;
        if (this.fTreeViewer.getTree().isFocusControl() && (selection = this.getCurrentTreeSelection()) != null && selection.size() > 0) {
            boolean validSelection = true;
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                int allowRename = RenameChangeSetUtil.allowRename(it.next());
                if (allowRename == 0 || allowRename == 1) continue;
                validSelection = false;
                break;
            }
            isEnabled = validSelection;
        }
        return isEnabled;
    }

    private IStructuredSelection getCurrentTreeSelection() {
        return (IStructuredSelection)this.fTreeViewer.getSelection();
    }

    private void refreshTreeViewer() {
        if (this.fTreeViewer.getTree() != null && !this.fTreeViewer.getTree().isDisposed()) {
            Object[] expandedElements = this.fTreeViewer.getExpandedElements();
            IStructuredSelection selection = this.getCurrentTreeSelection();
            this.fTreeViewer.getTree().setRedraw(false);
            this.fTreeViewer.setInput(PortsCacheManager.getInstance().getPortNode(this.fWorkspace.teamRepository(), (IWorkspaceHandle)this.fWorkspace.getResolvedWorkspace(), (IComponentHandle)this.fComponent));
            this.fTreeViewer.setExpandedElements(expandedElements);
            this.fTreeViewer.getTree().setRedraw(true);
            if (!selection.isEmpty()) {
                this.fTreeViewer.reveal(selection.getFirstElement());
                this.fTreeViewer.setSelection((ISelection)selection, true);
            }
        }
    }

    private void refreshStatusLabel() {
        if (this.fStatusLabel != null && !this.fStatusLabel.isDisposed()) {
            this.fStatusLabel.setText(this.getStatusLabelText());
        }
    }

    private void updateCreatePortLinkButtonVisibility() {
        if (this.fCreatePortLinkButton != null && !this.fCreatePortLinkButton.isDisposed()) {
            CurrentPortNode currentPortNode;
            boolean isVisible = true;
            PortsNode root = PortsCacheManager.getInstance().getPortNode(this.fWorkspace.teamRepository(), (IWorkspaceHandle)this.fWorkspace.getResolvedWorkspace(), (IComponentHandle)this.fComponent);
            if (root != null && (currentPortNode = root.getChildCurrentPortContainerNode().getChildCurrentPortNode()) != null && currentPortNode.getPortSourceChangeSet() == null) {
                isVisible = false;
            }
            if (isVisible) {
                this.fCreatePortLinkButton.setVisible(true);
                GridDataFactory.fillDefaults().grab(false, false).span(2, 1).applyTo((Control)this.fCreatePortLinkButton);
            } else {
                this.fCreatePortLinkButton.setVisible(false);
                GridDataFactory.fillDefaults().grab(false, false).span(2, 1).exclude(true).applyTo((Control)this.fCreatePortLinkButton);
            }
            if (this.fComposite != null && !this.fComposite.isDisposed()) {
                this.fComposite.layout();
            }
        }
    }

    private void addTreeEditCommentSupport() {
        this.fTreeEditor = new TreeEditor(this.fTree);
        this.fTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item;
                TreeItem[] items = CurrentPortOutputControl.this.fTree.getSelection();
                TreeItem treeItem = item = items.length == 1 ? items[0] : null;
                if (item != null && item == CurrentPortOutputControl.this.fLastEditItem) {
                    Object element = item.getData();
                    if (RenameChangeSetUtil.allowRename(element) == 0) {
                        int time = e.display.getDoubleClickTime() * 3 / 2;
                        CurrentPortOutputControl.this.fAlreadyRenaming = true;
                        e.display.timerExec(time, CurrentPortOutputControl.this.fRenameChangeRunnable);
                    }
                } else {
                    CurrentPortOutputControl.this.fLastEditItem = CurrentPortOutputControl.this.fAlreadyRenaming ? null : item;
                    CurrentPortOutputControl.this.fAlreadyRenaming = false;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                e.display.timerExec(-1, CurrentPortOutputControl.this.fRenameChangeRunnable);
            }
        });
        this.fTree.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                event.display.timerExec(-1, CurrentPortOutputControl.this.fRenameChangeRunnable);
            }
        });
        this.fTree.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                event.display.timerExec(-1, CurrentPortOutputControl.this.fRenameChangeRunnable);
            }
        });
        this.fActionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fRenameChangeSetAction);
    }

    public void textEdit() {
        TreeItem[] items = this.fTree.getSelection();
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                return;
            }
            ++i;
        }
        this.textEdit(items);
    }

    private void textEdit(TreeItem[] items) {
        RenameRemoteActivityComment rename = RenameRemoteActivityComment.create((Item[])items, (ColumnViewer)this.fTreeViewer, this.fParentPartSite);
        if (rename == null) {
            return;
        }
        TreeItem firstItem = items[0];
        if (firstItem != null) {
            String firstComment = rename.getFirstComment();
            CommentComposite commentComposite = new CommentComposite((Composite)this.fTree, firstComment);
            this.fTextActionHandler.addText(commentComposite.getTextControl());
            this.fTreeEditor.grabHorizontal = true;
            this.fTreeEditor.grabVertical = true;
            this.fTreeEditor.horizontalAlignment = 16384;
            this.fTreeEditor.verticalAlignment = 128;
            CommentTextListener textListener = new CommentTextListener(commentComposite, rename, new CommentTextListener.CommentTextListenerInput(){

                @Override
                public boolean setFocus() {
                    return CurrentPortOutputControl.this.setInitialFocus();
                }

                @Override
                public TreeViewer getTreeViewer() {
                    return CurrentPortOutputControl.this.getTreeViewer();
                }

                @Override
                public TreeEditor getTreeEditor() {
                    return CurrentPortOutputControl.this.getTreeEditor();
                }

                @Override
                public LocalWorkspaceChangesViewLabelProvider getLabelProvider() {
                    return CurrentPortOutputControl.this.getLabelProvider();
                }

                @Override
                public void endTextEdit(Text text) {
                    CurrentPortOutputControl.this.endTextEdit(text);
                }
            });
            CommentTextListener.addContentPropsalAdapter(commentComposite, textListener);
            this.fTreeEditor.setEditor((Control)commentComposite, firstItem);
            this.fLabelProvider.beginEditChangeSet(rename.getRemoteActivities(), firstComment);
        }
    }

    private void endTextEdit(Text textControl) {
        this.fTextActionHandler.removeText(textControl);
        this.fLabelProvider.endEditChangeSet();
    }

    private void addTreeContextMenu() {
        this.fMenuManager = new MenuManagerWithDefaultAdditions(){

            protected boolean allowItem(IContributionItem itemToAdd) {
                if ("com.ibm.team.filesystem.internal.rcp.ui.workitems.lcs.actions.LocateChangeSetsAction".equals(itemToAdd.getId())) {
                    return false;
                }
                if ("com.ibm.team.filesystem.ui.actions.ReverseChangeAction".equals(itemToAdd.getId())) {
                    return false;
                }
                if ("com.ibm.team.filesystem.ui.changes.actions.CopyChangeAction".equals(itemToAdd.getId())) {
                    return false;
                }
                if ("com.ibm.team.filesystem.actions.copyWebURL".equals(itemToAdd.getId())) {
                    return false;
                }
                if ("com.ibm.team.workitem.rcp.ui.addToFavoritesAction".equals(itemToAdd.getId())) {
                    return false;
                }
                return super.allowItem(itemToAdd);
            }
        };
        ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)this.fMenuManager);
        final Menu menu = this.fMenuManager.createContextMenu((Control)this.fTreeViewer.getTree());
        this.fTreeViewer.getTree().setMenu(menu);
        String openLinkActionID = "com.ibm.team.filesystem.ui.changes.actions.link.OpenAction";
        Action openLinkAction = new Action(){

            public void run() {
                AbstractActionDelegate.execute(OpenAction.class, (UIContext)UIContext.createPartContext((IWorkbenchPart)CurrentPortOutputControl.this.fParentPartSite.getPart()), (IStructuredSelection)CurrentPortOutputControl.this.getCurrentTreeSelection());
            }
        };
        openLinkAction.setText(Messages.CurrentPortOutputControl_OPEN_LINK_ACTION_LABEL);
        openLinkAction.setId("com.ibm.team.filesystem.ui.changes.actions.link.OpenAction");
        PushAction expandChildrenContextMenuAction = new PushAction(Messages.CurrentPortOutputControl_EXPAND_CHILDREN_ACTION_LABEL, new Runnable(){

            @Override
            public void run() {
                CurrentPortOutputControl.this.expandChildrenContextAction();
            }
        });
        this.fMenuManager.add((IContributionItem)new ActionExtContributionItem((IActionExt)expandChildrenContextMenuAction));
        menu.addMenuListener((MenuListener)new MenuAdapter((IAction)openLinkAction){
            private final /* synthetic */ IAction val$openLinkAction;
            {
                this.val$openLinkAction = iAction;
            }

            public void menuShown(MenuEvent e) {
                boolean containsAllLinks = true;
                if (CurrentPortOutputControl.this.getCurrentTreeSelection().isEmpty()) {
                    containsAllLinks = false;
                } else {
                    for (Object element : CurrentPortOutputControl.this.getCurrentTreeSelection().toList()) {
                        if ((element instanceof IFileSystemWorkItem || element instanceof IZoomWorkItemRoot) && (!(element instanceof IZoomWorkItemRoot) || ((IZoomWorkItemRoot)element).getWorkItem() != null)) continue;
                        containsAllLinks = false;
                        break;
                    }
                }
                MenuItem openLinkMenuItem = MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.link.OpenAction");
                if (containsAllLinks && openLinkMenuItem == null) {
                    CurrentPortOutputControl.this.fMenuManager.appendToGroup("jazz.open.group", this.val$openLinkAction);
                } else if (!containsAllLinks && openLinkMenuItem != null) {
                    CurrentPortOutputControl.this.fMenuManager.remove("com.ibm.team.filesystem.ui.changes.actions.link.OpenAction");
                }
                CurrentPortOutputControl.this.fMenuManager.update(true);
                MenuItem menuItem = null;
                boolean useExternalCompareTool = ExternalCompareToolUtils.shouldUseExternalCompareTool();
                menuItem = useExternalCompareTool ? MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.OpenInExternalCompareAction") : MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.OpenAction");
                if (menuItem == null) {
                    menuItem = MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.link.OpenAction");
                }
                if (menuItem != null && !menuItem.isEnabled()) {
                    menuItem = null;
                }
                menu.setDefaultItem(menuItem);
            }
        });
        this.fParentPartSite.registerContextMenu(CONTROL_ID, this.fMenuManager, (ISelectionProvider)new InternalConvertingSelectionProvider((ISelectionProvider)this.fTreeViewer));
        this.fParentPartSite.registerContextMenu(CONTROL_ID, this.fMenuManager, (ISelectionProvider)this.fTreeViewer);
    }

    private void expandChildrenContextAction() {
        if (this.fTreeViewer != null) {
            for (Object selection : this.getCurrentTreeSelection().toList()) {
                this.fTreeViewer.expandToLevel(selection, -1);
            }
        }
    }

    private void addTreeDragSupport() {
        this.fTreeViewer.addDragSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new CurrentPortDetailsDragAdapter(this.fTreeViewer));
    }

    private void addTreeTooltipSupport() {
        new CustomTreeViewerTooltipSupport(this.fTreeViewer, true, true){

            protected Object doResolve(Object element) {
                if (DomainAdapterUtils.getDomainAdapter((Object)element) == null) {
                    if (element instanceof IModelAccessor) {
                        return ((IModelAccessor)element).getModelInstance();
                    }
                    return null;
                }
                return super.doResolve(element);
            }

            protected void hoverToolTipOpened() {
                CurrentPortOutputControl.this.fActionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), null);
                CurrentPortOutputControl.this.fActionBars.updateActionBars();
                Object element = this.getElement();
                if (element instanceof IFileSystemWorkItem || element instanceof IRemoteActivity) {
                    this.setOpenable(true);
                } else {
                    this.setOpenable(false);
                }
            }

            protected void openRequested(Object element) {
                if (element instanceof IFileSystemWorkItem) {
                    IFileSystemWorkItem workItemNode = (IFileSystemWorkItem)element;
                    IAuditable workItem = workItemNode.getWorkItem();
                    this.openWorkItem(workItem.getItemHandle());
                } else if (element instanceof IRemoteActivity) {
                    IRemoteActivity changeSetNode = (IRemoteActivity)element;
                    for (IFileSystemWorkItem fileSystemWorkItem : changeSetNode.getWorkItems()) {
                        this.openWorkItem(fileSystemWorkItem.getWorkItemHandle());
                    }
                } else if (element instanceof ISubcomponentChange) {
                    CurrentPortOutputControl.this.openComponentEditor((ISubcomponentChange)element);
                }
            }

            private void openWorkItem(Object itemHandle) {
                IWorkbenchPage page = CurrentPortOutputControl.this.fParentPartSite.getPage();
                IEditorInput editorInput = (IEditorInput)Platform.getAdapterManager().loadAdapter(itemHandle, IEditorInput.class.getName());
                if (editorInput != null) {
                    try {
                        IWorkbench workbench = page.getWorkbenchWindow().getWorkbench();
                        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
                        IEditorDescriptor defaultEditor = editorRegistry.getDefaultEditor("jazz_workitem");
                        String editorId = defaultEditor.getId();
                        boolean activate = OpenStrategy.activateOnOpen();
                        IDE.openEditor((IWorkbenchPage)page, (IEditorInput)editorInput, (String)editorId, (boolean)activate);
                    }
                    catch (PartInitException e) {
                        IStatus errorStatus = StatusUtil.newStatus((Object)"com.ibm.team.filesystem.ide.ui", (Throwable)e);
                        StatusUtil.log((IStatus)errorStatus);
                    }
                }
            }

            protected void hoverToolTipClosed() {
                CurrentPortOutputControl.this.fActionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)CurrentPortOutputControl.this.fRenameChangeSetAction);
                CurrentPortOutputControl.this.fActionBars.updateActionBars();
            }
        };
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CurrentPortOutputControl.this.updateEnablement();
            }
        };
    }

    private IOpenListener getOpenListener() {
        return new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection structuredSelection;
                List elements;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (elements = (structuredSelection = (IStructuredSelection)selection).toList()) != null && elements.size() > 0) {
                    CurrentPortOutputControl.this.handleOpenTreeElements(elements);
                }
            }
        };
    }

    private void handleOpenTreeElements(List elements) {
        for (Object element : elements) {
            IWorkbenchRunnable genericOpenAction;
            IRemoteChangeSummary change;
            if (element instanceof IRemoteChangeSummary && OpenInCompareAction.isOpenable(change = (IRemoteChangeSummary)element)) {
                Object action;
                if (ExternalCompareToolUtils.shouldUseExternalCompareTool(this.getCurrentTreeSelection())) {
                    action = new OpenInExternalCompareAction();
                    ((OpenInExternalCompareAction)((Object)action)).run(this.fParentPartSite.getShell(), this.fParentPartSite.getPage(), this.getCurrentTreeSelection());
                    continue;
                }
                action = new OpenInCompareAction(this.fParentPartSite.getPage(), (ISelection)this.getCurrentTreeSelection());
                ((OpenInCompareAction)((Object)action)).run();
                continue;
            }
            if (element instanceof ISubcomponentChange) {
                this.openComponentEditor((ISubcomponentChange)element);
            }
            if (element instanceof IFileSystemWorkItem) {
                IFileSystemWorkItem workItem = (IFileSystemWorkItem)element;
                element = workItem.getWorkItem();
            }
            if ((genericOpenAction = com.ibm.team.repository.rcp.ui.openactions.OpenAction.getActionFor(element)) != null) {
                genericOpenAction.run(this.fParentPartSite.getShell(), this.fParentPartSite.getPage(), (IStructuredSelection)new StructuredSelection(element));
                continue;
            }
            if (this.fTreeViewer.getExpandedState(element)) {
                this.fTreeViewer.collapseToLevel(element, -1);
                continue;
            }
            this.fTreeViewer.expandToLevel(element, 1);
            Object firstChange = ChangesSorter.findFirstChange(this.fTreeViewer, element, null, true);
            if (firstChange == null) continue;
            this.fTreeViewer.reveal(element);
        }
    }

    private void openComponentEditor(ISubcomponentChange change) {
        IWorkbenchPage page;
        IComponent component = change.getComponent();
        if (component != null && (page = this.fParentPartSite.getPage()) != null) {
            IWorkspaceConnection connection = change.getContainingWorkspaceConnection();
            if (connection != null) {
                WorkspaceComponentWrapper componentWrapper = WorkspaceComponentWrapper.newWrapper(connection, component);
                ComponentEditor.open(page, ComponentEditorInput.newForEdit(componentWrapper));
            } else {
                ComponentWrapper componentWrapper = new ComponentWrapper((ITeamRepository)component.getOrigin(), component);
                ComponentEditor.open(page, ComponentEditorInput.newForEdit(componentWrapper));
            }
        }
    }

    private int getNumMissingFiles(IOutgoingRemoteActivity outgoingPortChangeSet, CurrentPortNode currentPort) {
        int numMissingFiles = 0;
        IChangeSet changeSet = outgoingPortChangeSet.getChangeSet();
        HashSet<UUID> filesInCurrentPort = new HashSet<UUID>();
        for (VersionableChangeParentNode parentNode : currentPort.getPortChanges().getChildNodes()) {
            for (VersionableChangeNode versionableChangeNode : parentNode.getChildNodes()) {
                filesInCurrentPort.add(versionableChangeNode.getVersionable().getItemId());
            }
        }
        if (changeSet != null) {
            for (UUID uuid : filesInCurrentPort) {
                boolean foundInPortChangeSet = false;
                for (Object change : changeSet.changes()) {
                    IChange iChange;
                    if (change == null || !(change instanceof IChange) || !(iChange = (IChange)change).item().getItemId().equals((Object)uuid)) continue;
                    foundInPortChangeSet = true;
                    break;
                }
                if (foundInPortChangeSet) continue;
                ++numMissingFiles;
            }
        } else {
            numMissingFiles = filesInCurrentPort.size();
        }
        return numMissingFiles;
    }

    private int getNumAdditionalFiles(IOutgoingRemoteActivity outgoingPortChangeSet, CurrentPortNode currentPort) {
        int numAdditionalFiles = 0;
        IChangeSet changeSet = outgoingPortChangeSet.getChangeSet();
        HashSet<UUID> filesInPortChangeSet = new HashSet<UUID>();
        if (changeSet != null) {
            for (Object change : changeSet.changes()) {
                if (change == null || !(change instanceof IChange)) continue;
                IChange iChange = (IChange)change;
                filesInPortChangeSet.add(iChange.item().getItemId());
            }
        }
        for (UUID uuid : filesInPortChangeSet) {
            boolean foundInCurrentPort = false;
            block2: for (VersionableChangeParentNode parentNode : currentPort.getPortChanges().getChildNodes()) {
                for (VersionableChangeNode versionableChangeNode : parentNode.getChildNodes()) {
                    if (!versionableChangeNode.getVersionable().getItemId().equals((Object)uuid)) continue;
                    foundInCurrentPort = true;
                    continue block2;
                }
            }
            if (foundInCurrentPort) continue;
            ++numAdditionalFiles;
        }
        return numAdditionalFiles;
    }

    private void updateEnablement() {
        if (this.fCompleteCurrentPortButton != null && !this.fCompleteCurrentPortButton.isDisposed()) {
            this.fCompleteCurrentPortButton.setEnabled(this.isCompleteCurrentPortButtonEnabled());
        }
        if (this.fAbandonCurrentPortButton != null && !this.fAbandonCurrentPortButton.isDisposed()) {
            this.fAbandonCurrentPortButton.setEnabled(this.isAbandonCurrentPortButtonEnabled());
        }
        if (this.fCreatePortLinkButton != null && !this.fCreatePortLinkButton.isDisposed()) {
            this.fCreatePortLinkButton.setEnabled(this.isCreatePortLinkButtonEnabled());
        }
        if (this.fRenameChangeSetAction != null) {
            this.fRenameChangeSetAction.setEnabled(this.isRenameActionEnabled());
        }
    }

    private Composite createComposite(Composite parent) {
        if (this.fToolkit != null) {
            return this.fToolkit.createComposite(parent);
        }
        return new Composite(parent, 0);
    }

    private Tree createTree(Composite parent, int style) {
        if (this.fToolkit != null) {
            return this.fToolkit.createTree(parent, style);
        }
        return new Tree(parent, style);
    }

    private Button createPushButton(Composite parent, String text, SelectionListener listener) {
        return this.createButton(parent, text, listener, 8);
    }

    private Button createCheckBoxButton(Composite parent, String text, SelectionListener listener) {
        return this.createButton(parent, text, listener, 32);
    }

    private Button createButton(Composite parent, String text, SelectionListener listener, int style) {
        Button button;
        if (this.fToolkit != null) {
            button = this.fToolkit.createButton(parent, text, style);
        } else {
            button = new Button(parent, 8);
            button.setText(text);
        }
        button.addSelectionListener(listener);
        int minX = Math.max(button.computeSize((int)-1, (int)-1, (boolean)true).x, LayoutConstants.getMinButtonSize().x);
        GridDataFactory.fillDefaults().align(4, 128).hint(minX, -1).applyTo((Control)button);
        return button;
    }
}

