/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.port;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISubcomponentChange;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.CurrentPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortsNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class CurrentPortOutputContentProvider
implements ITreeContentProvider {
    private PortsNode fInput;

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof PortsNode) {
            IComponentSyncContext context;
            PortsNode portsNode = (PortsNode)parentElement;
            if (portsNode == null || portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode() == null) return new Object[]{Messages.CurrentPortOutputContentProvider_NO_CURRENT_PORT_NODE};
            CurrentPortNode currentPort = portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode();
            IChangeSet portTarget = currentPort.getPortTargetChangeSet();
            IWorkspaceConnection workspace = portsNode.getWorkspaceConnection();
            IComponent component = portsNode.getComponent();
            IComponentSyncContext[] contexts = ComponentSyncModel.getInstance().getComponentSyncContexts((IConnection)workspace, (IComponentHandle)component);
            if (contexts.length <= 0 || (context = contexts[0]) == null) return new Object[0];
            for (Object activity : context.getOutgoingActivitySource().getActivities()) {
                if (!(activity instanceof IOutgoingRemoteActivity)) continue;
                IOutgoingRemoteActivity outgoingActivity = (IOutgoingRemoteActivity)activity;
                if (portTarget == null || !portTarget.sameItemId((IItemHandle)outgoingActivity.getChangeSetHandle())) continue;
                return new Object[]{outgoingActivity};
            }
            return new Object[0];
        } else {
            if (parentElement instanceof IOutgoingRemoteActivity) {
                IOutgoingRemoteActivity activity = (IOutgoingRemoteActivity)parentElement;
                List subcomponentChanges = activity.getSubcomponentChanges();
                List folders = activity.getFolders();
                List workItems = activity.getWorkItems();
                List calmLinks = activity.getOslcLinks();
                ArrayList children = new ArrayList();
                children.addAll(subcomponentChanges);
                children.addAll(folders);
                children.addAll(workItems);
                children.addAll(calmLinks);
                return children.toArray();
            }
            if (parentElement instanceof IOutgoingActivityFolder) {
                IOutgoingActivityFolder folder = (IOutgoingActivityFolder)parentElement;
                return folder.getChanges().toArray();
            }
            if (!(parentElement instanceof IOutgoingRemoteChangeSummary)) return new Object[0];
            return new Object[0];
        }
    }

    public Object getParent(Object element) {
        if (element instanceof PortsNode) {
            return null;
        }
        if (element instanceof IOutgoingRemoteActivity) {
            return this.fInput;
        }
        if (element instanceof ISubcomponentChange) {
            ISubcomponentChange change = (ISubcomponentChange)element;
            return change.getRemoteActivity();
        }
        if (element instanceof IOutgoingActivityFolder) {
            IOutgoingActivityFolder folder = (IOutgoingActivityFolder)element;
            return folder.getParent();
        }
        if (element instanceof IOutgoingRemoteChangeSummary) {
            IOutgoingRemoteChangeSummary change = (IOutgoingRemoteChangeSummary)element;
            return ComponentSyncUtil.findFolder((IRemoteChangeSummary)change);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = false;
        if (element instanceof PortsNode) {
            hasChildren = true;
        } else {
            if (element instanceof IOutgoingRemoteActivity) {
                IOutgoingRemoteActivity activity = (IOutgoingRemoteActivity)element;
                return activity.getSubcomponentChanges().size() > 0 || activity.getOslcLinks().size() > 0 || activity.getWorkItems().size() > 0 || ComponentSyncUtil.getAccessibleFolders((IRemoteActivity)activity).size() != 0 || activity.getActivitySource().getModel().isActive((IRemoteActivity)activity);
            }
            if (element instanceof IOutgoingActivityFolder) {
                return true;
            }
            if (element instanceof IOutgoingRemoteChangeSummary) {
                return false;
            }
        }
        return hasChildren;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof PortsNode) {
            this.fInput = (PortsNode)newInput;
        }
    }

    public void dispose() {
    }
}

