/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.port;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentBaselineUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IActivityFolder;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IBaselineGroup;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IOutgoingRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteActivity;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IRemoteChangeSummary;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISubcomponentChange;
import com.ibm.team.filesystem.ui.changes.views.PatchedDirectory;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFolderHandle;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class CurrentPortOutputComparator
extends ViewerSorter {
    public int category(Object element) {
        if (element instanceof ISubcomponentChange) {
            return 0;
        }
        if (element instanceof IActivityFolder) {
            return 1;
        }
        if (element instanceof IFileSystemWorkItem) {
            return 2;
        }
        if (element instanceof PatchedDirectory) {
            return 3;
        }
        if (element instanceof IRemoteChangeSummary) {
            return ((IRemoteChangeSummary)element).getItem() instanceof IFolderHandle ? 40 : 41;
        }
        return 10;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (e1 instanceof IActivityFolder && e2 instanceof IActivityFolder) {
            IActivityFolder folder1 = (IActivityFolder)e1;
            IActivityFolder folder2 = (IActivityFolder)e2;
            return folder1.getPath().compareToIgnoreCase(folder2.getPath());
        }
        if (e1 instanceof IRemoteChangeSummary && e2 instanceof IRemoteChangeSummary) {
            IRemoteChangeSummary change1 = (IRemoteChangeSummary)e1;
            IRemoteChangeSummary change2 = (IRemoteChangeSummary)e2;
            return change1.getAfterPath().compareToIgnoreCase(change2.getAfterPath());
        }
        if (e1 instanceof IRemoteActivity && e2 instanceof IRemoteActivity) {
            IRemoteActivity activity1 = (IRemoteActivity)e1;
            IRemoteActivity activity2 = (IRemoteActivity)e2;
            return activity1.getActivitySource().getModel().compare(activity1, activity2);
        }
        if (e1 instanceof IOutgoingRemoteActivity && e2 instanceof IOutgoingRemoteActivity) {
            IOutgoingRemoteActivity activity1 = (IOutgoingRemoteActivity)e1;
            IOutgoingRemoteActivity activity2 = (IOutgoingRemoteActivity)e2;
            return activity1.getActivitySource().getModel().compare((IRemoteActivity)activity1, (IRemoteActivity)activity2);
        }
        if (e1 instanceof IBaselineGroup && e2 instanceof IBaselineGroup) {
            IBaselineGroup g1 = (IBaselineGroup)e1;
            IBaselineGroup g2 = (IBaselineGroup)e2;
            return ComponentBaselineUtil.compareTo((IBaselineGroup)g1, (IBaselineGroup)g2);
        }
        if (e1 instanceof ISubcomponentChange && e2 instanceof ISubcomponentChange) {
            ISubcomponentChange s1 = (ISubcomponentChange)e1;
            ISubcomponentChange s2 = (ISubcomponentChange)e2;
            IComponent c1 = s1.getComponent();
            IComponent c2 = s2.getComponent();
            if (!s1.getChangeType().equals((Object)s2.getChangeType())) {
                if (s1.getChangeType().equals((Object)ISubcomponentChange.ChangeType.Addition)) {
                    return -1;
                }
                return 1;
            }
            if (c1 != null && c2 != null) {
                return c1.getName().compareToIgnoreCase(c2.getName());
            }
            if (c1 != null) {
                return -1;
            }
            if (c2 != null) {
                return 1;
            }
            return s1.getComponentHandle().getItemId().compareTo((Object)s2.getComponentHandle().getItemId());
        }
        return super.compare(viewer, e1, e2);
    }
}

