/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.port;

import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.internal.filesystem.ui.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.actions.ActionGroup;

public class CurrentPortDetailsFilterActionGroup
extends ActionGroup
implements IPropertyChangeListener {
    private List<PreferenceAction> fActions;
    private PreferenceAction fShowResolvedPortChangesAction = new PreferenceAction(Messages.CurrentPortDetailsFilterActionGroup_SHOW_RESOLVED_PORT_CHANGES_ACTION_TEXT, "com.ibm.team.filesystem.ide.ui.show_resolved_port_changes");

    public CurrentPortDetailsFilterActionGroup() {
        this.fActions = new ArrayList<PreferenceAction>();
        this.fActions.add(this.fShowResolvedPortChangesAction);
        UiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void toggleDefaultFilterAction() {
        this.fShowResolvedPortChangesAction.run();
    }

    public void fillContextMenu(IMenuManager menu) {
        for (PreferenceAction action : this.fActions) {
            action.update();
            menu.add((IAction)action);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.update();
    }

    private void update() {
        for (PreferenceAction action : this.fActions) {
            action.update();
        }
    }

    public void dispose() {
        super.dispose();
        UiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private static class PreferenceAction
    extends Action {
        private final String fPrefName;
        private IPreferenceStore fStore = UiPlugin.getDefault().getPreferenceStore();

        PreferenceAction(String actionLabel, String prefName) {
            this.fPrefName = prefName;
            this.setText(actionLabel);
        }

        public void run() {
            boolean current = this.getCurrent();
            this.fStore.setValue(this.fPrefName, !current);
        }

        private boolean getCurrent() {
            return this.fStore.getBoolean(this.fPrefName);
        }

        public void update() {
            this.setChecked(this.getCurrent());
        }
    }
}

