/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.port;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AutoResolveChangeDetailAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.AutoResolveVersionableChangeAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.MarkChangeDetailAsResolvedAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.MarkChangeDetailAsUnresolvedAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.MarkVersionableChangeAsResolvedAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.MarkVersionableChangeAsUnresolvedAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.MergeChangeDetailAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.MergeVersionableChangeAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenVersionableChangeInCompareEditorAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.OpenVersionableChangeInExternalCompareAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.ResolveChangeDetailWithProposedAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.ResolveVersionableChangeWithProposedAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.UndoChangeDetailAction;
import com.ibm.team.filesystem.ide.ui.internal.actions.port.UndoVersionableChangeAction;
import com.ibm.team.filesystem.ide.ui.internal.util.ExternalCompareToolUtils;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IAbstractConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IFileSystemWorkItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.PortsCacheManager;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.AbstractChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ContentChangeDetailNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.CurrentPortNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.PortsNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode;
import com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeParentNode;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.filesystem.ui.changes.actions.OpenConflictInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenConflictInExternalCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenShareableInCompareAction;
import com.ibm.team.filesystem.ui.changes.actions.OpenShareableInExternalCompareAction;
import com.ibm.team.filesystem.ui.changes.configuration.ChangesSorter;
import com.ibm.team.filesystem.ui.changes.views.LocalSynchronizeDecorator;
import com.ibm.team.filesystem.ui.changes.views.LocalWorkspaceChangesViewLabelProvider;
import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.internal.filesystem.ui.ImagePool;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewer;
import com.ibm.team.internal.filesystem.ui.changes.CustomTreeViewerTooltipSupport;
import com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortDetailsComparator;
import com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortDetailsContentProvider;
import com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortDetailsDragAdapter;
import com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortDetailsDropTargetAdapter;
import com.ibm.team.internal.filesystem.ui.editors.port.SourceChangeSetControl;
import com.ibm.team.internal.filesystem.ui.util.MenuUtil;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.repository.rcp.ui.internal.menus.ActionExtContributionItem;
import com.ibm.team.repository.rcp.ui.internal.menus.IActionExt;
import com.ibm.team.repository.rcp.ui.internal.menus.PushAction;
import com.ibm.team.repository.rcp.ui.internal.viewers.MenuManagerWithDefaultAdditions;
import com.ibm.team.repository.rcp.ui.openactions.IWorkbenchRunnable;
import com.ibm.team.repository.rcp.ui.openactions.OpenAction;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CurrentPortDetailsControl {
    public static final String CONTROL_ID = "com.ibm.team.internal.filesystem.ui.editors.port.CurrentPortPage.CurrentPortDetailsControl";
    private IWorkspaceConnection fWorkspace;
    private IComponent fComponent;
    private IOperationRunner fOpRunner;
    private Shell fShell;
    private IWorkbenchPartSite fParentPartSite;
    private FormToolkit fToolkit;
    private Composite fMainComposite;
    private PortsNode fPortsNode;
    private SourceChangeSetControl fSourceChangeSetControl;
    private final int TREE_VIEWER_HINT = 100;
    private CustomTreeViewer fTreeViewer;
    private MenuManager fMenuManager;
    private final boolean fIncludeMergeButton = true;
    private final boolean fIncludeAutoResolveButton = false;
    private final boolean fIncludeResolveWithProposedButton = false;
    private final boolean fIncludeMarkAsResolvedButton = true;
    private final boolean fIncludeMarkAsUnresolvedButton = false;
    private final boolean fIncludeUndoChangesButton = false;
    private Button fMergeButton;
    private Button fAutoResolveButton;
    private Button fResolveWithProposedButton;
    private Button fMarkAsResolvedButton;
    private Button fMarkAsUnresolvedButton;
    private Button fUndoChangesButton;
    private Image fInfoImage;
    private Label fStatusLabel;
    private IPropertyChangeListener fPropertyChangeListener;
    private int fNumChangesResolved;
    private int fNumChangesUnresolved;
    private CurrentPortNode fLastPromptFromChangesDone;

    public CurrentPortDetailsControl(FormToolkit toolkit, IWorkbenchPartSite parentPartSite, Composite parent, IWorkspaceConnection workspace, IComponent component, IOperationRunner operationRunner) {
        Assert.isNotNull((Object)parentPartSite);
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)workspace);
        Assert.isNotNull((Object)component);
        Assert.isNotNull((Object)operationRunner);
        this.fToolkit = toolkit;
        this.fParentPartSite = parentPartSite;
        this.fShell = parent.getShell();
        this.fWorkspace = workspace;
        this.fComponent = component;
        this.fOpRunner = operationRunner;
        this.fMainComposite = this.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fMainComposite);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(this.fMainComposite);
        this.fSourceChangeSetControl = new SourceChangeSetControl(this.fToolkit, this.fParentPartSite, this.fMainComposite, this.fWorkspace, this.fComponent, this.fOpRunner);
        Composite treeComposite = this.createComposite(this.fMainComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)treeComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(treeComposite);
        Tree tree = this.createTree(treeComposite, 2818);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 100).span(1, 2).applyTo((Control)tree);
        this.fTreeViewer = new CustomTreeViewer(tree);
        LocalWorkspaceChangesViewLabelProvider labelProvider = new LocalWorkspaceChangesViewLabelProvider(true);
        LocalSynchronizeDecorator labelDecorator = new LocalSynchronizeDecorator(true);
        this.fTreeViewer.init(new DecoratingLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)labelDecorator));
        this.fTreeViewer.setContentProvider((IContentProvider)new CurrentPortDetailsContentProvider());
        this.fTreeViewer.setComparator((ViewerComparator)new CurrentPortDetailsComparator());
        this.fTreeViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        this.fTreeViewer.addOpenListener(this.getOpenListener());
        this.addTreeContextMenu();
        this.addTreeDragSupport();
        this.addTreeDropSupport();
        this.addTreeTooltipSupport();
        Composite buttonBar = this.createComposite(this.fMainComposite);
        buttonBar.setLayoutData((Object)new GridData(131072, 4, false, true));
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        this.fMergeButton = this.createPushButton(buttonBar, Messages.CurrentPortDetailsControl_MERGE_BUTTON_TEXT, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CurrentPortDetailsControl.this.doMerge();
            }
        });
        this.fMergeButton.setEnabled(false);
        this.fMarkAsResolvedButton = this.createPushButton(buttonBar, Messages.CurrentPortDetailsControl_MARK_AS_COMPLETE_BUTTON_TEXT, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CurrentPortDetailsControl.this.doMarkAsResolved();
            }
        });
        this.fMarkAsResolvedButton.setEnabled(false);
        Composite infoComposite = this.createComposite(this.fMainComposite);
        infoComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        infoComposite.setLayout((Layout)new GridLayout(2, false));
        Label infoIcon = new Label(infoComposite, 0);
        this.fInfoImage = ImagePool.INFO_OBJ.createImage();
        infoIcon.setImage(this.fInfoImage);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(1, 1).indent(-7, 0).applyTo((Control)infoIcon);
        this.fStatusLabel = this.createLabel(infoComposite, this.getStatusLabelText());
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(1, 1).indent(-2, 0).applyTo((Control)this.fStatusLabel);
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("com.ibm.team.filesystem.ide.ui.show_resolved_port_changes".equals(event.getProperty()) && CurrentPortDetailsControl.this.fShell != null) {
                    CurrentPortDetailsControl.this.fShell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CurrentPortDetailsControl.this.requestRefresh();
                        }
                    });
                }
            }
        };
        prefStore.addPropertyChangeListener(this.fPropertyChangeListener);
        this.requestRefresh();
    }

    public Composite getComposite() {
        return this.fMainComposite;
    }

    public CustomTreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    public void requestRefresh() {
        CurrentPortNode newCurrentPort;
        PortsNode oldPortsNode = this.getPortsNode();
        PortsNode newPortNode = PortsCacheManager.getInstance().getPortNode(this.fWorkspace.teamRepository(), (IWorkspaceHandle)this.fWorkspace.getResolvedWorkspace(), (IComponentHandle)this.fComponent);
        boolean currentPortChanged = false;
        CurrentPortNode oldCurrentPort = oldPortsNode == null ? null : oldPortsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode();
        CurrentPortNode currentPortNode = newCurrentPort = newPortNode == null ? null : newPortNode.getChildCurrentPortContainerNode().getChildCurrentPortNode();
        if (oldCurrentPort == null && newCurrentPort != null || oldCurrentPort != null && newCurrentPort == null || oldCurrentPort != null && newCurrentPort != null && !oldCurrentPort.equals((Object)newCurrentPort)) {
            currentPortChanged = true;
        }
        this.setPortsNode(newPortNode);
        this.fSourceChangeSetControl.requestRefresh();
        this.refreshTreeViewer();
        if (currentPortChanged) {
            this.performInitialTreeExpansion();
        }
        this.updateChangeInformation();
        this.refreshStatusLabel();
        this.updateEnablement();
        this.promptIfAllChangesAreDone();
    }

    public void setEnabled(boolean enabled) {
        if (this.fTreeViewer != null && !this.fTreeViewer.getTree().isDisposed()) {
            this.fTreeViewer.getTree().setEnabled(enabled);
        }
        if (this.fMergeButton != null && !this.fMergeButton.isDisposed()) {
            this.fMergeButton.setEnabled(enabled);
        }
        if (this.fAutoResolveButton != null && !this.fAutoResolveButton.isDisposed()) {
            this.fAutoResolveButton.setEnabled(enabled);
        }
        if (this.fResolveWithProposedButton != null && !this.fResolveWithProposedButton.isDisposed()) {
            this.fResolveWithProposedButton.setEnabled(enabled);
        }
        if (this.fMarkAsResolvedButton != null && !this.fMarkAsResolvedButton.isDisposed()) {
            this.fMarkAsResolvedButton.setEnabled(enabled);
        }
        if (this.fMarkAsUnresolvedButton != null && !this.fMarkAsUnresolvedButton.isDisposed()) {
            this.fMarkAsUnresolvedButton.setEnabled(enabled);
        }
        if (this.fUndoChangesButton != null && !this.fUndoChangesButton.isDisposed()) {
            this.fUndoChangesButton.setEnabled(enabled);
        }
        if (enabled) {
            this.updateEnablement();
        }
    }

    public boolean setInitialFocus() {
        return this.fTreeViewer.getControl().setFocus();
    }

    public String getStatusLabelText() {
        int totalNumChangeDetails;
        String statusText = "";
        PortsNode portsNode = this.getPortsNode();
        statusText = portsNode != null && portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode() != null ? ((totalNumChangeDetails = this.fNumChangesResolved + this.fNumChangesUnresolved) == 0 ? Messages.CurrentPortDetailsControl_STATUS_TEXT_NO_CHANGES_TO_MERGE : NLS.bind((String)Messages.CurrentPortDetailsControl_STATUS_TEXT_CHANGES_TO_MERGE, (Object)this.fNumChangesResolved, (Object)totalNumChangeDetails)) : Messages.CurrentPortDetailsControl_STATUS_TEXT_NO_CHANGES_TO_MERGE;
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        if (prefStore != null && prefStore.contains("com.ibm.team.filesystem.ide.ui.show_resolved_port_changes") && !prefStore.getBoolean("com.ibm.team.filesystem.ide.ui.show_resolved_port_changes")) {
            statusText = String.valueOf(statusText) + Messages.CurrentPortDetailsControl_STATUS_TEXT_HIDING_DONE;
        }
        return statusText;
    }

    public void dispose() {
        if (this.fInfoImage != null && !this.fInfoImage.isDisposed()) {
            this.fInfoImage.dispose();
            this.fInfoImage = null;
        }
        if (this.fMainComposite != null && !this.fMainComposite.isDisposed()) {
            this.fMainComposite.dispose();
            this.fMainComposite = null;
        }
        if (this.fPropertyChangeListener != null) {
            UiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    private void doMerge() {
        IStructuredSelection ss = this.getCurrentTreeSelection();
        if (MergeVersionableChangeAction.isValidSelection((ISelection)ss)) {
            MergeVersionableChangeAction.mergeVersionableChange(ss, this.fParentPartSite.getPage(), this.fShell, this.fOpRunner);
        } else if (MergeChangeDetailAction.isValidSelection((ISelection)ss)) {
            MergeChangeDetailAction.mergeChangeDetail(ss, this.fParentPartSite.getPage(), this.fShell, this.fOpRunner);
        }
    }

    private boolean isValidSelectionForMerge() {
        IStructuredSelection ss = this.getCurrentTreeSelection();
        return MergeVersionableChangeAction.isValidSelection((ISelection)ss) || MergeChangeDetailAction.isValidSelection((ISelection)ss);
    }

    private void doAutoResolve() {
        IStructuredSelection ss = this.getCurrentTreeSelection();
        if (AutoResolveVersionableChangeAction.isValidSelection((ISelection)ss)) {
            AutoResolveVersionableChangeAction.autoResolveVersionableChange(ss, this.fParentPartSite.getPage(), this.fShell, this.fOpRunner);
        } else if (AutoResolveChangeDetailAction.isValidSelection((ISelection)ss)) {
            AutoResolveChangeDetailAction.autoResolveChangeDetail(ss, this.fParentPartSite.getPage(), this.fShell, this.fOpRunner);
        }
    }

    private boolean isValidSelectionForAutoResolve() {
        IStructuredSelection ss = this.getCurrentTreeSelection();
        return AutoResolveVersionableChangeAction.isValidSelection((ISelection)ss) || AutoResolveChangeDetailAction.isValidSelection((ISelection)ss);
    }

    private void doResolveWithProposed() {
        IStructuredSelection ss = this.getCurrentTreeSelection();
        if (ResolveVersionableChangeWithProposedAction.isValidSelection((ISelection)ss)) {
            ResolveVersionableChangeWithProposedAction.resolveVersionableChangeWithProposed(ss, this.fParentPartSite.getPage(), this.fShell, this.fOpRunner);
        } else if (ResolveChangeDetailWithProposedAction.isValidSelection((ISelection)ss)) {
            ResolveChangeDetailWithProposedAction.resolveChangeDetailWithProposed(ss, this.fParentPartSite.getPage(), this.fShell, this.fOpRunner);
        }
    }

    private boolean isValidSelectionForResolveWithProposed() {
        IStructuredSelection ss = this.getCurrentTreeSelection();
        return ResolveVersionableChangeWithProposedAction.isValidSelection((ISelection)ss) || ResolveChangeDetailWithProposedAction.isValidSelection((ISelection)ss);
    }

    private void doMarkAsResolved() {
        IStructuredSelection ss = this.getCurrentTreeSelection();
        if (MarkVersionableChangeAsResolvedAction.isValidSelection((ISelection)ss)) {
            MarkVersionableChangeAsResolvedAction.markVersionableChangeAsResolved(ss, null, this.fParentPartSite.getPage(), this.fShell, this.fOpRunner);
        } else if (MarkChangeDetailAsResolvedAction.isValidSelection((ISelection)ss)) {
            MarkChangeDetailAsResolvedAction.markChangeDetailAsResolved(ss, null, this.fParentPartSite.getPage(), this.fShell, this.fOpRunner);
        }
    }

    private boolean isValidSelectionForMarkAsResolved() {
        IStructuredSelection ss = this.getCurrentTreeSelection();
        return MarkVersionableChangeAsResolvedAction.isValidSelection((ISelection)ss) || MarkChangeDetailAsResolvedAction.isValidSelection((ISelection)ss);
    }

    private void doMarkAsUnresolved() {
        IStructuredSelection ss = this.getCurrentTreeSelection();
        if (MarkVersionableChangeAsUnresolvedAction.isValidSelection((ISelection)ss)) {
            MarkVersionableChangeAsUnresolvedAction.markVersionableChangeAsUnresolved(ss, null, this.fParentPartSite.getPage(), this.fShell, this.fOpRunner);
        } else if (MarkChangeDetailAsUnresolvedAction.isValidSelection((ISelection)ss)) {
            MarkChangeDetailAsUnresolvedAction.markChangeDetailAsUnresolved(ss, null, this.fParentPartSite.getPage(), this.fShell, this.fOpRunner);
        }
    }

    private boolean isValidSelectionForMarkAsUnresolved() {
        IStructuredSelection ss = this.getCurrentTreeSelection();
        return MarkVersionableChangeAsUnresolvedAction.isValidSelection((ISelection)ss) || MarkChangeDetailAsUnresolvedAction.isValidSelection((ISelection)ss);
    }

    private void doUndoChanges() {
        IStructuredSelection ss = this.getCurrentTreeSelection();
        if (UndoVersionableChangeAction.isValidSelection((ISelection)ss)) {
            UndoVersionableChangeAction.undoVersionableChange(ss, this.fShell, this.fOpRunner);
        } else if (UndoChangeDetailAction.isValidSelection((ISelection)ss)) {
            UndoChangeDetailAction.undoChangeDetail(ss, this.fShell, this.fOpRunner);
        }
    }

    private boolean isValidSelectionForUndo() {
        IStructuredSelection ss = this.getCurrentTreeSelection();
        return UndoVersionableChangeAction.isValidSelection((ISelection)ss) || UndoChangeDetailAction.isValidSelection((ISelection)ss);
    }

    private synchronized PortsNode getPortsNode() {
        return this.fPortsNode;
    }

    private synchronized void setPortsNode(PortsNode portsNode) {
        this.fPortsNode = portsNode;
    }

    private IStructuredSelection getCurrentTreeSelection() {
        return (IStructuredSelection)this.fTreeViewer.getSelection();
    }

    private void refreshTreeViewer() {
        if (this.fTreeViewer.getTree() != null && !this.fTreeViewer.getTree().isDisposed()) {
            Object[] expandedElements = this.fTreeViewer.getExpandedElements();
            IStructuredSelection selection = this.getCurrentTreeSelection();
            this.fTreeViewer.getTree().setRedraw(false);
            this.fTreeViewer.setInput(this.getTreeInput());
            this.fTreeViewer.setExpandedElements(expandedElements);
            this.fTreeViewer.getTree().setRedraw(true);
            if (!selection.isEmpty()) {
                this.fTreeViewer.reveal(selection.getFirstElement());
                this.fTreeViewer.setSelection((ISelection)selection, true);
            }
        }
    }

    private void performInitialTreeExpansion() {
        if (this.fTreeViewer.getTree() != null && !this.fTreeViewer.getTree().isDisposed()) {
            this.fTreeViewer.expandToLevel(3);
        }
    }

    private CurrentPortDetailsContentProviderInput getTreeInput() {
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        boolean showResolvedPortChanges = true;
        if (prefStore.contains("com.ibm.team.filesystem.ide.ui.show_resolved_port_changes")) {
            showResolvedPortChanges = UiPlugin.getDefault().getPreferenceStore().getBoolean("com.ibm.team.filesystem.ide.ui.show_resolved_port_changes");
        }
        CurrentPortDetailsContentProviderInput input = new CurrentPortDetailsContentProviderInput(this.getPortsNode(), showResolvedPortChanges);
        return input;
    }

    private void updateChangeInformation() {
        PortsNode portsNode = this.getPortsNode();
        if (portsNode != null && portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode() != null) {
            int[] resolvedAndUnresolved = new int[2];
            CurrentPortNode currentPort = portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode();
            for (VersionableChangeParentNode parentNode : currentPort.getPortChanges().getChildNodes()) {
                for (VersionableChangeNode versionableChangeNode : parentNode.getChildNodes()) {
                    this.computeResolvedAndUnresolved(versionableChangeNode, resolvedAndUnresolved);
                }
            }
            this.fNumChangesResolved = resolvedAndUnresolved[0];
            this.fNumChangesUnresolved = resolvedAndUnresolved[1];
        } else {
            this.fNumChangesResolved = 0;
            this.fNumChangesUnresolved = 0;
        }
    }

    private void computeResolvedAndUnresolved(VersionableChangeNode versionableChangeNode, int[] resolveAndUnresolved) {
        if (versionableChangeNode.isAdded() || versionableChangeNode.isDeleted()) {
            if (versionableChangeNode.isResolved()) {
                resolveAndUnresolved[0] = resolveAndUnresolved[0] + 1;
            } else {
                resolveAndUnresolved[1] = resolveAndUnresolved[1] + 1;
            }
        }
        for (AbstractChangeDetailNode changeDetailNode : versionableChangeNode.getChildChangeDetailNodes()) {
            if (changeDetailNode.isResolved()) {
                resolveAndUnresolved[0] = resolveAndUnresolved[0] + 1;
                continue;
            }
            resolveAndUnresolved[1] = resolveAndUnresolved[1] + 1;
        }
        for (VersionableChangeNode childNode : versionableChangeNode.getChildVersionableChangeNodes()) {
            this.computeResolvedAndUnresolved(childNode, resolveAndUnresolved);
        }
    }

    private void promptIfAllChangesAreDone() {
        PortsNode portsNode = this.getPortsNode();
        if (this.fNumChangesUnresolved == 0 && portsNode != null && portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode() != null) {
            final CurrentPortNode currentPort = portsNode.getChildCurrentPortContainerNode().getChildCurrentPortNode();
            if (!currentPort.equals((Object)this.fLastPromptFromChangesDone)) {
                this.fLastPromptFromChangesDone = currentPort;
                if (this.fShell != null) {
                    this.fShell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String dialogTitle = Messages.CurrentPortDetailsControl_MERGE_COMPLETE_DIALOG_TITLE;
                            IChangeSet targetChangeSet = currentPort.getPortTargetChangeSet();
                            if (targetChangeSet != null && targetChangeSet.changes().isEmpty()) {
                                String dialogMessage = Messages.CurrentPortDetailsControl_MERGE_COMPLETE_WITH_ALL_NO_OPS_DIALOG_MESSAGE;
                                MessageDialog.openWarning((Shell)CurrentPortDetailsControl.this.fShell, (String)dialogTitle, (String)dialogMessage);
                            } else {
                                String dialogMessage = Messages.CurrentPortDetailsControl_MERGE_COMPLETE_DIALOG_MESSAGE;
                                MessageDialog.openInformation((Shell)CurrentPortDetailsControl.this.fShell, (String)dialogTitle, (String)dialogMessage);
                            }
                        }
                    });
                }
            }
        } else {
            this.fLastPromptFromChangesDone = null;
        }
    }

    private void refreshStatusLabel() {
        if (this.fStatusLabel != null && !this.fStatusLabel.isDisposed()) {
            this.fStatusLabel.setText(this.getStatusLabelText());
        }
    }

    private void addTreeContextMenu() {
        this.fMenuManager = new MenuManagerWithDefaultAdditions(){

            protected boolean allowItem(IContributionItem itemToAdd) {
                if ("org.eclipse.debug.ui.contextualLaunch.run.submenu".equals(itemToAdd.getId())) {
                    return false;
                }
                if ("org.eclipse.debug.ui.contextualLaunch.debug.submenu".equals(itemToAdd.getId())) {
                    return false;
                }
                if ("org.eclipse.debug.ui.contextualLaunch.profile.submenu".equals(itemToAdd.getId())) {
                    return false;
                }
                return super.allowItem(itemToAdd);
            }
        };
        ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)this.fMenuManager);
        final Menu menu = this.fMenuManager.createContextMenu((Control)this.fTreeViewer.getTree());
        this.fTreeViewer.getTree().setMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem menuItem = null;
                boolean useExternalCompareTool = ExternalCompareToolUtils.shouldUseExternalCompareTool();
                menuItem = useExternalCompareTool ? MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.OpenInExternalCompareAction") : MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.OpenAction");
                if (menuItem == null) {
                    menuItem = useExternalCompareTool ? MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.OpenConflictInExternalCompareAction") : MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.ui.changes.actions.conflict.OpenAction");
                }
                if (menuItem == null) {
                    menuItem = useExternalCompareTool ? MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode.actions.OpenContentChangeInExternalCompareAction") : MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.VersionableChangeNode.actions.OpenContentChangeInCompareEditorAction");
                }
                if (menuItem == null) {
                    menuItem = useExternalCompareTool ? MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ContentChangeDetailNode.actions.OpenContentChangeInExternalCompareAction") : MenuUtil.findItemForAction(menu, "com.ibm.team.filesystem.rcp.core.internal.changes.ports.model.ContentChangeDetailNode.actions.OpenContentChangeInCompareEditorAction");
                }
                if (menuItem != null && !menuItem.isEnabled()) {
                    menuItem = null;
                }
                menu.setDefaultItem(menuItem);
            }
        });
        PushAction expandChildrenContextMenuAction = new PushAction(Messages.CurrentPortDetailsControl_EXPAND_CHILDREN_ACTION_LABEL, new Runnable(){

            @Override
            public void run() {
                CurrentPortDetailsControl.this.expandChildrenContextAction();
            }
        });
        this.fMenuManager.add((IContributionItem)new ActionExtContributionItem((IActionExt)expandChildrenContextMenuAction));
        this.fParentPartSite.registerContextMenu(CONTROL_ID, this.fMenuManager, (ISelectionProvider)this.fTreeViewer);
    }

    private void expandChildrenContextAction() {
        if (this.fTreeViewer != null) {
            for (Object selection : this.getCurrentTreeSelection().toList()) {
                this.fTreeViewer.expandToLevel(selection, -1);
            }
        }
    }

    private void addTreeDragSupport() {
        this.fTreeViewer.addDragSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new CurrentPortDetailsDragAdapter(this.fTreeViewer));
    }

    private void addTreeDropSupport() {
        this.fTreeViewer.addDropSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new CurrentPortDetailsDropTargetAdapter(this));
    }

    private void addTreeTooltipSupport() {
        new CustomTreeViewerTooltipSupport(this.fTreeViewer, true, true){

            protected Object doResolve(Object element) {
                if (DomainAdapterUtils.getDomainAdapter((Object)element) == null) {
                    if (element instanceof IModelAccessor) {
                        return ((IModelAccessor)element).getModelInstance();
                    }
                    return null;
                }
                return super.doResolve(element);
            }

            protected void hoverToolTipOpened() {
                this.setOpenable(false);
            }

            protected void openRequested(Object element) {
            }
        };
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CurrentPortDetailsControl.this.updateEnablement();
            }
        };
    }

    private IOpenListener getOpenListener() {
        return new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection structuredSelection;
                List elements;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (elements = (structuredSelection = (IStructuredSelection)selection).toList()) != null && elements.size() > 0) {
                    CurrentPortDetailsControl.this.handleOpenTreeElements(elements);
                }
            }
        };
    }

    private void handleOpenTreeElements(List elements) {
        for (Object element : elements) {
            IWorkbenchRunnable genericOpenAction;
            ILocalChange change;
            AbstractActionDelegate actionDelegate = null;
            boolean useExternalTool = ExternalCompareToolUtils.shouldUseExternalCompareTool(element);
            if (element instanceof ILocalChange && OpenShareableInCompareAction.isOpenable(change = (ILocalChange)element)) {
                if (useExternalTool) {
                    actionDelegate = new OpenShareableInExternalCompareAction();
                } else {
                    OpenShareableInCompareAction action = new OpenShareableInCompareAction(this.fParentPartSite.getPage(), (ISelection)this.getCurrentTreeSelection());
                    action.run();
                    continue;
                }
            }
            if (element instanceof IConflictItem && OpenConflictInCompareAction.isOpenable((IAbstractConflictItem)((IConflictItem)element))) {
                if (useExternalTool) {
                    actionDelegate = new OpenConflictInExternalCompareAction();
                } else {
                    OpenConflictInCompareAction action = new OpenConflictInCompareAction(this.fParentPartSite.getPage(), this.getCurrentTreeSelection());
                    action.run();
                    continue;
                }
            }
            if (element instanceof VersionableChangeNode || element instanceof ContentChangeDetailNode) {
                actionDelegate = useExternalTool ? new OpenVersionableChangeInExternalCompareAction() : new OpenVersionableChangeInCompareEditorAction();
            }
            if (actionDelegate != null) {
                StructuredSelection ss = new StructuredSelection(element);
                actionDelegate.init(this.fParentPartSite.getPart());
                Action tempAction = new Action(){};
                actionDelegate.selectionChanged((IAction)tempAction, (ISelection)ss);
                if (!tempAction.isEnabled()) continue;
                actionDelegate.run(this.fShell, this.fParentPartSite.getPage(), (IStructuredSelection)ss);
                continue;
            }
            if (element instanceof IFileSystemWorkItem) {
                IFileSystemWorkItem workItem = (IFileSystemWorkItem)element;
                element = workItem.getWorkItem();
            }
            if ((genericOpenAction = OpenAction.getActionFor(element)) != null) {
                genericOpenAction.run(this.fParentPartSite.getShell(), this.fParentPartSite.getPage(), (IStructuredSelection)new StructuredSelection(element));
                continue;
            }
            if (this.fTreeViewer.getExpandedState(element)) {
                this.fTreeViewer.collapseToLevel(element, -1);
                continue;
            }
            this.fTreeViewer.expandToLevel(element, 1);
            Object firstChange = ChangesSorter.findFirstChange(this.fTreeViewer, element, null, true);
            if (firstChange == null) continue;
            this.fTreeViewer.reveal(element);
        }
    }

    private void updateEnablement() {
        if (this.fMergeButton != null && !this.fMergeButton.isDisposed()) {
            this.fMergeButton.setEnabled(this.isValidSelectionForMerge());
        }
        if (this.fAutoResolveButton != null && !this.fAutoResolveButton.isDisposed()) {
            this.fAutoResolveButton.setEnabled(this.isValidSelectionForAutoResolve());
        }
        if (this.fResolveWithProposedButton != null && !this.fResolveWithProposedButton.isDisposed()) {
            this.fResolveWithProposedButton.setEnabled(this.isValidSelectionForResolveWithProposed());
        }
        if (this.fMarkAsResolvedButton != null && !this.fMarkAsResolvedButton.isDisposed()) {
            this.fMarkAsResolvedButton.setEnabled(this.isValidSelectionForMarkAsResolved());
        }
        if (this.fMarkAsUnresolvedButton != null && !this.fMarkAsUnresolvedButton.isDisposed()) {
            this.fMarkAsUnresolvedButton.setEnabled(this.isValidSelectionForMarkAsUnresolved());
        }
        if (this.fUndoChangesButton != null && !this.fUndoChangesButton.isDisposed()) {
            this.fUndoChangesButton.setEnabled(this.isValidSelectionForUndo());
        }
    }

    private Composite createComposite(Composite parent) {
        if (this.fToolkit != null) {
            return this.fToolkit.createComposite(parent);
        }
        return new Composite(parent, 0);
    }

    private Tree createTree(Composite parent, int style) {
        if (this.fToolkit != null) {
            return this.fToolkit.createTree(parent, style);
        }
        return new Tree(parent, style);
    }

    private Label createLabel(Composite parent, String text) {
        if (this.fToolkit != null) {
            return this.fToolkit.createLabel(parent, text);
        }
        Label label = new Label(parent, 0);
        if (text != null) {
            label.setText(text);
        }
        return label;
    }

    private Button createPushButton(Composite parent, String text, SelectionListener listener) {
        return this.createButton(parent, text, listener, 8);
    }

    private Button createButton(Composite parent, String text, SelectionListener listener, int style) {
        Button button;
        if (this.fToolkit != null) {
            button = this.fToolkit.createButton(parent, text, style);
        } else {
            button = new Button(parent, 8);
            button.setText(text);
        }
        button.addSelectionListener(listener);
        int minX = Math.max(button.computeSize((int)-1, (int)-1, (boolean)true).x, LayoutConstants.getMinButtonSize().x);
        GridDataFactory.fillDefaults().align(4, 128).hint(minX, -1).applyTo((Control)button);
        return button;
    }

    public class CurrentPortDetailsContentProviderInput {
        private PortsNode fPortsNode;
        private boolean fShowResolvedChanges;

        public CurrentPortDetailsContentProviderInput(PortsNode portNode, boolean showResolvedChanges) {
            this.fPortsNode = portNode;
            this.fShowResolvedChanges = showResolvedChanges;
        }

        public PortsNode getPortsNode() {
            return this.fPortsNode;
        }

        public boolean isShowResolvedChanges() {
            return this.fShowResolvedChanges;
        }
    }
}

