/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.hooks;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.ui.inputs.RepositoryFilesViewInput;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.web.common.AbstractRichClientHook;
import com.ibm.team.internal.filesystem.ui.web.common.EmbeddedBrowser;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import com.ibm.team.repository.rcp.ui.parts.Parts;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;

public class ShowRepositoryFilesViewHook
extends AbstractRichClientHook {
    public static final String NAME = "showRepositoryFilesView";

    public ShowRepositoryFilesViewHook(ITeamRepository repo, IWorkbenchPartSite partSite, IOperationRunner operationRunner) {
        super(repo, partSite, operationRunner);
    }

    public void run(EmbeddedBrowser browser, String name, EmbeddedBrowser.BrowserArguments callArgs) {
        final Map<String, IItemHandle> context = this.getContext(callArgs, 0);
        final Shell shell = this.getWorkbenchPartSite().getShell();
        this.getOperationRunner().enqueue(Messages.ShowRepositoryFilesViewHook_BASELINE_JOB_NAME, (Operation)new RepositoryOperation(this.getRepository()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                ShowRepositoryFilesViewHook.this.showBaselineInRepositoryFilesView(context, shell, monitor);
            }
        });
    }

    private void showBaselineInRepositoryFilesView(Map<String, IItemHandle> context, final Shell shell, IProgressMonitor monitor) throws TeamRepositoryException {
        if (shell == null || shell.isDisposed()) {
            return;
        }
        ItemNamespace namespace = this.getItemNamespace(context, monitor);
        if (namespace == null) {
            String message = "Show Repository Files: The context argument is missing.";
            StatusUtil.log((Object)this, (int)4, (String)message);
            return;
        }
        final RepositoryFilesViewInput input = new RepositoryFilesViewInput(namespace);
        shell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!shell.isDisposed()) {
                    Parts.openView((IWorkbenchPage)ShowRepositoryFilesViewHook.this.getWorkbenchPartSite().getPage(), (Object)input, (String)"com.ibm.team.filesystem.history.FileSystemView");
                }
            }
        });
    }

    @Override
    public void run(EmbeddedBrowser browser, String name, EmbeddedBrowser.BrowserArguments callArgs, EmbeddedBrowser.EmbeddedFunctionCallback callback) {
        this.run(browser, name, callArgs);
    }
}

