/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.hooks;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.ChangesViewConverter;
import com.ibm.team.internal.filesystem.ui.views.structuralchanges.SnapshotCompareInput;
import com.ibm.team.internal.filesystem.ui.web.common.AbstractRichClientHook;
import com.ibm.team.internal.filesystem.ui.web.common.EmbeddedBrowser;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class CompareBaselinesHook
extends AbstractRichClientHook {
    public static final String NAME = "compareBaselines";

    public CompareBaselinesHook(ITeamRepository repo, IWorkbenchPartSite partSite, IOperationRunner operationRunner) {
        super(repo, partSite, operationRunner);
    }

    public void run(EmbeddedBrowser browser, String name, EmbeddedBrowser.BrowserArguments callArgs) {
        final Map<String, IItemHandle> context1 = this.getContext(callArgs, 0);
        final Map<String, IItemHandle> context2 = this.getContext(callArgs, 1);
        this.getOperationRunner().enqueue(Messages.CompareBaselinesHook_COMPARE_JOB_NAME, (Operation)new RepositoryOperation(this.getRepository()){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, OperationFailedException {
                CompareBaselinesHook.this.doCompare(context1, context2, monitor);
            }
        });
    }

    protected void doCompare(Map<String, IItemHandle> context1, Map<String, IItemHandle> context2, IProgressMonitor monitor) throws TeamRepositoryException {
        final ItemNamespace namespace1 = this.getItemNamespace(context1, monitor);
        final ItemNamespace namespace2 = this.getItemNamespace(context2, monitor);
        if (namespace1 == null || namespace2 == null) {
            String message = namespace1 == null && namespace2 == null ? "Compare baselines: Both the first and second context arguments are missing." : (namespace1 == null ? "Compare baselines: The first context argument is missing." : "Compare baselines: The second context argument is missing.");
            StatusUtil.log((Object)this, (int)4, (String)message);
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                ChangesViewConverter.openChangeExplorer(CompareBaselinesHook.this.getWorkbenchPartSite().getPage(), SnapshotCompareInput.create(namespace1, namespace2));
            }
        });
    }

    @Override
    public void run(EmbeddedBrowser browser, String name, EmbeddedBrowser.BrowserArguments callArgs, EmbeddedBrowser.EmbeddedFunctionCallback callback) {
        this.run(browser, name, callArgs);
    }
}

