/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.hooks;

import com.ibm.team.filesystem.ui.WORKSPACES_OR_STREAMS;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialog;
import com.ibm.team.filesystem.ui.WorkspaceAndStreamSelectionDialogOptions;
import com.ibm.team.filesystem.ui.wrapper.AbstractPlaceWrapper;
import com.ibm.team.internal.filesystem.ui.web.common.EmbeddedBrowser;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import org.eclipse.ui.IWorkbenchPartSite;

public class AddStreamsHook
extends EmbeddedBrowser.EmbeddedFunction {
    public static final String NAME = "addStreams";
    private ITeamRepository fRepo;
    private final IWorkbenchPartSite fPartSite;
    private boolean forceRepo = true;
    private boolean allowMultiSelect = true;

    public AddStreamsHook(ITeamRepository repo, IComponent component, IWorkbenchPartSite site) {
        this.fRepo = repo;
        this.fPartSite = site;
    }

    public AddStreamsHook(ITeamRepository repo, IWorkbenchPartSite site, boolean allowMultiSelect, boolean forceRepo) {
        this(repo, null, site);
        this.forceRepo = forceRepo;
        this.allowMultiSelect = allowMultiSelect;
    }

    @Override
    protected void setRepository(ITeamRepository repository) {
        this.fRepo = repository;
    }

    public JSONObject run(EmbeddedBrowser browser, String name, EmbeddedBrowser.BrowserArguments callArgs) {
        ArrayList<IWorkspaceHandle> streamsToIgnore = null;
        JSONObject existingStreams = callArgs.getUntyped(0, new JSONObject());
        if (!existingStreams.isEmpty()) {
            streamsToIgnore = new ArrayList<IWorkspaceHandle>();
            for (Object o : existingStreams.keySet()) {
                String streamId = (String)o;
                IWorkspaceHandle handle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(UUID.valueOf((String)streamId), null);
                streamsToIgnore.add(handle);
            }
        }
        WorkspaceAndStreamSelectionDialogOptions options = new WorkspaceAndStreamSelectionDialogOptions().setShowWorkspaces(WORKSPACES_OR_STREAMS.STREAMS).setShowWorkspacesRadio(true).setToIgnore(streamsToIgnore).setForceRepo(this.forceRepo).setAllowMultiSelect(this.allowMultiSelect).setTarget(null).setComponents(null).setExactOwnerName(null);
        AbstractPlaceWrapper[] streamWrappers = WorkspaceAndStreamSelectionDialog.getWorkspacesOrStreams2(this.fPartSite.getShell(), this.fRepo, options);
        JSONArray streamIds = new JSONArray();
        if (streamWrappers != null) {
            AbstractPlaceWrapper[] abstractPlaceWrapperArray = streamWrappers;
            int n = streamWrappers.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractPlaceWrapper wrapper = abstractPlaceWrapperArray[n2];
                streamIds.add((Object)wrapper.getWorkspace().getItemId().getUuidValue());
                ++n2;
            }
        }
        JSONObject r = new JSONObject();
        r.put((Object)"displayDispatched", (Object)true);
        r.put((Object)"streamUUIDs", (Object)streamIds);
        return r;
    }

    @Override
    public void run(EmbeddedBrowser browser, String name, EmbeddedBrowser.BrowserArguments callArgs, EmbeddedBrowser.EmbeddedFunctionCallback callback) {
        try {
            JSONObject result = this.run(browser, name, callArgs);
            callback.setResult(result, null);
        }
        catch (Exception e) {
            callback.setResult(null, e);
        }
    }
}

