/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines;

import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ISubcomponentChange;
import com.ibm.team.filesystem.ui.wrapper.AbstractWrapper;
import com.ibm.team.filesystem.ui.wrapper.ComponentWrapper;
import com.ibm.team.filesystem.ui.wrapper.WorkspaceComponentWrapper;
import com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesEditor;
import com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesEditorInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IWorkspace;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class OpenGraphicalBaselinesAction
extends AbstractActionDelegate {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        boolean isEnabled = false;
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            ITeamRepository repo = null;
            IComponent component = null;
            Object[] objectArray = ss.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractWrapper wrapper;
                Object o = objectArray[n2];
                ITeamRepository currentRepo = null;
                IComponent currentComponent = null;
                if (o instanceof WorkspaceComponentWrapper) {
                    wrapper = (WorkspaceComponentWrapper)o;
                    currentRepo = ((WorkspaceComponentWrapper)wrapper).getRepository();
                    currentComponent = ((WorkspaceComponentWrapper)wrapper).getComponent();
                    if (currentComponent == null) {
                        action.setEnabled(false);
                        return;
                    }
                } else if (o instanceof IComponentSyncContext) {
                    IComponentSyncContext syncContext = (IComponentSyncContext)o;
                    currentRepo = syncContext.localTeamRepository();
                    currentComponent = syncContext.getComponent();
                } else if (o instanceof ISubcomponentChange) {
                    ISubcomponentChange componentNode = (ISubcomponentChange)o;
                    currentRepo = (ITeamRepository)componentNode.getRemoteActivity().getChangeSetHandle().getOrigin();
                    currentComponent = componentNode.getComponent();
                    if (componentNode.isComponentInaccessible() || componentNode.isComponentMissingFromWorkspace()) {
                        action.setEnabled(false);
                        return;
                    }
                } else if (o instanceof ComponentWrapper) {
                    wrapper = (ComponentWrapper)((Object)o);
                    currentRepo = ((ComponentWrapper)wrapper).getRepository();
                    currentComponent = ((ComponentWrapper)wrapper).getComponent();
                }
                if (repo == null) {
                    repo = currentRepo;
                } else if (repo != null && !repo.getId().equals((Object)currentRepo.getId())) {
                    action.setEnabled(false);
                    return;
                }
                if (component == null) {
                    component = currentComponent;
                } else if (component != null && !currentComponent.sameItemId((IItemHandle)component)) {
                    action.setEnabled(false);
                    return;
                }
                ++n2;
            }
            if (repo != null && component != null) {
                isEnabled = true;
            }
        }
        action.setEnabled(isEnabled);
    }

    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        ITeamRepository repo = null;
        IComponent component = null;
        HashMap<UUID, IWorkspace> workspaces = new HashMap<UUID, IWorkspace>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkspaceConnection wc;
            AbstractWrapper wrapper;
            Object o = objectArray[n2];
            ITeamRepository currentRepo = null;
            IComponent currentComponent = null;
            IWorkspace workspace = null;
            if (o instanceof WorkspaceComponentWrapper) {
                wrapper = (WorkspaceComponentWrapper)o;
                currentRepo = ((WorkspaceComponentWrapper)wrapper).getRepository();
                workspace = ((WorkspaceComponentWrapper)wrapper).getWorkspace();
                currentComponent = ((WorkspaceComponentWrapper)wrapper).getComponent();
                if (currentComponent == null) {
                    break;
                }
            } else if (o instanceof IComponentSyncContext) {
                IComponentSyncContext syncContext = (IComponentSyncContext)o;
                currentRepo = syncContext.localTeamRepository();
                wc = syncContext.getOutgoingTeamPlace();
                if (wc != null) {
                    workspace = wc.getResolvedWorkspace();
                }
                currentComponent = syncContext.getComponent();
            } else if (o instanceof ISubcomponentChange) {
                ISubcomponentChange componentNode = (ISubcomponentChange)o;
                currentRepo = (ITeamRepository)componentNode.getRemoteActivity().getChangeSetHandle().getOrigin();
                wc = componentNode.getContainingWorkspaceConnection();
                if (wc != null) {
                    workspace = wc.getResolvedWorkspace();
                }
                currentComponent = componentNode.getComponent();
            } else if (o instanceof ComponentWrapper) {
                wrapper = (ComponentWrapper)((Object)o);
                currentRepo = ((ComponentWrapper)wrapper).getRepository();
                currentComponent = ((ComponentWrapper)wrapper).getComponent();
            }
            if (repo == null) {
                repo = currentRepo;
            } else if (repo != null && !repo.getId().equals((Object)currentRepo.getId())) {
                return;
            }
            if (component == null) {
                component = currentComponent;
            } else if (component != null && !currentComponent.sameItemId((IItemHandle)component)) {
                return;
            }
            if (workspace != null) {
                workspaces.put(workspace.getItemId(), workspace);
            }
            ++n2;
        }
        if (repo != null && component != null) {
            GraphicalBaselinesEditorInput input = new GraphicalBaselinesEditorInput();
            input.setComponent(component);
            input.setRepository(repo);
            input.setWorkspaces(new ArrayList<IWorkspace>(workspaces.values()));
            GraphicalBaselinesEditor.open(page, input);
        }
    }
}

