/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines;

import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.common.internal.util.StringUtils;
import com.ibm.team.filesystem.ui.UiPlugin;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.internal.filesystem.ui.Messages;
import com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesEditor;
import com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesEditorInput;
import com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.hooks.AddStreamsHook;
import com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.hooks.CompareBaselinesHook;
import com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.hooks.CopyUrlHook;
import com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.hooks.ShowRepositoryFilesViewHook;
import com.ibm.team.internal.filesystem.ui.web.common.EmbeddedBrowser;
import com.ibm.team.repository.rcp.ui.operations.IOperationRunner;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.ui.editor.TeamFormPage;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.Geometry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class GraphicalBaselinesPage
extends TeamFormPage {
    public static final String PAGE_ID = "com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesPage";
    private final GraphicalBaselinesEditorInput fEditorInput;
    private final IOperationRunner fOpRunner;
    private IManagedForm fManagedForm;
    private FormToolkit fToolkit;
    private EmbeddedBrowser fBrowser;
    private boolean debug = !System.getProperty("com.ibm.team.filesystem.BaselineHistoryView.debug", "").isEmpty();
    private String url = "";
    private final GraphicalBaselinesEditor fEditor;
    private boolean saveDialogShownThisSession = false;
    private Action undoAction;
    private Action redoAction;

    public GraphicalBaselinesPage(GraphicalBaselinesEditor editor, GraphicalBaselinesEditorInput editorInput, IOperationRunner opRunner) {
        super((FormEditor)editor, PAGE_ID, "");
        this.fEditorInput = editorInput;
        this.fOpRunner = opRunner;
        this.fEditor = editor;
    }

    public GraphicalBaselinesEditorInput getEditorInput() {
        return this.fEditorInput;
    }

    public IOperationRunner getOperationRunner() {
        return this.fOpRunner;
    }

    protected void setGlobalAction(String actionID, IAction action) {
        IActionBars actionBars = this.getEditorSite().getActionBars();
        actionBars.setGlobalActionHandler(actionID, action);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.fManagedForm = managedForm;
        this.fToolkit = managedForm.getToolkit();
        Composite editorBody = managedForm.getForm().getBody();
        GridLayoutFactory.fillDefaults().extendedMargins(Geometry.createDiffRectangle((int)5, (int)5, (int)5, (int)5)).applyTo(editorBody);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)editorBody);
        Composite browserParent = this.fToolkit.createComposite(editorBody);
        GridLayoutFactory.fillDefaults().applyTo(browserParent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)browserParent);
        this.fBrowser = new EmbeddedBrowser(browserParent, this.fOpRunner);
        this.fBrowser.setNoUrlApology(Messages.GraphicalBaselinesPage_NotInitializedMessage);
        this.undoAction = new Action(Messages.GraphicalBaselinesPage_UndoAction){

            public void run() {
                if (GraphicalBaselinesPage.this.fBrowser.getBrowser() != null && !GraphicalBaselinesPage.this.fBrowser.getBrowser().isDisposed()) {
                    GraphicalBaselinesPage.this.fBrowser.getBrowser().back();
                }
            }
        };
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.undoAction, IAbstractTextEditorHelpContextIds.UNDO_ACTION);
        this.undoAction.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.setGlobalAction(ITextEditorActionConstants.UNDO, (IAction)this.undoAction);
        this.redoAction = new Action(Messages.GraphicalBaselinesPage_RedoAction){

            public void run() {
                if (GraphicalBaselinesPage.this.fBrowser.getBrowser() != null && !GraphicalBaselinesPage.this.fBrowser.getBrowser().isDisposed()) {
                    GraphicalBaselinesPage.this.fBrowser.getBrowser().forward();
                }
            }
        };
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this.redoAction, IAbstractTextEditorHelpContextIds.REDO_ACTION);
        this.redoAction.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.setGlobalAction(ITextEditorActionConstants.REDO, (IAction)this.redoAction);
        this.hookJavaScriptCallbacks();
        Control browserWidget = this.fBrowser.createWidget(0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(browserWidget);
        if (this.fBrowser.getBrowser() != null) {
            this.fBrowser.setRepository(this.fEditorInput.getRepository());
            this.fBrowser.addLocationListener(this.createLocationListener());
            this.fBrowser.setupNetworking();
        }
        this.update(true);
    }

    private LocationListener createLocationListener() {
        return new LocationListener(){

            public void changing(LocationEvent event) {
                String location = event.location;
                GraphicalBaselinesPage.this.trace(NLS.bind((String)"GraphicalBaselinePage asked to change to URL {0}", (Object)location));
                if (GraphicalBaselinesPage.this.fBrowser.shouldAllowLocationChange(event)) {
                    return;
                }
                if (!location.startsWith(String.valueOf(GraphicalBaselinesPage.this.fEditorInput.getBaseUri()) + "/ShowGraphicalBaselines")) {
                    event.doit = false;
                    GraphicalBaselinesPage.this.trace(NLS.bind((String)"GraphicalBaselinePage opening as hyperlink {0}", (Object)location));
                    Hyperlinks.open((URI)URI.create(location), null);
                }
            }

            public void changed(LocationEvent event) {
                String location = event.location;
                if ((location == null || location.length() == 0 || location.startsWith("about:")) && GraphicalBaselinesPage.this.fBrowser.getBrowser().isForwardEnabled()) {
                    GraphicalBaselinesPage.this.fBrowser.getBrowser().forward();
                }
                if (location == null || location.length() == 0 || location.startsWith("about:") || location.indexOf("#") == -1 || location.startsWith("javascript:")) {
                    return;
                }
                GraphicalBaselinesPage.this.undoAction.setEnabled(GraphicalBaselinesPage.this.fBrowser.getBrowser().isBackEnabled());
                GraphicalBaselinesPage.this.redoAction.setEnabled(GraphicalBaselinesPage.this.fBrowser.getBrowser().isForwardEnabled());
                GraphicalBaselinesPage.this.url = event.location;
                GraphicalBaselinesPage.this.fireDirtyStateChanged();
            }
        };
    }

    protected void fireDirtyStateChanged() {
        this.fEditor.fireDirtyStateChanged();
    }

    public void doSave(IProgressMonitor monitor) {
        this.fEditorInput.doSave(this.url);
        this.fireDirtyStateChanged();
    }

    private void hookJavaScriptCallbacks() {
        this.fBrowser.addCallback("showRepositoryFilesView", new ShowRepositoryFilesViewHook(this.fEditorInput.getRepository(), this.getSite(), this.fOpRunner));
        this.fBrowser.addCallback("compareBaselines", new CompareBaselinesHook(this.fEditorInput.getRepository(), this.getSite(), this.fOpRunner));
        this.fBrowser.addCallback("addStreams", new AddStreamsHook(this.fEditorInput.getRepository(), this.fEditorInput.getComponent(), this.getSite()));
        this.fBrowser.addCallback("copyURL", new CopyUrlHook(this));
    }

    private void update(boolean initializing) {
        if (this.fEditorInput == null) {
            return;
        }
        String embeddedUri = this.fEditorInput.getUri(this.debug, initializing);
        this.fBrowser.setUrl(embeddedUri, Messages.GraphicalBaselinesPage_update);
    }

    public void refresh() {
        if (this.fBrowser != null && this.url != null && !this.url.isEmpty()) {
            this.fBrowser.refresh(this.url, Messages.GraphicalBaselinesPage_Refresh);
        }
    }

    public void toggleDebug() {
        if (this.fBrowser != null) {
            this.debug = !this.debug;
            this.update(false);
        }
    }

    public void copyUrl() {
        if (this.fBrowser != null && this.url != null && this.url.trim().length() > 0) {
            Display d = Display.getCurrent();
            Clipboard clipboard = new Clipboard(d);
            TextTransfer tt = TextTransfer.getInstance();
            clipboard.setContents(new Object[]{this.url}, new Transfer[]{tt});
            clipboard.dispose();
        }
    }

    public boolean isDirty() {
        boolean dirty;
        boolean enableEditorSaving = Boolean.getBoolean("com.ibm.team.internal.filesystem.ui.editors.graphicalbaselines.GraphicalBaselinesEditor.enableEditorSaving");
        boolean bl = dirty = !this.url.isEmpty() && !this.fEditorInput.getUri(this.debug, false).equals(this.url);
        if (enableEditorSaving && dirty && !UiPlugin.getBooleanPreference(".graphical_baseline_lifecycle_dialog") && !this.saveDialogShownThisSession) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LifecycleInformationDialog dialog = new LifecycleInformationDialog();
                    dialog.open();
                    GraphicalBaselinesPage.this.saveDialogShownThisSession = true;
                    UiPlugin.getDefault().getPreferenceStore().setValue(".graphical_baseline_lifecycle_dialog", dialog.getToggleState());
                }
            });
        }
        if (enableEditorSaving) {
            return dirty;
        }
        if (dirty) {
            this.fEditorInput.doSave(this.url);
        }
        return false;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fManagedForm.getForm(), "com.ibm.team.filesystem.ide.ui.editor_graphicalbaselines");
        }
    }

    public void dispose() {
        this.fBrowser.dispose();
        this.initialize(null);
        super.dispose();
    }

    public void addContext(String contextUuid) {
        if (this.url.contains(contextUuid) || this.url.indexOf(35) == -1) {
            return;
        }
        String hash = this.url.substring(this.url.indexOf(35));
        String[] parms = hash.split("&");
        if (parms.length < 2 || parms[1].indexOf("contextId") == -1) {
            return;
        }
        parms[1] = String.valueOf(parms[1]) + "," + contextUuid;
        hash = StringUtils.join((String[])parms, (String)"&");
        this.fBrowser.setUrl(String.valueOf(this.url.substring(0, this.url.indexOf(35))) + hash, Messages.GraphicalBaselinesPage_update);
    }

    public void addContexts(List<IWorkspace> streams) {
        if (this.url.indexOf(35) == -1) {
            return;
        }
        ArrayList<String> contextsToAdd = new ArrayList<String>();
        for (IWorkspace stream : streams) {
            String uuidValue = stream.getItemId().getUuidValue();
            if (this.url.contains(uuidValue) || contextsToAdd.contains(uuidValue)) continue;
            contextsToAdd.add(uuidValue);
        }
        if (contextsToAdd.size() == 0) {
            return;
        }
        String hash = this.url.substring(this.url.indexOf(35));
        String[] parms = hash.split("&");
        if (parms.length < 2 || parms[1].indexOf("contextId") == -1) {
            return;
        }
        parms[1] = String.valueOf(parms[1]) + "," + StringUtils.join(contextsToAdd, (String)",");
        hash = StringUtils.join((String[])parms, (String)"&");
        this.fBrowser.setUrl(String.valueOf(this.url.substring(0, this.url.indexOf(35))) + hash, Messages.GraphicalBaselinesPage_update);
    }

    private Log getLog() {
        return LoggingHelper.getLog(((Object)((Object)this)).getClass());
    }

    private void trace(String text) {
        Log log = this.getLog();
        if (log != null) {
            log.trace((Object)text);
        }
    }

    private class LifecycleInformationDialog
    extends MessageDialog {
        private boolean fToggleState;

        public LifecycleInformationDialog() {
            super(GraphicalBaselinesPage.this.getEditor().getSite().getShell(), Messages.GraphicalBaselinesPage_BaselineDiagramTitle, Display.getDefault().getSystemImage(2), Messages.GraphicalBaselinesPage_DiagramLifecycleMessage, 0, new String[]{IDialogConstants.OK_LABEL}, 0);
        }

        protected Control createDialogArea(Composite parent) {
            Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
            this.createToggleButton(dialogAreaComposite);
            dialogAreaComposite.pack();
            return dialogAreaComposite;
        }

        protected Button createToggleButton(Composite parent) {
            final Button button = new Button(parent, 16416);
            button.setText(Messages.GraphicalBaselinesPage_LIFECYCLE_DONT_SHOW_AGAIN);
            GridData data = new GridData(0);
            data.verticalIndent = 10;
            data.horizontalSpan = 2;
            button.setLayoutData((Object)data);
            button.setFont(parent.getFont());
            button.setSelection(this.fToggleState);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LifecycleInformationDialog.this.fToggleState = button.getSelection();
                }
            });
            return button;
        }

        public boolean getToggleState() {
            return this.fToggleState;
        }
    }
}

